/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.initialization.properties.MutableGradleProperties;

public class DefaultGradleProperties
implements MutableGradleProperties {
    private final Map<String, Object> defaultProperties;
    private final Map<String, Object> overrideProperties;
    private ImmutableMap<String, Object> gradleProperties;

    public DefaultGradleProperties(Map<String, Object> defaultProperties, Map<String, Object> overrideProperties) {
        this.defaultProperties = defaultProperties;
        this.overrideProperties = overrideProperties;
        this.gradleProperties = this.mergePropertiesWith((Map<String, Object>)ImmutableMap.of());
    }

    @Nullable
    public Object find(String propertyName) {
        return this.gradleProperties.get((Object)propertyName);
    }

    public Map<String, Object> mergeProperties(Map<String, Object> properties) {
        return properties.isEmpty() ? this.gradleProperties : this.mergePropertiesWith(properties);
    }

    @Override
    public void updateOverrideProperties(Map<String, Object> properties) {
        this.overrideProperties.putAll(properties);
        this.gradleProperties = this.mergePropertiesWith((Map<String, Object>)ImmutableMap.of());
    }

    public Map<String, Object> getProperties() {
        return this.gradleProperties;
    }

    private ImmutableMap<String, Object> mergePropertiesWith(Map<String, Object> properties) {
        return ImmutableMap.builder().putAll(this.defaultProperties).putAll(properties).putAll(this.overrideProperties).buildKeepingLast();
    }
}

