/*
 * Decompiled with CFR 0.152.
 */
package net.rubygrapefruit.platform.internal;

import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import net.rubygrapefruit.platform.NativeException;
import net.rubygrapefruit.platform.internal.AbstractTerminal;
import net.rubygrapefruit.platform.internal.AnsiTerminal;
import net.rubygrapefruit.platform.internal.FunctionResult;
import net.rubygrapefruit.platform.internal.MutableTerminalSize;
import net.rubygrapefruit.platform.internal.TerminalCapabilities;
import net.rubygrapefruit.platform.internal.jni.PosixTerminalFunctions;
import net.rubygrapefruit.platform.internal.jni.TerminfoFunctions;
import net.rubygrapefruit.platform.terminal.TerminalOutput;
import net.rubygrapefruit.platform.terminal.TerminalSize;
import net.rubygrapefruit.platform.terminal.Terminals;

public class TerminfoTerminal
extends AbstractTerminal {
    private final Terminals.Output output;
    private final TerminalCapabilities capabilities = new TerminalCapabilities();
    private final OutputStream outputStream;
    private final Object lock = new Object();
    private Map<TerminalOutput.Color, byte[]> foregroundColors = new HashMap<TerminalOutput.Color, byte[]>();
    private byte[] boldOn;
    private byte[] dim;
    private byte[] defaultForeground;
    private byte[] reset;
    private byte[] hideCursor;
    private byte[] showCursor;
    private byte[] up;
    private byte[] down;
    private byte[] left;
    private byte[] right;
    private byte[] startLine;
    private byte[] clearEOL;
    private TerminalOutput.Color foreground;
    private boolean ansiTerminal;
    private boolean bright;

    public TerminfoTerminal(Terminals.Output output) {
        this.output = output;
        this.outputStream = AbstractTerminal.streamForOutput(output);
    }

    public String toString() {
        return String.format("Curses terminal %s on %s", this.capabilities.terminalName, this.getOutputDisplay());
    }

    private String getOutputDisplay() {
        return this.output.toString().toLowerCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() {
        Object object = this.lock;
        synchronized (object) {
            FunctionResult result = new FunctionResult();
            TerminfoFunctions.initTerminal(this.output.ordinal(), this.capabilities, result);
            if (result.isFailed()) {
                throw new NativeException(String.format("Could not open terminal for %s: %s", this.getOutputDisplay(), result.getMessage()));
            }
            this.ansiTerminal = this.isAnsiTerminal();
            this.hideCursor = TerminfoFunctions.hideCursor(result);
            if (result.isFailed()) {
                throw new NativeException(String.format("Could not determine hide cursor control sequence for %s: %s", this.getOutputDisplay(), result.getMessage()));
            }
            this.showCursor = TerminfoFunctions.showCursor(result);
            if (result.isFailed()) {
                throw new NativeException(String.format("Could not determine show cursor control sequence for %s: %s", this.getOutputDisplay(), result.getMessage()));
            }
            this.defaultForeground = TerminfoFunctions.defaultForeground(result);
            if (result.isFailed()) {
                throw new NativeException(String.format("Could not determine default foreground control sequence for %s: %s", this.getOutputDisplay(), result.getMessage()));
            }
            this.boldOn = TerminfoFunctions.boldOn(result);
            if (result.isFailed()) {
                throw new NativeException(String.format("Could not determine bold on control sequence %s: %s", this.getOutputDisplay(), result.getMessage()));
            }
            this.dim = TerminfoFunctions.dimOn(result);
            if (result.isFailed()) {
                throw new NativeException(String.format("Could not determine dim on control sequence %s: %s", this.getOutputDisplay(), result.getMessage()));
            }
            if (this.dim == null && this.ansiTerminal) {
                this.dim = AnsiTerminal.DIM_ON;
            }
            this.reset = TerminfoFunctions.reset(result);
            if (result.isFailed()) {
                throw new NativeException(String.format("Could not determine reset control sequence for %s: %s", this.getOutputDisplay(), result.getMessage()));
            }
            this.down = TerminfoFunctions.down(result);
            if (result.isFailed()) {
                throw new NativeException(String.format("Could not determine cursor down sequence for %s: %s", this.getOutputDisplay(), result.getMessage()));
            }
            this.up = TerminfoFunctions.up(result);
            if (result.isFailed()) {
                throw new NativeException(String.format("Could not determine cursor up sequence for %s: %s", this.getOutputDisplay(), result.getMessage()));
            }
            this.left = TerminfoFunctions.left(result);
            if (result.isFailed()) {
                throw new NativeException(String.format("Could not determine cursor left sequence for %s: %s", this.getOutputDisplay(), result.getMessage()));
            }
            this.right = TerminfoFunctions.right(result);
            if (result.isFailed()) {
                throw new NativeException(String.format("Could not determine cursor right sequence for %s: %s", this.getOutputDisplay(), result.getMessage()));
            }
            this.startLine = TerminfoFunctions.startLine(result);
            if (result.isFailed()) {
                throw new NativeException(String.format("Could not determine cursor to start of line sequence for %s: %s", this.getOutputDisplay(), result.getMessage()));
            }
            this.clearEOL = TerminfoFunctions.clearToEndOfLine(result);
            if (result.isFailed()) {
                throw new NativeException(String.format("Could not determine clear to end of line sequence for %s: %s", this.getOutputDisplay(), result.getMessage()));
            }
        }
    }

    private boolean isAnsiTerminal() {
        return this.capabilities.terminalName.contains("xterm") || this.capabilities.terminalName.equals("linux");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TerminalSize getTerminalSize() {
        Object object = this.lock;
        synchronized (object) {
            MutableTerminalSize terminalSize = new MutableTerminalSize();
            FunctionResult result = new FunctionResult();
            PosixTerminalFunctions.getTerminalSize(this.output.ordinal(), terminalSize, result);
            if (result.isFailed()) {
                throw new NativeException(String.format("Could not get terminal size for %s: %s", this.getOutputDisplay(), result.getMessage()));
            }
            return terminalSize;
        }
    }

    public boolean supportsColor() {
        return this.getColor(TerminalOutput.Color.Black, false) != null;
    }

    public boolean supportsCursorMotion() {
        return this.up != null && this.down != null && this.left != null && this.right != null && this.startLine != null;
    }

    public boolean supportsTextAttributes() {
        return this.boldOn != null && this.dim != null;
    }

    public boolean supportsCursorVisibility() {
        return this.showCursor != null && this.hideCursor != null;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TerminalOutput foreground(TerminalOutput.Color color) {
        Object object = this.lock;
        synchronized (object) {
            byte[] sequence = this.getColor(color, this.bright);
            if (sequence != null) {
                this.write(sequence);
            }
            this.foreground = color;
        }
        return this;
    }

    private byte[] getColor(TerminalOutput.Color color, boolean bright) {
        if (bright && this.ansiTerminal) {
            return AnsiTerminal.BRIGHT_FOREGROUND.get(color.ordinal());
        }
        byte[] sequence = this.foregroundColors.get((Object)color);
        if (sequence == null) {
            FunctionResult result = new FunctionResult();
            sequence = TerminfoFunctions.foreground(color.ordinal(), result);
            if (result.isFailed()) {
                throw new NativeException(String.format("Could not switch foreground color for %s: %s", this.getOutputDisplay(), result.getMessage()));
            }
            this.foregroundColors.put(color, sequence);
        }
        return sequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TerminalOutput bold() {
        if (!this.supportsTextAttributes()) {
            return this;
        }
        Object object = this.lock;
        synchronized (object) {
            this.write(this.boldOn);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TerminalOutput dim() throws NativeException {
        if (!this.supportsTextAttributes()) {
            return this;
        }
        Object object = this.lock;
        synchronized (object) {
            this.write(this.dim);
            if (this.bright && this.foreground != null) {
                this.write(this.getColor(this.foreground, false));
            }
            this.bright = false;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TerminalOutput bright() throws NativeException {
        Object object = this.lock;
        synchronized (object) {
            this.bright = true;
            if (this.foreground != null) {
                this.write(this.getColor(this.foreground, true));
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TerminalOutput normal() {
        Object object = this.lock;
        synchronized (object) {
            if (this.reset != null) {
                this.write(this.reset);
            }
            this.bright = false;
            if (this.foreground != null) {
                this.write(this.getColor(this.foreground, this.bright));
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TerminalOutput defaultForeground() throws NativeException {
        Object object = this.lock;
        synchronized (object) {
            if (this.defaultForeground != null) {
                this.write(this.defaultForeground);
            }
            this.foreground = null;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TerminalOutput reset() {
        Object object = this.lock;
        synchronized (object) {
            if (this.reset != null) {
                this.write(this.reset);
            }
            if (this.showCursor != null) {
                this.write(this.showCursor);
            }
            this.bright = false;
            this.foreground = null;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TerminalOutput hideCursor() throws NativeException {
        if (!this.supportsCursorVisibility()) {
            return this;
        }
        Object object = this.lock;
        synchronized (object) {
            this.write(this.hideCursor);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TerminalOutput showCursor() throws NativeException {
        Object object = this.lock;
        synchronized (object) {
            if (this.showCursor != null) {
                this.write(this.showCursor);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TerminalOutput cursorDown(int count) {
        Object object = this.lock;
        synchronized (object) {
            if (this.down == null) {
                throw new NativeException(String.format("Cursor down not supported for %s", this.toString()));
            }
            for (int i = 0; i < count; ++i) {
                this.write(this.down);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TerminalOutput cursorUp(int count) {
        Object object = this.lock;
        synchronized (object) {
            if (this.up == null) {
                throw new NativeException(String.format("Cursor up not supported for %s", this.toString()));
            }
            for (int i = 0; i < count; ++i) {
                this.write(this.up);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TerminalOutput cursorLeft(int count) {
        Object object = this.lock;
        synchronized (object) {
            if (this.left == null) {
                throw new NativeException(String.format("Cursor left not supported for %s", this.toString()));
            }
            for (int i = 0; i < count; ++i) {
                this.write(this.left);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TerminalOutput cursorRight(int count) {
        Object object = this.lock;
        synchronized (object) {
            if (this.right == null) {
                throw new NativeException(String.format("Cursor right not supported for %s", this.toString()));
            }
            for (int i = 0; i < count; ++i) {
                this.write(this.right);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TerminalOutput cursorStartOfLine() throws NativeException {
        Object object = this.lock;
        synchronized (object) {
            if (this.startLine == null) {
                throw new NativeException(String.format("Cursor to start of line not supported for %s", this.toString()));
            }
            this.write(this.startLine);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TerminalOutput clearToEndOfLine() throws NativeException {
        Object object = this.lock;
        synchronized (object) {
            if (this.clearEOL == null) {
                throw new NativeException(String.format("Clear to end of line not supported for %s", this.toString()));
            }
            this.write(this.clearEOL);
        }
        return this;
    }
}

