/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.resources;

import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.freecol.common.resources.AudioResource;
import net.sf.freecol.common.resources.ColorResource;
import net.sf.freecol.common.resources.FAFileResource;
import net.sf.freecol.common.resources.FontResource;
import net.sf.freecol.common.resources.ImageResource;
import net.sf.freecol.common.resources.Resource;
import net.sf.freecol.common.resources.SZAResource;
import net.sf.freecol.common.resources.StringResource;
import net.sf.freecol.common.resources.VideoResource;

public class ResourceFactory {
    private static final Logger logger = Logger.getLogger(ResourceFactory.class.getName());
    private final Map<URI, Resource> resources = new HashMap<URI, Resource>();

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Resource createResource(String key, String cachingKey, URI uri) {
        Resource r = this.resources.get(uri);
        if (r != null) {
            return r;
        }
        String pathPart = uri.getPath() != null ? uri.getPath() : (uri.toString().indexOf("!/") >= 0 ? uri.toString().substring(uri.toString().indexOf("!/") + 2) : null);
        try {
            void var6_17;
            if ("urn".equals(uri.getScheme())) {
                if (uri.getSchemeSpecificPart().startsWith("color:")) {
                    ColorResource colorResource = new ColorResource(cachingKey, uri);
                } else {
                    if (!uri.getSchemeSpecificPart().startsWith("font:")) {
                        logger.log(Level.WARNING, "Unknown urn part: " + uri.getSchemeSpecificPart());
                        return null;
                    }
                    FontResource fontResource = new FontResource(cachingKey, uri);
                }
            } else if (pathPart.endsWith("\"") && pathPart.lastIndexOf(34, pathPart.length() - 1) >= 0) {
                StringResource stringResource = new StringResource(cachingKey, uri);
            } else if (pathPart.endsWith(".faf")) {
                FAFileResource fAFileResource = new FAFileResource(cachingKey, uri);
            } else if (pathPart.endsWith(".sza")) {
                SZAResource sZAResource = new SZAResource(cachingKey, uri);
            } else if (pathPart.endsWith(".ttf")) {
                FontResource fontResource = new FontResource(cachingKey, uri);
            } else if (pathPart.endsWith(".wav")) {
                AudioResource audioResource = new AudioResource(cachingKey, uri);
            } else if (pathPart.endsWith(".ogg")) {
                if (pathPart.endsWith(".video.ogg")) {
                    VideoResource videoResource = new VideoResource(cachingKey, uri);
                } else {
                    AudioResource audioResource = new AudioResource(cachingKey, uri);
                }
            } else if (key.startsWith("sound.")) {
                AudioResource audioResource = new AudioResource(cachingKey, uri);
            } else {
                ImageResource imageResource = new ImageResource(cachingKey, uri);
            }
            this.resources.put(uri, (Resource)var6_17);
            return var6_17;
        }
        catch (IOException iOException) {
            logger.log(Level.WARNING, "Failed to create " + uri, iOException);
            return null;
        }
    }
}

