/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.lang.invoke.StringConcatFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.Force;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Named;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.RandomChoice;
import net.sf.freecol.common.util.RandomUtils;
import net.sf.freecol.common.util.StringUtils;

public final class Monarch
extends FreeColGameObject
implements Named {
    private static final Logger logger = Logger.getLogger(Monarch.class.getName());
    public static final String TAG = "monarch";
    public static final int MONARCH_MINIMUM_PRICE = 200;
    public static final int HESSIAN_MINIMUM_PRICE = 5000;
    public static final int MINIMUM_TAX_RATE = 20;
    private Player player;
    private boolean supportSea = false;
    private boolean displeasure = false;
    private Force expeditionaryForce;
    private Force interventionForce;
    private List<UnitType> navalTypes = null;
    private List<UnitType> bombardTypes = null;
    private List<UnitType> landTypes = null;
    private Role mountedRole = null;
    private Role armedRole = null;
    private Role refMountedRole;
    private Role refArmedRole;
    private List<UnitType> mercenaryTypes = null;
    private List<UnitType> navalREFUnitTypes = null;
    private List<UnitType> landREFUnitTypes = null;
    private static final String DISPLEASURE_TAG = "displeasure";
    private static final String EXPEDITIONARY_FORCE_TAG = "expeditionaryForce";
    private static final String INTERVENTION_FORCE_TAG = "interventionForce";
    private static final String PLAYER_TAG = "player";
    private static final String SUPPORT_SEA_TAG = "supportSea";
    private static final String NAME_TAG = "name";
    private static final String MERCENARY_FORCE_TAG = "mercenaryForce";

    public Monarch(Game game, Player player) {
        super(game);
        if (player == null) {
            throw new RuntimeException("player == null: " + this);
        }
        this.player = player;
    }

    public Monarch(Game game, String id) {
        super(game, id);
    }

    protected Player getPlayer() {
        return this.player;
    }

    public Force getExpeditionaryForce() {
        if (this.expeditionaryForce == null) {
            Specification spec = this.getSpecification();
            this.expeditionaryForce = new Force(spec, spec.getUnitList("model.option.refSize"), null);
        }
        return this.expeditionaryForce;
    }

    public Force getInterventionForce() {
        if (this.interventionForce == null) {
            Specification spec = this.getSpecification();
            this.interventionForce = new Force(spec, spec.getUnitList("model.option.interventionForce"), null);
        }
        return this.interventionForce;
    }

    public Force getMercenaryForce() {
        Specification spec = this.getSpecification();
        return new Force(spec, spec.getUnitList("model.option.mercenaryForce"), null);
    }

    public Force getWarSupportForce() {
        Specification spec = this.getSpecification();
        return new Force(spec, spec.getUnitList("model.option.warSupportForce"), null);
    }

    public boolean getSupportSea() {
        return this.supportSea;
    }

    public void setSupportSea(boolean supportSea) {
        this.supportSea = supportSea;
    }

    public boolean getDispleasure() {
        return this.displeasure;
    }

    public void setDispleasure(boolean displeasure) {
        this.displeasure = displeasure;
    }

    private int taxMaximum() {
        return this.getSpecification().getInteger("model.option.maximumTax");
    }

    private void initializeCaches() {
        if (this.navalTypes != null) {
            return;
        }
        Specification spec = this.getSpecification();
        this.navalTypes = new ArrayList<UnitType>();
        this.bombardTypes = new ArrayList<UnitType>();
        this.landTypes = new ArrayList<UnitType>();
        this.mercenaryTypes = new ArrayList<UnitType>();
        this.navalREFUnitTypes = spec.getREFUnitTypes(true);
        this.landREFUnitTypes = spec.getREFUnitTypes(false);
        for (UnitType unitType : spec.getUnitTypeList()) {
            if (unitType.hasAbility("model.ability.supportUnit")) {
                if (unitType.hasAbility("model.ability.navalUnit")) {
                    this.navalTypes.add(unitType);
                } else if (unitType.hasAbility("model.ability.bombard")) {
                    this.bombardTypes.add(unitType);
                } else if (unitType.hasAbility("model.ability.canBeEquipped")) {
                    this.landTypes.add(unitType);
                }
            }
            if (!unitType.hasAbility("model.ability.mercenaryUnit")) continue;
            this.mercenaryTypes.add(unitType);
        }
        for (Role r : spec.getMilitaryRolesList()) {
            boolean ok = r.isAvailableTo(this.player, CollectionUtils.first(this.landTypes));
            boolean armed = r.hasAbility("model.ability.armed");
            boolean mounted = r.hasAbility("model.ability.mounted");
            boolean ref = r.requiresAbility("model.ability.refUnit");
            if (armed && mounted) {
                if (ok && !ref && this.mountedRole == null) {
                    this.mountedRole = r;
                    continue;
                }
                if (ok || !ref || this.refMountedRole != null) continue;
                this.refMountedRole = r;
                continue;
            }
            if (!armed || mounted) continue;
            if (ok && !ref && this.armedRole == null) {
                this.armedRole = r;
                continue;
            }
            if (ok || !ref || this.refArmedRole != null) continue;
            this.refArmedRole = r;
        }
    }

    public List<Player> collectPotentialEnemies() {
        return this.player.hasAbility("model.ability.ignoreEuropeanWars") ? Collections.emptyList() : CollectionUtils.transform(this.getGame().getLiveEuropeanPlayers(this.player), p -> p.isPotentialEnemy(this.player));
    }

    public List<Player> collectPotentialFriends() {
        return CollectionUtils.transform(this.getGame().getLiveEuropeanPlayers(this.player), p -> p.isPotentialFriend(this.player));
    }

    public boolean actionIsValid(MonarchAction action) {
        this.initializeCaches();
        switch (action) {
            case NO_ACTION: {
                return true;
            }
            case RAISE_TAX_ACT: 
            case RAISE_TAX_WAR: {
                return this.player.getTax() < this.taxMaximum();
            }
            case FORCE_TAX: {
                return false;
            }
            case LOWER_TAX_WAR: 
            case LOWER_TAX_OTHER: {
                return this.player.getTax() > 30;
            }
            case WAIVE_TAX: {
                return true;
            }
            case ADD_TO_REF: {
                return !this.navalREFUnitTypes.isEmpty() && !this.landREFUnitTypes.isEmpty();
            }
            case DECLARE_PEACE: {
                return !this.collectPotentialFriends().isEmpty();
            }
            case DECLARE_WAR: {
                return !this.collectPotentialEnemies().isEmpty();
            }
            case SUPPORT_SEA: {
                return this.player.getAttackedByPrivateers() && !this.getSupportSea() && !this.getDispleasure();
            }
            case SUPPORT_LAND: 
            case MONARCH_MERCENARIES: {
                return this.player.isAtWar() && !this.getDispleasure() && this.player.hasSettlements();
            }
            case HESSIAN_MERCENARIES: {
                return this.player.checkGold(5000) && this.player.hasSettlements();
            }
            case DISPLEASURE: {
                return false;
            }
        }
        throw new IllegalArgumentException("Bogus monarch action: " + action);
    }

    public List<RandomChoice<MonarchAction>> getActionChoices() {
        int grace;
        Specification spec = this.getSpecification();
        ArrayList<RandomChoice<MonarchAction>> choices = new ArrayList<RandomChoice<MonarchAction>>();
        int dx = 1 + spec.getInteger("model.option.monarchMeddling");
        int turn = this.getGame().getTurn().getNumber();
        if (turn < (grace = (6 - dx) * 10) || !this.player.hasSettlements() || this.player.getPlayerType() != Player.PlayerType.COLONIAL) {
            return choices;
        }
        this.addIfValid(choices, MonarchAction.NO_ACTION, Math.max(200 - turn, 100));
        this.addIfValid(choices, MonarchAction.RAISE_TAX_ACT, 5 + dx);
        this.addIfValid(choices, MonarchAction.RAISE_TAX_WAR, 5 + dx);
        this.addIfValid(choices, MonarchAction.LOWER_TAX_WAR, 5 - dx);
        this.addIfValid(choices, MonarchAction.LOWER_TAX_OTHER, 5 - dx);
        this.addIfValid(choices, MonarchAction.ADD_TO_REF, 10 + dx);
        this.addIfValid(choices, MonarchAction.DECLARE_PEACE, 6 - dx);
        this.addIfValid(choices, MonarchAction.DECLARE_WAR, 5 + dx);
        if (this.player.checkGold(200)) {
            this.addIfValid(choices, MonarchAction.MONARCH_MERCENARIES, 6 - dx);
        } else if (dx < 3) {
            this.addIfValid(choices, MonarchAction.SUPPORT_LAND, 3 - dx);
        }
        this.addIfValid(choices, MonarchAction.SUPPORT_SEA, 6 - dx);
        this.addIfValid(choices, MonarchAction.HESSIAN_MERCENARIES, 6 - dx);
        return choices;
    }

    private void addIfValid(List<RandomChoice<MonarchAction>> choices, MonarchAction action, int weight) {
        if (this.actionIsValid(action)) {
            choices.add(new RandomChoice<MonarchAction>(action, weight));
        }
    }

    public int raiseTax(Random random) {
        Specification spec = this.getSpecification();
        int taxAdjustment = spec.getInteger("model.option.taxAdjustment");
        int turn = this.getGame().getTurn().getNumber();
        int oldTax = this.player.getTax();
        int adjust = Math.max(1, (6 - taxAdjustment) * 10);
        adjust = 1 + RandomUtils.randomInt(logger, "Tax rise", random, 3 + turn / adjust);
        return Math.min(oldTax + adjust, this.taxMaximum());
    }

    public int lowerTax(Random random) {
        Specification spec = this.getSpecification();
        int taxAdjustment = spec.getInteger("model.option.taxAdjustment");
        int oldTax = this.player.getTax();
        int adjust = Math.max(1, 10 - taxAdjustment);
        adjust = 1 + RandomUtils.randomInt(logger, "Tax reduction", random, adjust);
        return Math.max(oldTax - adjust, 20);
    }

    public UnitType getNavalREFUnitType() {
        this.initializeCaches();
        return CollectionUtils.first(this.navalREFUnitTypes);
    }

    public boolean shouldAddNavalUnit() {
        Force ref = this.getExpeditionaryForce();
        return (double)ref.getCapacity() < (double)ref.getSpaceRequired() * 1.1;
    }

    public AbstractUnit addToREF(Random random) {
        AbstractUnit result;
        List<UnitType> types;
        this.initializeCaches();
        Specification spec = this.getSpecification();
        if (this.shouldAddNavalUnit()) {
            types = this.navalREFUnitTypes;
            if (types.isEmpty()) {
                return null;
            }
            result = new AbstractUnit(RandomUtils.getRandomMember(logger, "Naval REF unit", types, random), "model.role.default", 1);
        } else {
            types = this.landREFUnitTypes;
            if (types.isEmpty()) {
                return null;
            }
            UnitType unitType = RandomUtils.getRandomMember(logger, "Land REF unit", types, random);
            Role role = !unitType.hasAbility("model.ability.canBeEquipped") ? spec.getDefaultRole() : (RandomUtils.randomInt(logger, "Choose land role", random, 3) == 0 ? this.refMountedRole : this.refArmedRole);
            int number = RandomUtils.randomInt(logger, "Choose land#", random, 3) + 1;
            result = new AbstractUnit(unitType, role.getId(), number);
        }
        Force ref = this.getExpeditionaryForce();
        ref.add(result);
        logger.info("Add to " + this.player.getDebugName() + " REF: capacity=" + ref.getCapacity() + " spaceRequired=" + ref.getSpaceRequired() + " => " + result);
        return result;
    }

    public void updateInterventionForce() {
        Specification spec = this.getSpecification();
        int interventionTurns = spec.getInteger("model.option.interventionTurns");
        int updates = this.getGame().getTurn().getNumber() / interventionTurns;
        Force ivf = this.getInterventionForce();
        if (interventionTurns > 0 && updates > 0) {
            for (AbstractUnit au : ivf.getLandUnitsList()) {
                ivf.add(new AbstractUnit(au.getType(spec), au.getRoleId(), updates));
            }
            ivf.prepareToBoard(null);
        }
    }

    public List<AbstractUnit> getSupport(Random random, boolean naval) {
        this.initializeCaches();
        Specification spec = this.getSpecification();
        ArrayList<AbstractUnit> support = new ArrayList<AbstractUnit>();
        if (naval) {
            support.add(new AbstractUnit(RandomUtils.getRandomMember(logger, "Choose naval support", this.navalTypes, random), "model.role.default", 1));
            this.setSupportSea(true);
            return support;
        }
        int difficulty = spec.getInteger("model.option.monarchSupport");
        switch (difficulty) {
            case 4: {
                support.add(new AbstractUnit(RandomUtils.getRandomMember(logger, "Choose bombard", this.bombardTypes, random), "model.role.default", 1));
                support.add(new AbstractUnit(RandomUtils.getRandomMember(logger, "Choose mounted", this.landTypes, random), this.mountedRole.getId(), 2));
                break;
            }
            case 3: {
                support.add(new AbstractUnit(RandomUtils.getRandomMember(logger, "Choose mounted", this.landTypes, random), this.mountedRole.getId(), 2));
                support.add(new AbstractUnit(RandomUtils.getRandomMember(logger, "Choose soldier", this.landTypes, random), this.armedRole.getId(), 1));
                break;
            }
            case 2: {
                support.add(new AbstractUnit(RandomUtils.getRandomMember(logger, "Choose mounted", this.landTypes, random), this.mountedRole.getId(), 2));
                break;
            }
            case 1: {
                support.add(new AbstractUnit(RandomUtils.getRandomMember(logger, "Choose mounted", this.landTypes, random), this.mountedRole.getId(), 1));
                support.add(new AbstractUnit(RandomUtils.getRandomMember(logger, "Choose soldier", this.landTypes, random), this.armedRole.getId(), 1));
                break;
            }
            case 0: {
                support.add(new AbstractUnit(RandomUtils.getRandomMember(logger, "Choose soldier", this.landTypes, random), this.armedRole.getId(), 1));
                break;
            }
        }
        return support;
    }

    public List<AbstractUnit> getWarSupport(Player enemy, Random random) {
        Specification spec = this.getSpecification();
        double baseStrength = this.player.calculateStrength(false);
        double enemyStrength = enemy.calculateStrength(false);
        double strengthRatio = Player.strengthRatio(baseStrength, enemyStrength);
        ArrayList<AbstractUnit> result = new ArrayList<AbstractUnit>();
        double NOSUPPORT = 0.6;
        double p = 10.0 * (0.6 - strengthRatio);
        if (p >= 1.0 || p > 0.0 && p > RandomUtils.randomDouble(logger, "War support?", random)) {
            double ratio;
            double strength;
            double fullRatio;
            double supportStrength;
            block10: {
                Force wsf = this.getWarSupportForce();
                result.addAll(wsf.getUnitList());
                supportStrength = wsf.calculateStrength(false);
                fullRatio = Player.strengthRatio(baseStrength + supportStrength, enemyStrength);
                if (fullRatio < 0.6) {
                    for (AbstractUnit au : result) {
                        au.addToNumber(RandomUtils.randomInt(logger, "Vary war force " + au.getId(), random, 3) - 1);
                    }
                } else if (enemyStrength <= 0.0) {
                    while (result.size() > 1) {
                        result.remove(0);
                    }
                    ((AbstractUnit)result.get(0)).setNumber(1);
                } else {
                    for (AbstractUnit au : result) {
                        for (int n = au.getNumber() - 1; n >= 1; --n) {
                            au.setNumber(n);
                            strength = AbstractUnit.calculateStrength(spec, result);
                            ratio = Player.strengthRatio(baseStrength + strength, enemyStrength);
                            if (!(ratio < 0.6)) {
                                continue;
                            }
                            break block10;
                        }
                    }
                }
            }
            strength = AbstractUnit.calculateStrength(spec, result);
            ratio = Player.strengthRatio(baseStrength + strength, enemyStrength);
            logger.finest("War support: initially=" + supportStrength + "/" + fullRatio + " finally=" + strength + "/" + ratio);
        }
        return result;
    }

    public int loadMercenaries(Random random, List<AbstractUnit> mercs) {
        this.initializeCaches();
        mercs.clear();
        Specification spec = this.getSpecification();
        Role defaultRole = spec.getDefaultRole();
        int mercPrice = spec.getInteger("model.option.mercenaryPrice");
        ArrayList<Role> landRoles = new ArrayList<Role>();
        landRoles.add(this.armedRole);
        landRoles.add(this.mountedRole);
        int count = RandomUtils.randomInt(logger, "Mercenary count", random, 2) + 2;
        int price = 0;
        UnitType unitType = null;
        ArrayList<UnitType> unitTypes = new ArrayList<UnitType>(this.mercenaryTypes);
        while (count > 0 && !unitTypes.isEmpty()) {
            int n;
            unitType = RandomUtils.getRandomMember(logger, "Merc unit", unitTypes, random);
            unitTypes.remove(unitType);
            Role role = unitType.hasAbility("model.ability.canBeEquipped") ? (Role)RandomUtils.getRandomMember(logger, "Merc role", landRoles, random) : defaultRole;
            AbstractUnit au = new AbstractUnit(unitType, role.getId(), 1);
            int newPrice = this.player.getEuropeanPurchasePrice(au);
            if (newPrice <= 0 || newPrice == Integer.MAX_VALUE) break;
            newPrice *= mercPrice / 100;
            for (n = RandomUtils.randomInt(logger, (String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"Merc count \u0001"}, (UnitType)unitType)), random, Math.min(count, 2)) + 1; n > 0 && !this.player.checkGold(price + newPrice * n); --n) {
            }
            if (n > 0) {
                au.setNumber(n);
                mercs.add(au);
                price += newPrice * n;
                count -= n;
                continue;
            }
            unitTypes.remove(unitType);
        }
        return price;
    }

    public int loadMercenaryForce(Random random, List<AbstractUnit> mercs) {
        int price;
        this.initializeCaches();
        mercs.clear();
        mercs.addAll(this.getMercenaryForce().getUnitList());
        ArrayList<Integer> prices = new ArrayList<Integer>(mercs.size());
        for (AbstractUnit au : mercs) {
            price = this.player.getMercenaryHirePrice(au) / au.getNumber();
            prices.add(price);
        }
        int i = 0;
        int mercPrice = 0;
        while (i < mercs.size()) {
            price = (Integer)prices.get(i);
            if (price <= 0 || price == Integer.MAX_VALUE) {
                prices.remove(i);
                mercs.remove(i);
                continue;
            }
            mercPrice += price * mercs.get(i).getNumber();
            ++i;
        }
        while (!mercs.isEmpty()) {
            if (this.player.checkGold(mercPrice)) {
                return mercPrice;
            }
            int r = RandomUtils.randomInt(logger, "merc downsize", random, mercs.size());
            mercPrice -= ((Integer)prices.get(r)).intValue();
            AbstractUnit au = mercs.get(r);
            if (au.getNumber() > 1) {
                au.addToNumber(-1);
                continue;
            }
            prices.remove(r);
            mercs.remove(r);
        }
        return -1;
    }

    @Override
    public String getNameKey() {
        return this.player.getNation().getRulerNameKey();
    }

    @Override
    public <T extends FreeColObject> boolean copyIn(T other) {
        Monarch o = this.copyInCast(other, Monarch.class);
        if (o == null || !super.copyIn(o)) {
            return false;
        }
        Game game = this.getGame();
        this.player = game.updateRef(o.getPlayer());
        this.supportSea = o.getSupportSea();
        this.displeasure = o.getDispleasure();
        this.expeditionaryForce = o.getExpeditionaryForce();
        this.interventionForce = o.getInterventionForce();
        return true;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(PLAYER_TAG, this.player);
        if (xw.validFor(this.player)) {
            xw.writeAttribute(SUPPORT_SEA_TAG, this.supportSea);
            xw.writeAttribute(DISPLEASURE_TAG, this.displeasure);
        }
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        if (xw.validFor(this.player)) {
            this.getExpeditionaryForce().toXML(xw, EXPEDITIONARY_FORCE_TAG);
            this.getInterventionForce().toXML(xw, INTERVENTION_FORCE_TAG);
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.player = xr.findFreeColGameObject(this.getGame(), PLAYER_TAG, Player.class, null, true);
        this.supportSea = xr.getAttribute(SUPPORT_SEA_TAG, false);
        this.displeasure = xr.getAttribute(DISPLEASURE_TAG, false);
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        Specification spec = this.getSpecification();
        if (this.expeditionaryForce == null) {
            this.expeditionaryForce = new Force(spec);
        }
        if (this.interventionForce == null) {
            this.interventionForce = new Force(spec);
        }
        super.readChildren(xr);
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        String tag = xr.getLocalName();
        if (EXPEDITIONARY_FORCE_TAG.equals(tag)) {
            this.expeditionaryForce.readFromXML(xr);
        } else if (INTERVENTION_FORCE_TAG.equals(tag)) {
            this.interventionForce.readFromXML(xr);
        } else if (MERCENARY_FORCE_TAG.equals(tag)) {
            new Force(this.getSpecification()).readFromXML(xr);
        } else {
            super.readChild(xr);
        }
    }

    @Override
    public String getXMLTagName() {
        return TAG;
    }

    public static enum MonarchAction {
        NO_ACTION,
        RAISE_TAX_ACT,
        RAISE_TAX_WAR,
        FORCE_TAX,
        LOWER_TAX_WAR,
        LOWER_TAX_OTHER,
        WAIVE_TAX,
        ADD_TO_REF,
        DECLARE_PEACE,
        DECLARE_WAR,
        SUPPORT_LAND,
        SUPPORT_SEA,
        MONARCH_MERCENARIES,
        HESSIAN_MERCENARIES,
        DISPLEASURE;


        private String getKey() {
            return "monarch.action." + StringUtils.getEnumKey(this);
        }

        public String getTextKey() {
            return "model." + this.getKey() + ".text";
        }

        public String getYesKey() {
            return "model." + this.getKey() + ".yes";
        }

        public String getNoKey() {
            return "model." + this.getKey() + ".no";
        }

        public String getHeaderKey() {
            return "model." + this.getKey() + ".header";
        }
    }
}

