/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

public interface Constants {
    public static final int INFINITY = Integer.MAX_VALUE;
    public static final int UNDEFINED = Integer.MIN_VALUE;
    public static final int STEAL_LAND = -1;

    public static enum TradeSellAction {
        SELL,
        HAGGLE,
        GIFT;

    }

    public static enum TradeBuyAction {
        BUY,
        HAGGLE;

    }

    public static enum TradeAction {
        BUY,
        SELL,
        GIFT;

    }

    public static enum ScoutIndianSettlementAction {
        SCOUT_SETTLEMENT_SPEAK,
        SCOUT_SETTLEMENT_TRIBUTE,
        SCOUT_SETTLEMENT_ATTACK;

    }

    public static enum ScoutColonyAction {
        SCOUT_COLONY_NEGOTIATE,
        SCOUT_COLONY_SPY,
        SCOUT_COLONY_ATTACK;

    }

    public static enum MissionaryAction {
        MISSIONARY_ESTABLISH_MISSION,
        MISSIONARY_DENOUNCE_HERESY,
        MISSIONARY_INCITE_INDIANS;

    }

    public static enum IndianDemandAction {
        INDIAN_DEMAND_ACCEPT,
        INDIAN_DEMAND_REJECT,
        INDIAN_DEMAND_DONE;

    }

    public static enum ClaimAction {
        CLAIM_ACCEPT,
        CLAIM_STEAL;

    }

    public static enum BoycottAction {
        BOYCOTT_PAY_ARREARS,
        BOYCOTT_DUMP_CARGO;

    }

    public static enum ArmedUnitSettlementAction {
        SETTLEMENT_ATTACK,
        SETTLEMENT_TRIBUTE;

    }

    public static enum IntegrityType {
        INTEGRITY_FAIL(-1),
        INTEGRITY_FIXED(0),
        INTEGRITY_GOOD(1);

        private int val;

        private IntegrityType(int val) {
            this.val = val;
        }

        public boolean safe() {
            return this != INTEGRITY_FAIL;
        }

        public IntegrityType combine(IntegrityType it) {
            return IntegrityType.values()[1 + Math.min(this.val, it.val)];
        }

        public IntegrityType fix() {
            return this.combine(INTEGRITY_FIXED);
        }

        public IntegrityType fail() {
            return INTEGRITY_FAIL;
        }
    }
}

