/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.List;
import java.util.function.Predicate;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.util.CollectionUtils;

public class AbstractUnit
extends FreeColObject {
    public static final String TAG = "abstractUnit";
    private String roleId = "model.role.default";
    private int number = 1;
    private static final String ROLE_TAG = "role";
    private static final String NUMBER_TAG = "number";

    public AbstractUnit() {
    }

    public AbstractUnit(String id, String roleId, int number) {
        this.setId(id);
        this.roleId = roleId;
        this.number = number;
    }

    public AbstractUnit(UnitType unitType, String roleId, int number) {
        this(unitType.getId(), roleId, number);
    }

    public AbstractUnit(FreeColXMLReader xr) throws XMLStreamException {
        this.readFromXML(xr);
    }

    public final String getRoleId() {
        return this.roleId;
    }

    public final void setRoleId(String roleId) {
        this.roleId = roleId;
    }

    public final int getNumber() {
        return this.number;
    }

    public final void setNumber(int newNumber) {
        this.number = newNumber;
    }

    public final void addToNumber(int diff) {
        this.number += diff;
    }

    public StringTemplate getSingleLabel() {
        return Messages.getUnitLabel(null, this.getId(), 1, null, this.getRoleId(), null);
    }

    public StringTemplate getLabel() {
        return AbstractUnit.getLabelInternal(this.getId(), this.getRoleId(), this.getNumber());
    }

    private static StringTemplate getLabelInternal(String typeId, String roleId, int number) {
        StringTemplate tmpl = Messages.getUnitLabel(null, typeId, number, null, roleId, null);
        return ((StringTemplate)StringTemplate.template("model.abstractUnit.label").addAmount("%number%", number)).addStringTemplate("%unit%", tmpl);
    }

    public String getDescription() {
        return Messages.message(this.getLabel());
    }

    public UnitType getType(Specification spec) {
        return spec.getUnitType(this.getId());
    }

    public Role getRole(Specification spec) {
        return spec.getRole(this.getRoleId());
    }

    public double getOffence(Specification spec) {
        int n = this.getNumber();
        Role role = this.getRole(spec);
        UnitType type = spec.getUnitType(this.getId());
        return (double)n * (type.getOffence() + role.getOffence());
    }

    public static double calculateStrength(Specification spec, List<AbstractUnit> units) {
        return CollectionUtils.sumDouble(units, au -> au.getOffence(spec));
    }

    public static List<AbstractUnit> deepCopy(List<AbstractUnit> units) {
        return CollectionUtils.transform(units, CollectionUtils.alwaysTrue(), au -> new AbstractUnit(au.getId(), au.getRoleId(), au.getNumber()));
    }

    public static StringTemplate getListLabel(String base, List<AbstractUnit> units) {
        StringTemplate template = StringTemplate.label(base);
        for (AbstractUnit au : units) {
            template.addStringTemplate(au.getLabel());
        }
        return template;
    }

    public boolean matchAll(AbstractUnit other) {
        return this.getId().equals(other.getId()) && this.getRoleId().equals(other.getRoleId()) && this.getNumber() == other.getNumber();
    }

    public static Predicate<AbstractUnit> matcher(UnitType ut, String roleId) {
        return a -> a.getId().equals(ut.getId()) && a.roleId.equals(roleId);
    }

    public static Predicate<AbstractUnit> matcher(AbstractUnit au) {
        return a -> a.getId().equals(au.getId()) && a.getRoleId().equals(au.getRoleId());
    }

    public static Predicate<AbstractUnit> matcher(Unit unit) {
        return AbstractUnit.matcher(unit.getType(), unit.getRole().getId());
    }

    public static boolean matchUnits(List<AbstractUnit> l1, List<AbstractUnit> l2) {
        if (l1.size() != l2.size()) {
            return false;
        }
        for (AbstractUnit au : l1) {
            if (!CollectionUtils.none(l2, a -> a.matchAll(au))) continue;
            return false;
        }
        return true;
    }

    @Override
    public <T extends FreeColObject> boolean copyIn(T other) {
        AbstractUnit o = this.copyInCast(other, AbstractUnit.class);
        if (o == null || !super.copyIn(o)) {
            return false;
        }
        this.roleId = o.getRoleId();
        this.number = o.getNumber();
        return true;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(ROLE_TAG, this.roleId);
        xw.writeAttribute(NUMBER_TAG, this.number);
    }

    @Override
    protected final void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.roleId = xr.getAttribute(ROLE_TAG, "model.role.default");
        this.number = xr.getAttribute(NUMBER_TAG, 1);
    }

    @Override
    public String getXMLTagName() {
        return TAG;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(16);
        sb.append(this.number).append(' ').append(this.getId()).append(" (").append(this.roleId).append(')');
        return sb.toString();
    }
}

