/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel.report;

import java.awt.Component;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.label.ProductionLabel;
import net.sf.freecol.client.gui.label.UnitLabel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.client.gui.panel.report.ReportPanel;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.util.CollectionUtils;

public final class ReportClassicColonyPanel
extends ReportPanel {
    private static final Comparator<Building> buildingTypeComparator = Comparator.comparingInt(b -> b.getType().getIndex()).thenComparing(FreeColObject.fcoComparator);
    private static final int COLONISTS_PER_ROW = 20;
    private static final int UNITS_PER_ROW = 14;
    private static final int GOODS_PER_ROW = 10;
    private static final int BUILDINGS_PER_ROW = 8;
    private final List<Colony> colonies = new ArrayList<Colony>();

    public ReportClassicColonyPanel(FreeColClient freeColClient) {
        super(freeColClient, "reportColonyAction");
        this.colonies.addAll(freeColClient.getMyPlayer().getColonyList());
        this.update();
    }

    /*
     * WARNING - void declaration
     */
    private void update() {
        Specification spec = this.getSpecification();
        ImageLibrary lib = this.getImageLibrary();
        this.reportPanel.removeAll();
        this.reportPanel.setLayout(new MigLayout("fill"));
        for (Colony colony : this.colonies) {
            Object u32;
            JButton button = Utility.getLinkButton(colony.getName(), null, colony.getId());
            button.addActionListener(this);
            this.reportPanel.add((Component)button, "newline, split 2");
            this.reportPanel.add((Component)new JSeparator(0), "growx");
            BuildableType currentType = colony.getCurrentlyBuilding();
            JLabel buildableLabel = null;
            if (currentType != null) {
                buildableLabel = new JLabel(new ImageIcon(lib.getSmallBuildableTypeImage(currentType, colony.getOwner())));
                Utility.localizeToolTip((JComponent)buildableLabel, currentType.getCurrentlyBuildingLabel());
                buildableLabel.setIcon(buildableLabel.getDisabledIcon());
            }
            JPanel colonistsPanel = new JPanel(new GridLayout(0, 20));
            colonistsPanel.setOpaque(false);
            for (Unit unit : CollectionUtils.sort(colony.getUnits(), Unit.typeRoleComparator)) {
                colonistsPanel.add(new UnitLabel(this.getFreeColClient(), unit, true, true));
            }
            JPanel unitsPanel = new JPanel(new GridLayout(0, 14));
            unitsPanel.setOpaque(false);
            for (Object u32 : CollectionUtils.sort(colony.getTile().getUnits(), Unit.typeRoleComparator)) {
                unitsPanel.add(new UnitLabel(this.getFreeColClient(), (Unit)u32, true, true));
            }
            if (buildableLabel != null && spec.getUnitTypeList().contains(currentType)) {
                unitsPanel.add(buildableLabel);
            }
            this.reportPanel.add((Component)colonistsPanel, "newline, growx");
            this.reportPanel.add((Component)unitsPanel, "newline, growx");
            boolean bl = false;
            u32 = CollectionUtils.sort(spec.getGoodsTypeList(), GoodsType.goodsTypeComparator).iterator();
            while (u32.hasNext()) {
                void var10_10;
                GoodsType gt = (GoodsType)u32.next();
                int newValue = colony.getNetProductionOf(gt);
                int stockValue = colony.getGoodsCount(gt);
                if (newValue == 0 && stockValue <= 0) continue;
                int maxProduction = CollectionUtils.sum(colony.getWorkLocationsForProducing(gt), wl -> wl.getMaximumProductionOf(gt));
                ProductionLabel productionLabel = new ProductionLabel(this.getFreeColClient(), new AbstractGoods(gt, newValue), maxProduction, stockValue, true);
                if (var10_10 % 10 == false) {
                    this.reportPanel.add((Component)productionLabel, "newline, split 10");
                } else {
                    this.reportPanel.add(productionLabel);
                }
                ++var10_10;
            }
            JPanel buildingsPanel = new JPanel(new GridLayout(0, 8));
            buildingsPanel.setOpaque(false);
            for (Building building : CollectionUtils.sort(colony.getBuildings(), buildingTypeComparator)) {
                if (building.getType().isAutomaticBuild()) continue;
                JLabel buildingLabel = new JLabel(new ImageIcon(lib.getSmallBuildingImage(building)));
                buildingLabel.setToolTipText(Messages.getName(building));
                buildingsPanel.add(buildingLabel);
            }
            if (buildableLabel != null && spec.getBuildingTypeList().contains(currentType)) {
                buildingsPanel.add(buildableLabel);
            }
            this.reportPanel.add((Component)buildingsPanel, "newline, growx");
        }
    }
}

