/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.dialog;

import java.util.List;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.ChoiceItem;
import net.sf.freecol.client.gui.dialog.FreeColDialog;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.StringTemplate;

public abstract class FreeColInputDialog<T>
extends FreeColDialog<T> {
    private static final Logger logger = Logger.getLogger(FreeColInputDialog.class.getName());

    protected FreeColInputDialog(FreeColClient freeColClient, JFrame frame) {
        super(freeColClient, frame);
    }

    protected FreeColInputDialog(FreeColClient freeColClient, JFrame frame, boolean modal, StringTemplate tmpl, ImageIcon icon, String okKey, String cancelKey) {
        this(freeColClient, frame);
        this.initializeInputDialog(frame, modal, Utility.localizedTextArea(tmpl), icon, okKey, cancelKey);
    }

    protected final void initializeInputDialog(JFrame frame, boolean modal, JComponent jc, ImageIcon icon, String okKey, String cancelKey) {
        List c = FreeColInputDialog.choices();
        c.add(new ChoiceItem<Object>(Messages.message(okKey), null).okOption());
        if (cancelKey != null) {
            c.add(new ChoiceItem<Object>(Messages.message(cancelKey), null).cancelOption().defaultOption());
        }
        this.initializeDialog(frame, FreeColDialog.DialogType.QUESTION, modal, jc, icon, c);
    }

    @Override
    public T getResponse() {
        Object value;
        if (this.responded() && (value = this.getValue()) == this.options.get(0)) {
            return this.getInputValue();
        }
        return null;
    }

    protected abstract T getInputValue();
}

