/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client;

import java.util.logging.Logger;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.control.ConnectController;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.server.FreeColServer;
import org.junit.Assert;

public class ClientTestHelper {
    public static final int port = 3541;
    private static final Logger logger = Logger.getLogger(FreeColClient.class.getName());
    private static FreeColClient client = null;

    public static FreeColClient startClient(FreeColServer freeColServer, Specification specification) {
        System.setProperty("java.awt.headless", "true");
        FreeColDebugger.enableDebugMode(FreeColDebugger.DebugMode.MENUS);
        FreeColDebugger.setDebugRunTurns(1);
        FreeCol.setLocale(null);
        Messages.loadMessageBundle(FreeCol.getLocale());
        logger.info("Debug value: " + FreeColDebugger.isInDebugMode());
        client = FreeCol.startTestClient(specification);
        Assert.assertNotNull((Object)client);
        ConnectController connectController = client.getConnectController();
        client.setFreeColServer(freeColServer);
        client.setSinglePlayer(true);
        boolean ok = connectController.requestLogin("test", null, freeColServer.getHost(), freeColServer.getPort());
        Assert.assertTrue((String)"test login", (boolean)ok);
        connectController.startSinglePlayerGame(specification);
        return client;
    }

    public static void stopClient(FreeColClient client) {
        client.getConnectController().requestLogout(Game.LogoutReason.QUIT);
    }
}

