/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.blockdevicelib.vhd;

import com.amazon.aes.webservices.client.blockdevicelib.ImageVerificationException;
import com.amazon.aes.webservices.client.blockdevicelib.vhd.HardDiskFooter;
import java.nio.ByteBuffer;

public class DynamicDiskHeader {
    public final String cookie;
    public final long dataOffset;
    public final long tableOffset;
    public final int headerVersion;
    public final int maxTableEntries;
    public final int blockSize;
    public final int checkSum;
    public final long uniqueId1;
    public final long uniqueId2;
    public final int parentTimeStamp;
    public final int reserved;
    public final int computedChecksum;

    public DynamicDiskHeader(ByteBuffer buff) {
        this.computedChecksum = HardDiskFooter.computeChecksum(buff, 36, 4);
        byte[] cookieArray = new byte["cxsparse".length()];
        buff.get(cookieArray);
        this.cookie = new String(cookieArray);
        this.dataOffset = buff.getLong();
        this.tableOffset = buff.getLong();
        this.headerVersion = buff.getInt();
        this.maxTableEntries = buff.getInt();
        this.blockSize = buff.getInt();
        this.checkSum = buff.getInt();
        this.uniqueId1 = buff.getLong();
        this.uniqueId2 = buff.getLong();
        this.parentTimeStamp = buff.getInt();
        this.reserved = buff.getInt();
    }

    public void verifyHeader() throws ImageVerificationException {
        if (!"cxsparse".equals(this.cookie)) {
            throw new ImageVerificationException("This does not appear to be a dynamic VHD image. Dynamic disk header starts with " + this.cookie);
        }
        if (this.computedChecksum != this.checkSum) {
            throw new ImageVerificationException("Corrupt Image. VHD dynamic disk header failed checksum validation.");
        }
    }
}

