/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.test.dsig;

import java.security.Security;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import junit.framework.TestCase;
import org.jcp.xml.dsig.internal.dom.XMLDSigRI;

public class SignedInfoTest
extends TestCase {
    private XMLSignatureFactory fac;
    private CanonicalizationMethod cm;
    private SignatureMethod sm;
    private List references;

    public SignedInfoTest() {
        super("SignedInfoTest");
    }

    public SignedInfoTest(String string) {
        super(string);
    }

    public void setUp() throws Exception {
        this.fac = XMLSignatureFactory.getInstance("DOM", new XMLDSigRI());
        this.cm = this.fac.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments", (C14NMethodParameterSpec)null);
        this.sm = this.fac.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#dsa-sha1", null);
        this.references = new Vector();
        this.references.add(this.fac.newReference("http://www.sun.com/index.html", this.fac.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null)));
    }

    public void tearDown() {
    }

    public void testConstructor() {
        SignedInfo signedInfo;
        for (int i = 0; i < 3; ++i) {
            try {
                switch (i) {
                    case 0: {
                        signedInfo = this.fac.newSignedInfo(null, this.sm, this.references);
                        break;
                    }
                    case 1: {
                        signedInfo = this.fac.newSignedInfo(this.cm, null, this.references);
                        break;
                    }
                    case 2: {
                        signedInfo = this.fac.newSignedInfo(this.cm, this.sm, null);
                    }
                }
                SignedInfoTest.fail((String)"Should throw a NPE for null parameter");
                continue;
            }
            catch (NullPointerException nullPointerException) {
                continue;
            }
            catch (Exception exception) {
                SignedInfoTest.fail((String)("Should throw a NPE instead of " + exception + " for null parameter"));
            }
        }
        Vector<String> vector = new Vector<String>();
        try {
            signedInfo = this.fac.newSignedInfo(this.cm, this.sm, vector);
            SignedInfoTest.fail((String)"Should throw an IAE for empty references");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            SignedInfoTest.fail((String)("Should throw an IAE instead of " + exception + " for empty references"));
        }
        vector.add("String");
        try {
            signedInfo = this.fac.newSignedInfo(this.cm, this.sm, vector);
            SignedInfoTest.fail((String)"Should throw an CCE for illegal references");
        }
        catch (ClassCastException classCastException) {
        }
        catch (Exception exception) {
            SignedInfoTest.fail((String)("Should throw an IAE instead of " + exception + " for empty references"));
        }
        signedInfo = this.fac.newSignedInfo(this.cm, this.sm, this.references);
        SignedInfoTest.assertNotNull((Object)signedInfo);
        SignedInfoTest.assertEquals((String)signedInfo.getCanonicalizationMethod().getAlgorithm(), (String)this.cm.getAlgorithm());
        SignedInfoTest.assertEquals((Object)signedInfo.getCanonicalizationMethod().getParameterSpec(), (Object)this.cm.getParameterSpec());
        SignedInfoTest.assertEquals((String)signedInfo.getSignatureMethod().getAlgorithm(), (String)this.sm.getAlgorithm());
        SignedInfoTest.assertEquals((Object)signedInfo.getSignatureMethod().getParameterSpec(), (Object)this.sm.getParameterSpec());
        SignedInfoTest.assertTrue((boolean)Arrays.equals(signedInfo.getReferences().toArray(), this.references.toArray()));
        SignedInfoTest.assertNull((Object)signedInfo.getId());
        signedInfo = this.fac.newSignedInfo(this.cm, this.sm, this.references, null);
        SignedInfoTest.assertNotNull((Object)signedInfo);
        signedInfo = this.fac.newSignedInfo(this.cm, this.sm, this.references, "id");
        SignedInfoTest.assertNotNull((Object)signedInfo);
        SignedInfoTest.assertEquals((String)signedInfo.getId(), (String)"id");
    }

    static {
        Security.insertProviderAt(new XMLDSigRI(), 1);
    }
}

