/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.tracklink.toolwindow.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataKey<T> {
    public static final DataKey<Project> PROJECT = DataKey.create("project");
    public static final Array<VirtualFile> VIRTUAL_FILE_ARRAY = DataKey.createArray("virtualFileArray");
    private final String myDataId;

    public DataKey(String dataId) {
        this.myDataId = dataId;
    }

    @Nullable
    public T getData(DataContext context) {
        return (T)this.getRawData(context);
    }

    @Nullable
    protected Object getRawData(DataContext context) {
        return context.getData(this.myDataId);
    }

    public static <T> DataKey<T> create(String dataId) {
        return new DataKey<T>(dataId);
    }

    public static <T> Array<T> createArray(String dataId) {
        return new Array(dataId);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Array<T>
    extends DataKey<List<T>> {
        public Array(String dataId) {
            super(dataId);
        }

        @Override
        public List<T> getData(DataContext context) {
            Object[] array = (Object[])this.getRawData(context);
            return array != null ? Arrays.asList(array) : null;
        }
    }
}

