/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.tracklink.popup;

import com.almworks.tracker.eapi.alpha.ArtifactInfo;
import com.almworks.tracker.eapi.alpha.ArtifactInfoStatus;
import com.almworks.tracker.eapi.alpha.GenericKeys;
import com.almworks.tracklink.popup.ArtifactInfoList;
import com.almworks.tracklink.popup.ChangeListAdapter;
import com.almworks.tracklink.popup.LiveDialog;
import com.almworks.tracklink.util.HTMLViewer;
import com.almworks.tracklink.util.StringBundle;
import com.almworks.tracklink.util.Utils;
import com.almworks.util.ui.ColorUtil;
import java.awt.Font;
import java.awt.Point;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class HTMLPane
extends JScrollPane {
    private static final Font FONT = UIManager.getFont("Label.font");
    private static final String STYLE_BLOCK = "<head><style>\nbody {margin:2px; background-color:#FFFFD7;}\nbody, td, pre { font-family: " + FONT.getFamily() + "; font-size: " + FONT.getSize() + "pt; }\n" + ".found {background-color:" + ColorUtil.SEARCH_HIGLIGHT_BACKCOLOR_LITERAL + "; color:#FFFFFF;}\n" + ".url { text-align: right; text-decoration: underline; margin-bottom: 8px; }\n" + ".header { font-weight: bold; font-size: " + (int)(1.2f * (float)FONT.getSize()) + "pt; }\n" + ".fields { margin: 8px 0px 0px 0px; }\n" + ".value { margin: 0px 0px 0px 16px; }\n" + ".ctitle, .cuser, .cwhen { font-weight: bold; margin: " + (int)(1.1f * (float)FONT.getSize()) + "px 0px 0px 0px;}\n" + ".cwhen { text-align: right; }\n" + "</style></head>";
    private final HTMLViewer myHTMLViewer = new HTMLViewer();
    private LiveDialog myLiveDialog;
    private String myHighlight;

    public HTMLPane(LiveDialog liveDialog, ArtifactInfoList model) {
        this(liveDialog, model, "");
    }

    public HTMLPane(LiveDialog liveDialog, final ArtifactInfoList model, String highlight) {
        this.myLiveDialog = liveDialog;
        this.myHighlight = highlight;
        this.setViewportView(this.myHTMLViewer);
        this.setBorder(null);
        model.addListDataListener(new ChangeListAdapter(){

            public void contentsChanged(ListDataEvent e) {
                HTMLPane.this.setText(model.getValuesSnapshot());
            }
        });
        this.setText(model.getValuesSnapshot());
    }

    private void setText(List<ArtifactInfo> infos) {
        StringBuffer buffer = new StringBuffer("<html>").append(STYLE_BLOCK).append("\n<body>\n");
        for (ArtifactInfo artifactInfo : infos) {
            ArtifactInfoStatus currentStatus = artifactInfo.getStatus();
            if (currentStatus == ArtifactInfoStatus.OK) {
                String presentation = (String)artifactInfo.getPresentation(GenericKeys.LONG_DESCRIPTION_HTML);
                if (this.myHighlight != null && !this.myHighlight.equals("")) {
                    String html = Utils.getHighlightedHtml(presentation, this.myHighlight);
                    buffer.append(html);
                    continue;
                }
                buffer.append(presentation);
                continue;
            }
            buffer.append(StringBundle.get("html.status", Utils.getStatusPresentation(currentStatus))).append("<br>\n");
        }
        final Point viewPosition = this.getViewport().getViewPosition();
        this.myHTMLViewer.setText(buffer.toString());
        if (viewPosition.x > 0) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    HTMLPane.this.getViewport().setViewPosition(viewPosition);
                }
            });
        }
        this.myLiveDialog.checkSizeAndLocation();
    }

    public JComponent getPreferredFocusedComponent() {
        return this;
    }
}

