/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.lw;

import com.intellij.uiDesigner.compiler.Utils;
import com.intellij.uiDesigner.lw.LwIntroBooleanProperty;
import com.intellij.uiDesigner.lw.LwIntroColorProperty;
import com.intellij.uiDesigner.lw.LwIntroComponentProperty;
import com.intellij.uiDesigner.lw.LwIntroDimensionProperty;
import com.intellij.uiDesigner.lw.LwIntroDoubleProperty;
import com.intellij.uiDesigner.lw.LwIntroEnumProperty;
import com.intellij.uiDesigner.lw.LwIntroFloatProperty;
import com.intellij.uiDesigner.lw.LwIntroFontProperty;
import com.intellij.uiDesigner.lw.LwIntroIconProperty;
import com.intellij.uiDesigner.lw.LwIntroInsetsProperty;
import com.intellij.uiDesigner.lw.LwIntroIntProperty;
import com.intellij.uiDesigner.lw.LwIntroListModelProperty;
import com.intellij.uiDesigner.lw.LwIntroRectangleProperty;
import com.intellij.uiDesigner.lw.LwIntrospectedProperty;
import com.intellij.uiDesigner.lw.LwRbIntroStringProperty;
import com.intellij.uiDesigner.lw.PropertiesProvider;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;

public final class CompiledClassPropertiesProvider
implements PropertiesProvider {
    private final ClassLoader myLoader;
    private final HashMap myCache;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$awt$Insets;
    static /* synthetic */ Class class$java$awt$Dimension;
    static /* synthetic */ Class class$java$awt$Rectangle;
    static /* synthetic */ Class class$java$awt$Color;
    static /* synthetic */ Class class$java$awt$Font;
    static /* synthetic */ Class class$javax$swing$Icon;
    static /* synthetic */ Class class$java$awt$Component;
    static /* synthetic */ Class class$javax$swing$ListModel;

    public CompiledClassPropertiesProvider(ClassLoader loader) {
        if (loader == null) {
            throw new IllegalArgumentException("loader cannot be null");
        }
        this.myLoader = loader;
        this.myCache = new HashMap();
    }

    public HashMap getLwProperties(String className) {
        BeanInfo beanInfo;
        Class<?> aClass;
        if (this.myCache.containsKey(className)) {
            return (HashMap)this.myCache.get(className);
        }
        if (Utils.validateJComponentClass(this.myLoader, className, false) != null) {
            return null;
        }
        try {
            aClass = Class.forName(className, false, this.myLoader);
        }
        catch (ClassNotFoundException exc) {
            throw new RuntimeException(exc.toString());
        }
        try {
            beanInfo = Introspector.getBeanInfo(aClass);
        }
        catch (Throwable e) {
            return null;
        }
        HashMap<String, LwIntrospectedProperty> result = new HashMap<String, LwIntrospectedProperty>();
        PropertyDescriptor[] descriptors = beanInfo.getPropertyDescriptors();
        for (int i = 0; i < descriptors.length; ++i) {
            PropertyDescriptor descriptor = descriptors[i];
            Method readMethod = descriptor.getReadMethod();
            Method writeMethod = descriptor.getWriteMethod();
            if (writeMethod == null || readMethod == null) continue;
            String name = descriptor.getName();
            LwIntrospectedProperty property = CompiledClassPropertiesProvider.propertyFromClass(descriptor.getPropertyType(), name);
            if (property == null) continue;
            property.setDeclaringClassName(descriptor.getReadMethod().getDeclaringClass().getName());
            result.put(name, property);
        }
        this.myCache.put(className, result);
        return result;
    }

    public static LwIntrospectedProperty propertyFromClass(Class propertyType, String name) {
        LwIntrospectedProperty property = Integer.TYPE.equals(propertyType) ? new LwIntroIntProperty(name) : (Boolean.TYPE.equals(propertyType) ? new LwIntroBooleanProperty(name) : (Double.TYPE.equals(propertyType) ? new LwIntroDoubleProperty(name) : (Float.TYPE.equals(propertyType) ? new LwIntroFloatProperty(name) : ((class$java$lang$String == null ? (class$java$lang$String = CompiledClassPropertiesProvider.class$("java.lang.String")) : class$java$lang$String).equals(propertyType) ? new LwRbIntroStringProperty(name) : ((class$java$awt$Insets == null ? (class$java$awt$Insets = CompiledClassPropertiesProvider.class$("java.awt.Insets")) : class$java$awt$Insets).equals(propertyType) ? new LwIntroInsetsProperty(name) : ((class$java$awt$Dimension == null ? (class$java$awt$Dimension = CompiledClassPropertiesProvider.class$("java.awt.Dimension")) : class$java$awt$Dimension).equals(propertyType) ? new LwIntroDimensionProperty(name) : ((class$java$awt$Rectangle == null ? (class$java$awt$Rectangle = CompiledClassPropertiesProvider.class$("java.awt.Rectangle")) : class$java$awt$Rectangle).equals(propertyType) ? new LwIntroRectangleProperty(name) : ((class$java$awt$Color == null ? (class$java$awt$Color = CompiledClassPropertiesProvider.class$("java.awt.Color")) : class$java$awt$Color).equals(propertyType) ? new LwIntroColorProperty(name) : ((class$java$awt$Font == null ? (class$java$awt$Font = CompiledClassPropertiesProvider.class$("java.awt.Font")) : class$java$awt$Font).equals(propertyType) ? new LwIntroFontProperty(name) : ((class$javax$swing$Icon == null ? (class$javax$swing$Icon = CompiledClassPropertiesProvider.class$("javax.swing.Icon")) : class$javax$swing$Icon).equals(propertyType) ? new LwIntroIconProperty(name) : ((class$java$awt$Component == null ? (class$java$awt$Component = CompiledClassPropertiesProvider.class$("java.awt.Component")) : class$java$awt$Component).isAssignableFrom(propertyType) ? new LwIntroComponentProperty(name, propertyType.getName()) : ((class$javax$swing$ListModel == null ? (class$javax$swing$ListModel = CompiledClassPropertiesProvider.class$("javax.swing.ListModel")) : class$javax$swing$ListModel).isAssignableFrom(propertyType) ? new LwIntroListModelProperty(name, propertyType.getName()) : (propertyType.getSuperclass() != null && "java.lang.Enum".equals(propertyType.getSuperclass().getName()) ? new LwIntroEnumProperty(name, propertyType) : null)))))))))))));
        return property;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

