/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.internal.DbTxn;

public class Transaction {
    final DbTxn txn;

    Transaction(DbTxn dbTxn) {
        this.txn = dbTxn;
    }

    public void abort() throws DatabaseException {
        this.txn.abort();
    }

    public void commit() throws DatabaseException {
        this.txn.commit(0);
    }

    public void commitSync() throws DatabaseException {
        this.txn.commit(16384);
    }

    public void commitNoSync() throws DatabaseException {
        this.txn.commit(512);
    }

    public void commitWriteNoSync() throws DatabaseException {
        this.txn.commit(4096);
    }

    public void discard() throws DatabaseException {
        this.txn.discard(0);
    }

    public int getId() throws DatabaseException {
        return this.txn.id();
    }

    public String getName() throws DatabaseException {
        return this.txn.get_name();
    }

    public void prepare(byte[] byArray) throws DatabaseException {
        this.txn.prepare(byArray);
    }

    public void setName(String string) throws DatabaseException {
        this.txn.set_name(string);
    }

    public void setTxnTimeout(long l) throws DatabaseException {
        this.txn.set_timeout(l, 3);
    }

    public void setLockTimeout(long l) throws DatabaseException {
        this.txn.set_timeout(l, 1);
    }
}

