/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.dexbacked;

import com.android.tools.smali.dexlib2.base.BaseAnnotation;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedAnnotationElement;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedDexFile;
import com.android.tools.smali.dexlib2.dexbacked.DexBuffer;
import com.android.tools.smali.dexlib2.dexbacked.DexReader;
import com.android.tools.smali.dexlib2.dexbacked.util.VariableSizeSet;
import java.util.Set;

public class DexBackedAnnotation
extends BaseAnnotation {
    public final DexBackedDexFile dexFile;
    public final int visibility;
    public final int typeIndex;
    private final int elementsOffset;

    public DexBackedAnnotation(DexBackedDexFile dexFile, int annotationOffset) {
        this.dexFile = dexFile;
        DexReader<? extends DexBuffer> reader = dexFile.getDataBuffer().readerAt(annotationOffset);
        this.visibility = reader.readUbyte();
        this.typeIndex = reader.readSmallUleb128();
        this.elementsOffset = reader.getOffset();
    }

    @Override
    public int getVisibility() {
        return this.visibility;
    }

    @Override
    public String getType() {
        return (String)this.dexFile.getTypeSection().get(this.typeIndex);
    }

    public Set<? extends DexBackedAnnotationElement> getElements() {
        DexReader<? extends DexBuffer> reader = this.dexFile.getDataBuffer().readerAt(this.elementsOffset);
        int size = reader.readSmallUleb128();
        return new VariableSizeSet<DexBackedAnnotationElement>(this.dexFile.getDataBuffer(), reader.getOffset(), size){

            @Override
            protected DexBackedAnnotationElement readNextItem(DexReader reader, int index) {
                return new DexBackedAnnotationElement(DexBackedAnnotation.this.dexFile, reader);
            }
        };
    }
}

