<TeXmacs|2.1>

<style|<tuple|tmdoc|old-spacing|framed-session|old-dots|old-lengths>>

<\body>
  <tmdoc-title|Example of <name|Graphviz> sessions>

  You may insert a <name|Graphviz> session using
  <menu|Insert|Session|Graph>viz.

  Type <verbatim|help>, you will get all the available graph backends.

  <\session|dot|default>
    <\output>
      dot - graphviz version 2.43.0 (0)
    </output>

    <\unfolded-io>
      dot]\ 
    <|unfolded-io>
      help
    <|unfolded-io>
      [help, dot, neato, twopi, circo, fdp, sfdp, patchwork, osage]

      dot - graphviz version 2.43.0 (0)
    </unfolded-io>

    <\unfolded-io>
      dot]\ 
    <|unfolded-io>
      neato
    <|unfolded-io>
      neato - graphviz version 2.43.0 (0)
    </unfolded-io>

    <\unfolded-io>
      neato]\ 
    <|unfolded-io>
      twopi
    <|unfolded-io>
      twopi - graphviz version 2.43.0 (0)
    </unfolded-io>

    <\input>
      twopi]\ 
    <|input>
      \;
    </input>
  </session>

  <section|The Magic Line><label|magicline>

  You may control the behavior of the graph generator via the magic line.

  <\session|dot|default>
    <\unfolded-io>
      twopi]\ 
    <|unfolded-io>
      %dot -width 400

      digraph G { a -\<gtr\> b; a -\<gtr\> c; a -\<gtr\> d; a -\<gtr\> f; a
      -\<gtr\> g }
    <|unfolded-io>
      <image|<tuple|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|ps>|400px|||>
    </unfolded-io>

    <\unfolded-io>
      twopi]\ 
    <|unfolded-io>
      %dot -width 300

      digraph G { a -\<gtr\> b; a -\<gtr\> c; a -\<gtr\> d; a -\<gtr\> f; a
      -\<gtr\> g }
    <|unfolded-io>
      <image|<tuple|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|ps>|300px|||>
    </unfolded-io>

    <\unfolded-io>
      twopi]\ 
    <|unfolded-io>
      %neato -width 400

      digraph G { a -\<gtr\> b; a -\<gtr\> c; a -\<gtr\> d; a -\<gtr\> f; a
      -\<gtr\> g }
    <|unfolded-io>
      <image|<tuple|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|ps>|400px|||>
    </unfolded-io>

    <\input>
      twopi]\ 
    <|input>
      %dot -output png

      digraph G { a -\<gtr\> b; a -\<gtr\> c; a -\<gtr\> d; a -\<gtr\> f; a
      -\<gtr\> g }
    </input>
  </session>

  <\big-table|<block*|<tformat|<table|<row|<cell|Option>|<cell|Function>>|<row|<cell|-width>|<cell|control
  the width of the graph>>|<row|<cell|-height>|<cell|control the height of
  the graph>>|<row|<cell|-output>|<cell|control the internal output format of
  the graph>>>>>>
    Options on the magic line
  </big-table>

  Currently, only the <name|Graphviz> backend supports the switch of the
  output format. For some reason, the eps format does not always work fine
  for <name|Graphviz>. Don't worry, you may switch to png via the magic line.

  <section|Foldable>

  Sometimes, we do not care about how to generate the graph, but care about
  the graph itself. In this case we can just\ 

  <\with|par-columns|2>
    <\script-input|dot|default>
      %dot -height 400

      digraph G {

      \ v1 -\<gtr\> v2;

      \ v1 -\<gtr\> v3;

      \ v3 -\<gtr\> v2;

      \ v2 -\<gtr\> v4;

      \ v3 -\<gtr\> v4;

      \ v4 -\<gtr\> v5;

      \ v5 -\<gtr\> v4;

      \ v5 -\<gtr\> v3;

      \ v5 -\<gtr\> v6;

      \ v4 -\<gtr\> v6;

      \ v6 -\<gtr\> v7;

      }
    </script-input|<image|<tuple|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|ps>||400px||>>

    <\with|par-columns|2>
      <\script-output|dot|default>
        %dot -height 400

        digraph G {

        \ v1 -\<gtr\> v2;

        \ v1 -\<gtr\> v3;

        \ v3 -\<gtr\> v2;

        \ v2 -\<gtr\> v4;

        \ v3 -\<gtr\> v4;

        \ v4 -\<gtr\> v5;

        \ v5 -\<gtr\> v4;

        \ v5 -\<gtr\> v3;

        \ v5 -\<gtr\> v6;

        \ v4 -\<gtr\> v6;

        \ v6 -\<gtr\> v7;

        }
      </script-output|<image|<tuple|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|ps>||400px||>>
    </with>
  </with>

  <tmdoc-copyright|2019\U2021|Darcy Shen, Massimiliano Gubinelli>

  <tmdoc-license|Permission is granted to copy, distribute and/or modify this
  document under the terms of the GNU Free Documentation License, Version 1.1
  or any later version published by the Free Software Foundation; with no
  Invariant Sections, with no Front-Cover Texts, and with no Back-Cover
  Texts. A copy of the license is included in the section entitled "GNU Free
  Documentation License".>
</body>

<\initial>
  <\collection>
    <associate|par-hyphen|normal>
    <associate|preamble|false>
  </collection>
</initial>