/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.DrawableSequence;
import jalview.Sequence;
import java.awt.Color;
import java.awt.Graphics;

public class ScoreSequence
extends DrawableSequence {
    double max;
    double min;
    int scoreno;
    int red = 255;
    int green = 255;
    int blue = 255;
    Color c;

    public ScoreSequence(Sequence sequence, int n, int n2, int n3, int n4) {
        super(sequence);
        this.scoreno = n;
        this.findMaxMin();
        this.red = n2;
        this.green = n3;
        this.blue = n4;
        this.c = new Color(n2, n3, n4);
    }

    public ScoreSequence(Sequence sequence, int n) {
        this(sequence, n, 1, 1, 1);
    }

    public ScoreSequence(Sequence sequence) {
        this(sequence, 0, 1, 1, 1);
    }

    public ScoreSequence(String string, String string2, int n, int n2) {
        super(string, string2, n, n2);
        this.scoreno = 0;
        this.findMaxMin();
    }

    public void findMaxMin() {
        int n = 0;
        this.max = -10000.0;
        this.min = 10000.0;
        while (this.score[this.scoreno] != null && n < this.score[this.scoreno].size()) {
            double d = (Double)this.score[this.scoreno].elementAt(n);
            if (d > this.max) {
                this.max = d;
            }
            if (d < this.min) {
                this.min = d;
            }
            ++n;
        }
        System.out.println("Score max/min " + this.max + " " + this.min);
    }

    public void drawSequence(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        this.drawScores(graphics, n, n2, n3, n4, n5, n6);
    }

    public void drawScores(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n;
        while (n7 < n2 && n7 < this.score[this.scoreno].size()) {
            double d = (Double)this.score[this.scoreno].elementAt(n7);
            double d2 = (d - this.min) / (this.max - this.min);
            int n8 = (int)(d2 * (double)n6);
            if (this.c != Color.white) {
                graphics.setColor(this.c);
                graphics.fillRect(n3 + (n7 - n) * n5, n4 + n6 - n8, n5, n8);
            }
            ++n7;
        }
    }
}

