/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css3;

import java.util.ArrayList;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssValueList;

public class CssWordSpaceTransform
extends org.w3c.css.properties.css.CssWordSpaceTransform {
    private static CssIdent[] allowed_action_values;
    private static CssIdent autoPhrase;

    public static CssIdent getMatchingMainIdent(CssIdent ident) {
        for (CssIdent id : allowed_action_values) {
            if (!id.equals(ident)) continue;
            return id;
        }
        return null;
    }

    public CssWordSpaceTransform() {
        this.value = initial;
    }

    public CssWordSpaceTransform(ApplContext ac, CssExpression expression, boolean check) throws InvalidParamException {
        this.setByUser();
        CssValue val = expression.getValue();
        ArrayList<CssValue> values = new ArrayList<CssValue>();
        boolean got_main = false;
        boolean got_auto = false;
        if (check && expression.getCount() > 2) {
            throw new InvalidParamException("unrecognize", ac);
        }
        while (!expression.end()) {
            val = expression.getValue();
            char op = expression.getOperator();
            if (val.getType() != 0) {
                throw new InvalidParamException("value", expression.getValue(), this.getPropertyName(), ac);
            }
            if (CssIdent.isCssWide(val.getIdent())) {
                if (expression.getCount() > 1) {
                    throw new InvalidParamException("value", expression.getValue(), this.getPropertyName(), ac);
                }
                values.add(val);
            } else if (none.equals(val.getIdent())) {
                if (expression.getCount() > 1) {
                    throw new InvalidParamException("value", expression.getValue(), this.getPropertyName(), ac);
                }
                values.add(val);
            } else if (autoPhrase.equals(val.getIdent()) && !got_auto) {
                got_auto = true;
                values.add(val);
            } else if (!got_main) {
                if (CssWordSpaceTransform.getMatchingMainIdent(val.getIdent()) == null) {
                    throw new InvalidParamException("value", expression.getValue(), this.getPropertyName(), ac);
                }
                got_main = true;
                values.add(val);
            } else {
                throw new InvalidParamException("value", expression.getValue(), this.getPropertyName(), ac);
            }
            if (op != ' ') {
                throw new InvalidParamException("operator", Character.valueOf(op), this.getPropertyName(), ac);
            }
            expression.next();
        }
        this.value = values.size() == 1 ? (CssValue)values.get(0) : new CssValueList(values);
    }

    public CssWordSpaceTransform(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    static {
        autoPhrase = CssIdent.getIdent("auto-phrase");
        String[] id_values = new String[]{"space", "ideographic-space"};
        allowed_action_values = new CssIdent[id_values.length];
        int i = 0;
        for (String s : id_values) {
            CssWordSpaceTransform.allowed_action_values[i++] = CssIdent.getIdent(s);
        }
    }
}

