/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.xml;

import nu.validator.xml.AttributesImpl;
import nu.validator.xml.EmptyAttributes;
import nu.validator.xml.SaxEmitter;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class XhtmlSaxEmitter
extends SaxEmitter {
    private final AttributesImpl attrs = new AttributesImpl();
    public static final String XHTML_NS = "http://www.w3.org/1999/xhtml";

    public XhtmlSaxEmitter(ContentHandler contentHandler) {
        super(contentHandler);
    }

    public void startElement(String name, Attributes attrs) throws SAXException {
        this.contentHandler.startElement(XHTML_NS, name, name, attrs);
    }

    public void startElement(String name) throws SAXException {
        this.contentHandler.startElement(XHTML_NS, name, name, EmptyAttributes.EMPTY_ATTRIBUTES);
    }

    public void endElement(String name) throws SAXException {
        this.contentHandler.endElement(XHTML_NS, name, name);
    }

    public void startElementWithClass(String name, String clazz) throws SAXException {
        this.attrs.clear();
        this.attrs.addAttribute("class", clazz);
        this.contentHandler.startElement(XHTML_NS, name, name, this.attrs);
    }

    public void option(String label, String value, boolean selected) throws SAXException {
        this.attrs.clear();
        this.attrs.addAttribute("value", value);
        if (selected) {
            this.attrs.addAttribute("selected", "selected");
        }
        this.startElement("option", this.attrs);
        this.characters(label);
        this.endElement("option");
    }

    public void option(char[] label, String value, boolean selected) throws SAXException {
        this.attrs.clear();
        this.attrs.addAttribute("value", value);
        if (selected) {
            this.attrs.addAttribute("selected", "selected");
        }
        this.startElement("option", this.attrs);
        this.characters(label);
        this.endElement("option");
    }

    public void checkbox(String name, String value, boolean checked) throws SAXException {
        this.attrs.clear();
        this.attrs.addAttribute("type", "checkbox");
        this.attrs.addAttribute("name", name);
        this.attrs.addAttribute("id", name);
        this.attrs.addAttribute("value", value);
        if (checked) {
            this.attrs.addAttribute("checked", "checked");
        }
        this.startElement("input", this.attrs);
        this.endElement("input");
    }
}

