/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.ui.graphs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.Date;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import org.graalvm.visualvm.lib.charts.ChartComponent;
import org.graalvm.visualvm.lib.charts.ChartContext;
import org.graalvm.visualvm.lib.charts.ChartDecorator;
import org.graalvm.visualvm.lib.charts.ChartItem;
import org.graalvm.visualvm.lib.charts.ItemPainter;
import org.graalvm.visualvm.lib.charts.PaintersModel;
import org.graalvm.visualvm.lib.charts.axis.AxisComponent;
import org.graalvm.visualvm.lib.charts.axis.AxisMarksComputer;
import org.graalvm.visualvm.lib.charts.axis.AxisMarksPainter;
import org.graalvm.visualvm.lib.charts.axis.BytesAxisUtils;
import org.graalvm.visualvm.lib.charts.axis.BytesMarksPainter;
import org.graalvm.visualvm.lib.charts.axis.TimeMarksPainter;
import org.graalvm.visualvm.lib.charts.axis.TimelineMarksComputer;
import org.graalvm.visualvm.lib.charts.swing.CrossBorderLayout;
import org.graalvm.visualvm.lib.charts.swing.LongRect;
import org.graalvm.visualvm.lib.charts.swing.Utils;
import org.graalvm.visualvm.lib.charts.xy.BytesXYItemMarksComputer;
import org.graalvm.visualvm.lib.charts.xy.XYItem;
import org.graalvm.visualvm.lib.charts.xy.XYItemPainter;
import org.graalvm.visualvm.lib.charts.xy.synchronous.SynchronousXYItem;
import org.graalvm.visualvm.lib.charts.xy.synchronous.SynchronousXYItemsModel;
import org.graalvm.visualvm.lib.jfluid.results.DataManagerListener;
import org.graalvm.visualvm.lib.jfluid.results.monitor.VMTelemetryDataManager;
import org.graalvm.visualvm.lib.ui.UIUtils;
import org.graalvm.visualvm.lib.ui.charts.xy.ProfilerXYChart;
import org.graalvm.visualvm.lib.ui.charts.xy.ProfilerXYItemPainter;
import org.graalvm.visualvm.lib.ui.charts.xy.ProfilerXYSelectionOverlay;
import org.graalvm.visualvm.lib.ui.charts.xy.ProfilerXYTooltipModel;
import org.graalvm.visualvm.lib.ui.charts.xy.ProfilerXYTooltipOverlay;
import org.graalvm.visualvm.lib.ui.charts.xy.ProfilerXYTooltipPainter;
import org.graalvm.visualvm.lib.ui.components.ColorIcon;
import org.graalvm.visualvm.lib.ui.graphs.ColorFactory;
import org.graalvm.visualvm.lib.ui.graphs.GraphPanel;
import org.graalvm.visualvm.lib.ui.graphs.GraphsUI;
import org.graalvm.visualvm.lib.ui.monitor.VMTelemetryModels;
import org.graalvm.visualvm.lib.ui.swing.InvisibleToolbar;

public final class MemoryGraphPanel
extends GraphPanel {
    private final Color SIZE_COLOR = ColorFactory.getPredefinedColor(0);
    private final Color[] SIZE_GRADIENT = ColorFactory.getPredefinedGradient(0);
    private final Color USED_COLOR = ColorFactory.getPredefinedColor(1);
    private final Color[] USED_GRADIENT = ColorFactory.getPredefinedGradient(1);
    private ProfilerXYChart chart;
    private Action[] chartActions;
    private final VMTelemetryModels models;
    private final DataManagerListener listener;
    private final boolean smallPanel;

    public static MemoryGraphPanel createBigPanel(VMTelemetryModels models) {
        return new MemoryGraphPanel(models, false, null);
    }

    public static MemoryGraphPanel createSmallPanel(VMTelemetryModels models, Action chartAction) {
        return new MemoryGraphPanel(models, true, chartAction);
    }

    private MemoryGraphPanel(VMTelemetryModels models, boolean smallPanel, Action chartAction) {
        this.models = models;
        this.smallPanel = smallPanel;
        this.initComponents(chartAction);
        this.listener = new DataManagerListener(){

            public void dataChanged() {
                MemoryGraphPanel.this.updateData();
            }

            public void dataReset() {
                MemoryGraphPanel.this.resetData();
            }
        };
        models.getDataManager().addDataListener(this.listener);
        this.resetData();
    }

    @Override
    public Action[] getActions() {
        return this.chartActions;
    }

    @Override
    public void cleanup() {
        this.models.getDataManager().removeDataListener(this.listener);
    }

    private void updateData() {
        VMTelemetryDataManager manager;
        long[] timestamps;
        if (this.smallPanel && this.chart.fitsWidth() && (timestamps = manager.timeStamps)[(manager = this.models.getDataManager()).getItemCount() - 1] - timestamps[0] >= 180000L) {
            this.chart.setFitsWidth(false);
        }
    }

    private void resetData() {
        if (this.smallPanel) {
            this.chart.setScale(0.02, 1.0);
            this.chart.setOffset(0L, 0L);
            this.chart.setFitsWidth(true);
        } else {
            this.chart.setScale(0.02, 1.0);
            this.chart.setOffset(0L, 0L);
            this.chart.setFitsWidth(false);
        }
        this.chart.setInitialDataBounds(new LongRect(System.currentTimeMillis(), 0L, 2500L, 0x4000000L));
    }

    private void initComponents(Action chartAction) {
        PaintersModel paintersModel = this.createMemoryPaintersModel();
        this.chart = this.createChart(this.models.memoryItemsModel(), paintersModel, this.smallPanel);
        this.chart.setBackground(GraphsUI.CHART_BACKGROUND_COLOR);
        this.chart.setViewInsets(new Insets(10, 0, 0, 0));
        this.chart.addPreDecorator(this.createMaxHeapDecorator());
        AxisComponent hAxis = new AxisComponent((ChartComponent)this.chart, (AxisMarksComputer)new TimelineMarksComputer(this.models.memoryItemsModel().getTimeline(), this.chart.getChartContext(), 0), (AxisMarksPainter)new TimeMarksPainter(), 1, 2);
        hAxis.setForeground(Color.GRAY);
        SynchronousXYItem memoryItem = this.models.memoryItemsModel().getItem(0);
        XYItemPainter memoryPainter = (XYItemPainter)paintersModel.getPainter((ChartItem)memoryItem);
        AxisComponent vAxis = new AxisComponent((ChartComponent)this.chart, (AxisMarksComputer)new BytesXYItemMarksComputer((XYItem)memoryItem, memoryPainter, this.chart.getChartContext(), 1), (AxisMarksPainter)new BytesMarksPainter(), 7, 2);
        vAxis.setForeground(Color.GRAY);
        JPanel chartPanel = new JPanel((LayoutManager)new CrossBorderLayout());
        chartPanel.setBackground(GraphsUI.CHART_BACKGROUND_COLOR);
        chartPanel.setBorder(BorderFactory.createMatteBorder(10, 10, 5, 5, GraphsUI.CHART_BACKGROUND_COLOR));
        chartPanel.add((Component)((Object)this.chart), new Integer[]{0});
        chartPanel.add((Component)hAxis, new Integer[]{1, 2, 8});
        chartPanel.add((Component)vAxis, new Integer[]{7, 6});
        JScrollBar scroller = new JScrollBar(0);
        this.chart.attachHorizontalScrollBar(scroller);
        chartPanel.add((Component)scroller, new Integer[]{5});
        if (!this.smallPanel) {
            ProfilerXYTooltipPainter tooltipPainter = new ProfilerXYTooltipPainter(this.createTooltipModel());
            this.chart.addOverlayComponent(new ProfilerXYTooltipOverlay((ChartComponent)this.chart, tooltipPainter));
            this.chart.getSelectionModel().setHoverMode(102);
            ProfilerXYSelectionOverlay selectionOverlay = new ProfilerXYSelectionOverlay();
            this.chart.addOverlayComponent(selectionOverlay);
            selectionOverlay.registerChart((ChartComponent)this.chart);
            this.chart.getSelectionModel().setMoveMode(1);
            JPanel chartContainer = new JPanel(new BorderLayout());
            chartContainer.setBorder(BorderFactory.createEmptyBorder());
            chartContainer.add((Component)chartPanel, "Center");
            JPanel sidePanel = new JPanel(new BorderLayout());
            sidePanel.setOpaque(false);
            int h = new JLabel((String)"XXX").getPreferredSize().height;
            sidePanel.setBorder(BorderFactory.createEmptyBorder(h + 17, 0, 0, 10));
            InvisibleToolbar toolbar = new InvisibleToolbar(1);
            toolbar.setOpaque(true);
            toolbar.setBackground(UIUtils.getProfilerResultsBackground());
            toolbar.add(this.chart.toggleViewAction()).setBackground(UIUtils.getProfilerResultsBackground());
            toolbar.add(this.chart.zoomInAction()).setBackground(UIUtils.getProfilerResultsBackground());
            toolbar.add(this.chart.zoomOutAction()).setBackground(UIUtils.getProfilerResultsBackground());
            sidePanel.add((Component)toolbar, "Center");
            JLabel heapSizeBig = new JLabel(GraphsUI.HEAP_SIZE_NAME, new ColorIcon(this.SIZE_COLOR, Color.BLACK, 18, 9), 10);
            heapSizeBig.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            JLabel usedHeapBig = new JLabel(GraphsUI.USED_HEAP_NAME, new ColorIcon(this.USED_COLOR, Color.BLACK, 18, 9), 10);
            usedHeapBig.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            JPanel bigLegendPanel = new JPanel(new FlowLayout(4, 7, 0));
            bigLegendPanel.setBorder(BorderFactory.createEmptyBorder(4, 0, 8, 30));
            bigLegendPanel.setOpaque(true);
            bigLegendPanel.setBackground(UIUtils.getProfilerResultsBackground());
            bigLegendPanel.add(heapSizeBig);
            bigLegendPanel.add(usedHeapBig);
            this.setLayout(new BorderLayout());
            this.setBackground(UIUtils.getProfilerResultsBackground());
            JLabel caption = new JLabel(GraphsUI.MEMORY_CAPTION, 0);
            caption.setFont(caption.getFont().deriveFont(1));
            caption.setBorder(BorderFactory.createEmptyBorder(15, 0, 0, 0));
            caption.setOpaque(true);
            caption.setBackground(UIUtils.getProfilerResultsBackground());
            this.add((Component)caption, "North");
            this.add((Component)chartContainer, "Center");
            this.add((Component)bigLegendPanel, "South");
            this.add((Component)sidePanel, "East");
            this.chartActions = new Action[]{this.chart.zoomInAction(), this.chart.zoomOutAction(), this.chart.toggleViewAction()};
        }
    }

    @Override
    protected ProfilerXYTooltipModel createTooltipModel() {
        return new ProfilerXYTooltipModel(){

            @Override
            public String getTimeValue(long timestamp) {
                return GraphPanel.DATE_FORMATTER.format(new Date(timestamp));
            }

            @Override
            public int getRowsCount() {
                return 2;
            }

            @Override
            public String getRowName(int index) {
                switch (index) {
                    case 0: {
                        return GraphsUI.HEAP_SIZE_NAME;
                    }
                    case 1: {
                        return GraphsUI.USED_HEAP_NAME;
                    }
                }
                return null;
            }

            @Override
            public Color getRowColor(int index) {
                switch (index) {
                    case 0: {
                        return GraphsUI.HEAP_SIZE_PAINTER_FILL_COLOR;
                    }
                    case 1: {
                        return GraphsUI.USED_HEAP_PAINTER_FILL_COLOR;
                    }
                }
                return null;
            }

            @Override
            public String getRowValue(int index, long itemValue) {
                return GraphPanel.INT_FORMATTER.format(itemValue);
            }

            @Override
            public String getRowUnits(int index) {
                return BytesAxisUtils.UNITS_B;
            }

            @Override
            public int getExtraRowsCount() {
                return this.getRowsCount();
            }

            @Override
            public String getExtraRowName(int index) {
                return MemoryGraphPanel.this.getMaxValueString(this.getRowName(index));
            }

            @Override
            public Color getExtraRowColor(int index) {
                return this.getRowColor(index);
            }

            @Override
            public String getExtraRowValue(int index) {
                SynchronousXYItem item = MemoryGraphPanel.this.models.memoryItemsModel().getItem(index);
                return GraphPanel.INT_FORMATTER.format(item.getMaxYValue());
            }

            @Override
            public String getExtraRowUnits(int index) {
                return this.getRowUnits(index);
            }
        };
    }

    private PaintersModel createMemoryPaintersModel() {
        ProfilerXYItemPainter usedHeapPainter;
        ProfilerXYItemPainter heapSizePainter;
        ProfilerXYItemPainter hsp = heapSizePainter = ProfilerXYItemPainter.absolutePainter(2.0f, this.SIZE_COLOR, this.SIZE_GRADIENT[0]);
        ProfilerXYItemPainter uhp = usedHeapPainter = ProfilerXYItemPainter.absolutePainter(2.0f, this.USED_COLOR, this.USED_GRADIENT[0]);
        SynchronousXYItemsModel items = this.models.memoryItemsModel();
        PaintersModel.Default model = new PaintersModel.Default(new ChartItem[]{items.getItem(0), items.getItem(1)}, (ItemPainter[])new XYItemPainter[]{hsp, uhp});
        return model;
    }

    private ChartDecorator createMaxHeapDecorator() {
        return new ChartDecorator(){

            public void paint(Graphics2D g, Rectangle dirtyArea, ChartContext context) {
                int limitHeight = Utils.checkedInt((double)context.getViewY((double)((MemoryGraphPanel)MemoryGraphPanel.this).models.getDataManager().maxHeapSize));
                if (limitHeight <= context.getViewportHeight()) {
                    g.setColor(GraphsUI.HEAP_LIMIT_FILL_COLOR);
                    if (context.isBottomBased()) {
                        g.fillRect(0, 0, context.getViewportWidth(), limitHeight);
                    } else {
                        g.fillRect(0, limitHeight, context.getViewportWidth(), context.getViewportHeight() - limitHeight);
                    }
                }
            }
        };
    }
}

