/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.plaf.BasicScrollingTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.TabCellRenderer;
import org.netbeans.swing.tabcontrol.plaf.TabControlButtonFactory;
import org.netbeans.swing.tabcontrol.plaf.WinXPEditorTabCellRenderer;

public final class WinXPEditorTabDisplayerUI
extends BasicScrollingTabDisplayerUI {
    private static final Rectangle scratch5 = new Rectangle();
    private static Map<Integer, String[]> buttonIconPaths;

    public WinXPEditorTabDisplayerUI(TabDisplayer tabDisplayer) {
        super(tabDisplayer);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new WinXPEditorTabDisplayerUI((TabDisplayer)jComponent);
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        int n = 24;
        Graphics2D graphics2D = BasicScrollingTabDisplayerUI.getOffscreenGraphics(jComponent);
        if (graphics2D != null) {
            FontMetrics fontMetrics = graphics2D.getFontMetrics(this.displayer.getFont());
            Insets insets = this.getTabAreaInsets();
            n = fontMetrics.getHeight() + insets.top + insets.bottom + 8;
        }
        return new Dimension(this.displayer.getWidth(), n);
    }

    @Override
    protected Font createFont() {
        return UIManager.getFont("Label.font");
    }

    @Override
    public void paintBackground(Graphics graphics) {
        graphics.setColor(this.displayer.getBackground());
        graphics.fillRect(0, 0, this.displayer.getWidth(), this.displayer.getHeight());
    }

    @Override
    protected void paintAfterTabs(Graphics graphics) {
        Rectangle rectangle = new Rectangle();
        this.getTabsVisibleArea(rectangle);
        rectangle.width = this.displayer.getWidth();
        Insets insets = this.getTabAreaInsets();
        int n = this.displayer.getHeight() - 3;
        int n2 = 0;
        int n3 = this.selectionModel.getSelectedIndex();
        graphics.setColor(WinXPEditorTabCellRenderer.getSelectedTabBottomLineColor());
        graphics.drawLine(0, n + 1, this.displayer.getWidth(), n + 1);
        int n4 = this.getTabsAreaWidth();
        boolean bl = n3 != -1 && (n3 < this.scroll().getLastVisibleTab(n4) || n3 <= this.scroll().getLastVisibleTab(n4) && !this.scroll().isLastTabClipped()) && n3 >= this.scroll().getFirstVisibleTab(n4);
        graphics.setColor(UIManager.getColor("controlLtHighlight"));
        if (bl) {
            this.getTabRect(n3, scratch5);
            if (WinXPEditorTabDisplayerUI.scratch5.width != 0) {
                if (rectangle.x < WinXPEditorTabDisplayerUI.scratch5.x) {
                    graphics.drawLine(rectangle.x, n, WinXPEditorTabDisplayerUI.scratch5.x + 1, n);
                }
                if (WinXPEditorTabDisplayerUI.scratch5.x + WinXPEditorTabDisplayerUI.scratch5.width < rectangle.x + rectangle.width) {
                    n2 = WinXPEditorTabDisplayerUI.scratch5.x + WinXPEditorTabDisplayerUI.scratch5.width;
                    if (!this.scroll().isLastTabClipped()) {
                        --n2;
                    }
                    graphics.drawLine(n2, n, rectangle.x + rectangle.width, n);
                }
            }
        } else {
            graphics.drawLine(rectangle.x, n, rectangle.x + rectangle.width, n);
        }
        graphics.setColor(WinXPEditorTabCellRenderer.getBorderColor());
        graphics.drawLine(0, n - 1, 0, this.displayer.getHeight());
        graphics.drawLine(this.displayer.getWidth() - 1, n - 1, this.displayer.getWidth() - 1, this.displayer.getHeight());
        int n5 = this.scroll().getLastVisibleTab(n4);
        boolean bl2 = false;
        if (n5 >= 0) {
            this.getTabRect(n5, scratch5);
            n5 = WinXPEditorTabDisplayerUI.scratch5.x + WinXPEditorTabDisplayerUI.scratch5.width;
        }
        graphics.drawLine(n5, n - 1, this.displayer.getWidth(), n - 1);
    }

    @Override
    protected TabCellRenderer createDefaultRenderer() {
        return new WinXPEditorTabCellRenderer();
    }

    private static void initIcons() {
        if (null == buttonIconPaths) {
            buttonIconPaths = new HashMap<Integer, String[]>(7);
            String[] stringArray = new String[4];
            stringArray[0] = "org/netbeans/swing/tabcontrol/resources/xp_scrollleft_enabled.png";
            stringArray[2] = "org/netbeans/swing/tabcontrol/resources/xp_scrollleft_disabled.png";
            stringArray[3] = "org/netbeans/swing/tabcontrol/resources/xp_scrollleft_rollover.png";
            stringArray[1] = "org/netbeans/swing/tabcontrol/resources/xp_scrollleft_pressed.png";
            buttonIconPaths.put(9, stringArray);
            stringArray = new String[4];
            stringArray[0] = "org/netbeans/swing/tabcontrol/resources/xp_scrollright_enabled.png";
            stringArray[2] = "org/netbeans/swing/tabcontrol/resources/xp_scrollright_disabled.png";
            stringArray[3] = "org/netbeans/swing/tabcontrol/resources/xp_scrollright_rollover.png";
            stringArray[1] = "org/netbeans/swing/tabcontrol/resources/xp_scrollright_pressed.png";
            buttonIconPaths.put(10, stringArray);
            stringArray = new String[4];
            stringArray[0] = "org/netbeans/swing/tabcontrol/resources/xp_popup_enabled.png";
            stringArray[2] = "org/netbeans/swing/tabcontrol/resources/xp_popup_disabled.png";
            stringArray[3] = "org/netbeans/swing/tabcontrol/resources/xp_popup_rollover.png";
            stringArray[1] = "org/netbeans/swing/tabcontrol/resources/xp_popup_pressed.png";
            buttonIconPaths.put(8, stringArray);
            stringArray = new String[4];
            stringArray[0] = "org/netbeans/swing/tabcontrol/resources/xp_maximize_enabled.png";
            stringArray[2] = "org/netbeans/swing/tabcontrol/resources/xp_maximize_disabled.png";
            stringArray[3] = "org/netbeans/swing/tabcontrol/resources/xp_maximize_rollover.png";
            stringArray[1] = "org/netbeans/swing/tabcontrol/resources/xp_maximize_pressed.png";
            buttonIconPaths.put(3, stringArray);
            stringArray = new String[4];
            stringArray[0] = "org/netbeans/swing/tabcontrol/resources/xp_restore_enabled.png";
            stringArray[2] = "org/netbeans/swing/tabcontrol/resources/xp_restore_disabled.png";
            stringArray[3] = "org/netbeans/swing/tabcontrol/resources/xp_restore_rollover.png";
            stringArray[1] = "org/netbeans/swing/tabcontrol/resources/xp_restore_pressed.png";
            buttonIconPaths.put(4, stringArray);
        }
    }

    @Override
    public Icon getButtonIcon(int n, int n2) {
        Icon icon = null;
        WinXPEditorTabDisplayerUI.initIcons();
        String[] stringArray = buttonIconPaths.get(n);
        if (null != stringArray && n2 >= 0 && n2 < stringArray.length) {
            icon = TabControlButtonFactory.getIcon(stringArray[n2]);
        }
        return icon;
    }
}

