/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.progress;

import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.progress.spi.ExtractedProgressUIWorker;
import org.netbeans.modules.progress.spi.InternalHandle;
import org.netbeans.modules.progress.spi.ProgressEvent;
import org.netbeans.modules.progress.spi.ProgressUIWorkerProvider;
import org.netbeans.modules.progress.spi.SwingController;
import org.netbeans.modules.progress.spi.UIInternalHandle;
import org.netbeans.progress.module.TrivialProgressUIWorkerProvider;
import org.netbeans.progress.module.UIInternalHandleAccessor;
import org.openide.util.Cancellable;
import org.openide.util.Lookup;

public final class ProgressHandleFactory {
    private static ProgressUIWorkerProvider TRIVIAL_PROVIDER = new TrivialProgressUIWorkerProvider();

    private ProgressHandleFactory() {
    }

    @Deprecated
    public static ProgressHandle createHandle(String string) {
        return ProgressHandleFactory.createHandle(string, (Action)null);
    }

    @Deprecated
    public static ProgressHandle createHandle(String string, Cancellable cancellable) {
        return ProgressHandleFactory.createHandle(string, cancellable, null);
    }

    @Deprecated
    public static ProgressHandle createHandle(String string, Action action) {
        return ProgressHandleFactory.createHandle(string, null, action);
    }

    @Deprecated
    public static ProgressHandle createHandle(String string, Cancellable cancellable, Action action) {
        return ProgressHandle.createHandle((String)string, (Cancellable)cancellable, (Action)action);
    }

    public static ProgressHandle createUIHandle(String string, Cancellable cancellable, Action action) {
        return new UIInternalHandle(string, cancellable, true, action).createProgressHandle();
    }

    public static JComponent createProgressComponent(ProgressHandle progressHandle) {
        return ProgressHandleFactory.ihextract(progressHandle).getProgressComponent();
    }

    public static JLabel createMainLabelComponent(ProgressHandle progressHandle) {
        return ProgressHandleFactory.ihextract(progressHandle).getMainLabelComponent();
    }

    public static JLabel createDetailLabelComponent(ProgressHandle progressHandle) {
        return ProgressHandleFactory.ihextract(progressHandle).getDetailLabelComponent();
    }

    @Deprecated
    public static ProgressHandle createSystemHandle(String string) {
        return ProgressHandleFactory.createSystemHandle(string, null, null);
    }

    @Deprecated
    public static ProgressHandle createSystemHandle(String string, Cancellable cancellable) {
        return ProgressHandleFactory.createSystemHandle(string, cancellable, null);
    }

    @Deprecated
    public static ProgressHandle createSystemHandle(String string, Cancellable cancellable, Action action) {
        return ProgressHandle.createSystemHandle((String)string, (Cancellable)cancellable, (Action)action);
    }

    public static ProgressHandle createSystemUIHandle(String string, Cancellable cancellable, Action action) {
        return new UIInternalHandle(string, cancellable, false, action).createProgressHandle();
    }

    private static ExtractedProgressUIWorker ihextract(ProgressHandle progressHandle) {
        ExtractedProgressUIWorker extractedProgressUIWorker;
        InternalHandle internalHandle = progressHandle.getInternalHandle();
        if (internalHandle instanceof UIInternalHandle) {
            return new UIHandleExtractor((UIInternalHandle)internalHandle);
        }
        ProgressUIWorkerProvider progressUIWorkerProvider = (ProgressUIWorkerProvider)Lookup.getDefault().lookup(ProgressUIWorkerProvider.class);
        if (progressUIWorkerProvider == null) {
            progressUIWorkerProvider = TRIVIAL_PROVIDER;
        }
        if ((extractedProgressUIWorker = progressUIWorkerProvider.extractProgressWorker(internalHandle)) != null) {
            return new ForeignExtractor(internalHandle, extractedProgressUIWorker);
        }
        return null;
    }

    private static class UIHandleExtractor
    implements ExtractedProgressUIWorker {
        private final UIInternalHandle uiih;

        public UIHandleExtractor(UIInternalHandle uIInternalHandle) {
            this.uiih = uIInternalHandle;
        }

        @Override
        public JComponent getProgressComponent() {
            return this.uiih.extractComponent();
        }

        @Override
        public JLabel getMainLabelComponent() {
            return this.uiih.extractMainLabel();
        }

        @Override
        public JLabel getDetailLabelComponent() {
            return this.uiih.extractDetailLabel();
        }

        public void processProgressEvent(ProgressEvent progressEvent) {
            throw new UnsupportedOperationException("Never called.");
        }

        public void processSelectedProgressEvent(ProgressEvent progressEvent) {
            throw new UnsupportedOperationException("Never called.");
        }
    }

    private static class ForeignExtractor
    implements ExtractedProgressUIWorker {
        private final InternalHandle ih;
        private final ExtractedProgressUIWorker del;

        public ForeignExtractor(InternalHandle internalHandle, ExtractedProgressUIWorker extractedProgressUIWorker) {
            this.del = extractedProgressUIWorker;
            this.ih = internalHandle;
        }

        void customPlaced() {
            boolean bl = this.ih.isCustomPlaced();
            UIInternalHandleAccessor uIInternalHandleAccessor = UIInternalHandleAccessor.instance();
            uIInternalHandleAccessor.markCustomPlaced(this.ih);
            if (!bl) {
                uIInternalHandleAccessor.setController(this.ih, new SwingController(this.del));
            }
        }

        @Override
        public JComponent getProgressComponent() {
            this.customPlaced();
            return this.del.getProgressComponent();
        }

        @Override
        public JLabel getMainLabelComponent() {
            this.customPlaced();
            return this.del.getMainLabelComponent();
        }

        @Override
        public JLabel getDetailLabelComponent() {
            this.customPlaced();
            return this.del.getDetailLabelComponent();
        }

        public void processProgressEvent(ProgressEvent progressEvent) {
            this.del.processProgressEvent(progressEvent);
        }

        public void processSelectedProgressEvent(ProgressEvent progressEvent) {
            this.del.processSelectedProgressEvent(progressEvent);
        }
    }
}

