/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.ui;

import java.util.HashMap;
import java.util.Map;
import javax.accessibility.AccessibleContext;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.graalvm.visualvm.heapviewer.model.DataType;
import org.graalvm.visualvm.heapviewer.model.ErrorNode;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNode;
import org.graalvm.visualvm.heapviewer.model.LoopNode;
import org.graalvm.visualvm.heapviewer.model.ProgressNode;
import org.graalvm.visualvm.heapviewer.ui.Bundle;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerRenderer;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.graalvm.visualvm.lib.ui.swing.renderer.LabelRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.NormalBoldGrayRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.ProfilerRenderer;

class TreeTableViewRenderer
implements ProfilerRenderer {
    private final HeapViewerRenderer FALLBACK = new FallbackRenderer();
    private final Map<Class<? extends HeapViewerNode>, HeapViewerRenderer> lookup = new HashMap<Class<? extends HeapViewerNode>, HeapViewerRenderer>();
    private ProfilerRenderer current = this.FALLBACK;

    TreeTableViewRenderer() {
        this.lookup.put(LoopNode.class, new LoopNodeRenderer());
        this.lookup.put(ProgressNode.class, new ProgressNodeRenderer());
        this.lookup.put(ErrorNode.class, new ErrorNodeRenderer());
    }

    void registerRenderers(Map<Class<? extends HeapViewerNode>, HeapViewerRenderer> renderers) {
        this.lookup.putAll(renderers);
    }

    public void setValue(Object value, int row) {
        this.current = this.resolve(value.getClass());
        this.current.setValue(value, row);
    }

    public int getHorizontalAlignment() {
        return this.current.getHorizontalAlignment();
    }

    public JComponent getComponent() {
        return this.current.getComponent();
    }

    public void move(int x, int y) {
        this.current.move(x, y);
    }

    public AccessibleContext getAccessibleContext() {
        return this.current.getAccessibleContext();
    }

    public String toString() {
        return this.current.toString();
    }

    HeapViewerRenderer resolve(Class cls) {
        HeapViewerRenderer renderer = this.lookup.get(cls);
        while (renderer == null && cls != null) {
            cls = cls.getSuperclass();
            renderer = this.lookup.get(cls);
        }
        return renderer != null ? renderer : this.FALLBACK;
    }

    private static class FallbackRenderer
    extends LabelRenderer
    implements HeapViewerRenderer {
        private FallbackRenderer() {
        }
    }

    private static class ErrorNodeRenderer
    extends LabelRenderer
    implements HeapViewerRenderer {
        ErrorNodeRenderer() {
            this.setIcon(Icons.getIcon((String)"GeneralIcons.Error"));
        }

        public void setValue(Object value, int row) {
            this.setText(value == null ? "" : value.toString());
        }

        @Override
        public String getShortName() {
            return this.getText();
        }
    }

    private static class ProgressNodeRenderer
    extends NormalBoldGrayRenderer
    implements HeapViewerRenderer {
        ProgressNodeRenderer() {
            this.setNormalValue("X");
            this.setBoldValue("  ");
            this.setIcon(Icons.getIcon((String)"HeapWalkerIcons.Progress"));
        }

        public void setValue(Object value, int row) {
            ProgressNode node = (ProgressNode)((Object)value);
            String text = node.getText();
            String progressText = node.getProgressText();
            this.setNormalValue(text);
            this.setGrayValue(progressText);
        }

        @Override
        public String getShortName() {
            return this.getNormalValue();
        }
    }

    private class LoopNodeRenderer
    implements HeapViewerRenderer {
        private HeapViewerRenderer impl;

        private LoopNodeRenderer() {
        }

        public void setValue(Object value, int row) {
            HeapViewerNode loop = HeapViewerNode.getValue((HeapViewerNode)((Object)value), DataType.LOOP, null);
            this.impl = TreeTableViewRenderer.this.resolve(((Object)((Object)loop)).getClass());
            this.impl.setValue(value, row);
        }

        public int getHorizontalAlignment() {
            return this.impl.getHorizontalAlignment();
        }

        public JComponent getComponent() {
            return this.impl.getComponent();
        }

        public void move(int x, int y) {
            this.impl.move(x, y);
        }

        public AccessibleContext getAccessibleContext() {
            return this.impl.getAccessibleContext();
        }

        @Override
        public Icon getIcon() {
            return this.impl.getIcon();
        }

        @Override
        public String getShortName() {
            return Bundle.TreeTableViewRenderer_Loop(this.impl.getShortName());
        }

        public String toString() {
            return this.impl.toString();
        }
    }
}

