/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.netbeans.InvalidException;
import org.netbeans.Module;
import org.openide.modules.Dependency;
import org.openide.modules.SpecificationVersion;
import org.openide.util.BaseUtilities;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.TopologicalSortException;

public final class NbProblemDisplayer {
    private NbProblemDisplayer() {
    }

    public static String messageForProblem(Module module, Object object) {
        return NbProblemDisplayer.messageForProblem(module, object, true);
    }

    static String messageForProblem(Module module, Object object, boolean bl) {
        if (object instanceof InvalidException) {
            String string = Exceptions.findLocalizedMessage((Throwable)((InvalidException)((Object)object)));
            return string != null ? string : object.toString();
        }
        Dependency dependency = (Dependency)object;
        switch (dependency.getType()) {
            case 1: {
                Module module2;
                String string = (String)module.getLocalizedAttribute("OpenIDE-Module-Module-Dependency-Message");
                if (string != null) {
                    return string;
                }
                String string2 = dependency.getName();
                int n = string2.lastIndexOf(47);
                if (n != -1) {
                    string2 = string2.substring(0, n);
                }
                if ((module2 = module.getManager().get(string2)) != null && module2.getCodeName().equals(dependency.getName())) {
                    switch (dependency.getComparison()) {
                        case 3: {
                            return NbBundle.getMessage(NbProblemDisplayer.class, (String)"MSG_problem_other_disabled", (Object)NbProblemDisplayer.label(module2, bl));
                        }
                        case 2: {
                            String string3;
                            String string4 = dependency.getVersion();
                            String string5 = string3 = module2.getImplementationVersion() != null ? module2.getImplementationVersion() : NbBundle.getMessage(NbProblemDisplayer.class, (String)"LBL_no_impl_version");
                            if (string4.equals(string3)) {
                                return NbBundle.getMessage(NbProblemDisplayer.class, (String)"MSG_problem_other_disabled", (Object)NbProblemDisplayer.label(module2, bl));
                            }
                            return NbBundle.getMessage(NbProblemDisplayer.class, (String)"MSG_problem_other_wrong_version", (Object)NbProblemDisplayer.label(module2, bl), (Object)string4, (Object)string3);
                        }
                        case 1: {
                            SpecificationVersion specificationVersion;
                            SpecificationVersion specificationVersion2 = new SpecificationVersion(dependency.getVersion());
                            SpecificationVersion specificationVersion3 = specificationVersion = module2.getSpecificationVersion() != null ? module2.getSpecificationVersion() : new SpecificationVersion("0");
                            if (specificationVersion.compareTo(specificationVersion2) >= 0) {
                                return NbBundle.getMessage(NbProblemDisplayer.class, (String)"MSG_problem_other_disabled", (Object)NbProblemDisplayer.label(module2, bl));
                            }
                            return NbBundle.getMessage(NbProblemDisplayer.class, (String)"MSG_problem_other_too_old", (Object)NbProblemDisplayer.label(module2, bl), (Object)specificationVersion2, (Object)specificationVersion);
                        }
                    }
                    throw new IllegalStateException();
                }
                return NbBundle.getMessage(NbProblemDisplayer.class, (String)"MSG_problem_other_needed_not_found", (Object)dependency.getName());
            }
            case 5: 
            case 6: {
                String string = (String)module.getLocalizedAttribute("OpenIDE-Module-Requires-Message");
                if (string != null) {
                    return string;
                }
                for (Module module3 : module.getManager().getModules()) {
                    if (!module3.provides(dependency.getName())) continue;
                    return NbBundle.getMessage(NbProblemDisplayer.class, (String)"MSG_problem_require_disabled", (Object)dependency.getName());
                }
                return NbBundle.getMessage(NbProblemDisplayer.class, (String)"MSG_problem_require_not_found", (Object)dependency.getName());
            }
            case 2: {
                String string = (String)module.getLocalizedAttribute("OpenIDE-Module-Package-Dependency-Message");
                if (string != null) {
                    return string;
                }
                String string6 = dependency.getName();
                int n = string6.lastIndexOf(91);
                if (n == 0) {
                    return NbBundle.getMessage(NbProblemDisplayer.class, (String)"MSG_problem_class_not_loaded", (Object)string6.substring(1, string6.length() - 1));
                }
                if (n != -1) {
                    return NbBundle.getMessage(NbProblemDisplayer.class, (String)"MSG_problem_package_not_loaded_or_old", (Object)string6.substring(0, n));
                }
                return NbBundle.getMessage(NbProblemDisplayer.class, (String)"MSG_problem_package_not_loaded_or_old", (Object)string6);
            }
            case 3: {
                if (dependency.getName().equals("Java") && dependency.getComparison() == 1) {
                    return NbBundle.getMessage(NbProblemDisplayer.class, (String)"MSG_problem_java_too_old", (Object)dependency.getVersion(), (Object)Dependency.JAVA_SPEC);
                }
                return dependency.toString();
            }
        }
        throw new IllegalArgumentException(dependency.toString());
    }

    private static String label(Module module, boolean bl) {
        if (bl) {
            return module.getDisplayName();
        }
        return module.getCodeNameBase();
    }

    static void problemMessagesForModules(final Appendable appendable, Collection<? extends Module> collection, final boolean bl) {
        try {
            HashSet<String> hashSet = new HashSet<String>();
            for (Module object2 : collection) {
                hashSet.add(object2.getCodeName());
            }
            HashSet hashSet2 = new HashSet();
            class Report {
                final Module m;
                final List<Object> problems = new ArrayList<Object>();

                Report(Module module) {
                    this.m = module;
                }

                void write() throws IOException {
                    for (Object object : this.problems) {
                        appendable.append("\n\t").append(NbProblemDisplayer.label(this.m, bl) + " - " + NbProblemDisplayer.messageForProblem(this.m, object, bl));
                    }
                }
            }
            HashMap<Module, Report> hashMap = new HashMap<Module, Report>();
            HashMap<Module, Set> hashMap2 = new HashMap<Module, Set>();
            for (Module module : collection) {
                Object object = module.getProblems();
                if (object.isEmpty()) {
                    throw new IllegalStateException("Module " + module + " could not be installed but had no problems");
                }
                Report report = new Report(module);
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Dependency dependency;
                    Object e = iterator.next();
                    if (e instanceof Dependency && bl && (dependency = (Dependency)e).getType() == 1 && hashSet.contains(dependency.getName())) {
                        hashSet2.add(module.getCodeName());
                        continue;
                    }
                    report.problems.add(e);
                }
                hashMap.put(module, report);
                hashMap2.put(module, module.getManager().getModuleInterdependencies(module, true, false, false));
            }
            try {
                for (Module module : BaseUtilities.topologicalSort(hashMap2.keySet(), hashMap2)) {
                    ((Report)hashMap.get(module)).write();
                }
            }
            catch (TopologicalSortException topologicalSortException) {
                for (Object object : hashMap.values()) {
                    ((Report)object).write();
                }
            }
            if (!hashSet2.isEmpty()) {
                appendable.append("\n\t").append(NbBundle.getMessage(NbProblemDisplayer.class, (String)"MSG_also_dep_modules", (Object)hashSet2.size()));
            }
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }
}

