/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.WeakSet;

final class NbInstrumentation
implements InvocationHandler {
    private static final Logger LOG = Logger.getLogger(NbInstrumentation.class.getName());
    private static final Object LOCK = new Object();
    private static volatile Collection<NbInstrumentation> ACTIVE;
    private final List<ClassFileTransformer> transformers = new CopyOnWriteArrayList<ClassFileTransformer>();
    private static final ThreadLocal<Boolean> IN;
    private final Instrumentation instrumentationProxy = (Instrumentation)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Instrumentation.class}, (InvocationHandler)this);

    static NbInstrumentation registerAgent(ClassLoader classLoader, String string) {
        try {
            return NbInstrumentation.registerImpl(string, classLoader);
        }
        catch (Throwable throwable) {
            LOG.log(Level.WARNING, "Cannot register " + string, throwable);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void unregisterAgent(NbInstrumentation nbInstrumentation) {
        Object object = LOCK;
        synchronized (object) {
            if (ACTIVE != null) {
                WeakSet weakSet = new WeakSet(ACTIVE);
                weakSet.remove(nbInstrumentation);
                ACTIVE = weakSet;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static NbInstrumentation registerImpl(String string, ClassLoader classLoader) throws ClassNotFoundException, IllegalArgumentException, NoSuchMethodException, SecurityException, IllegalAccessException, InvocationTargetException {
        NbInstrumentation nbInstrumentation = new NbInstrumentation();
        Class<?> clazz = LOCK;
        synchronized (clazz) {
            ACTIVE = ACTIVE == null ? new WeakSet() : new WeakSet(ACTIVE);
            ACTIVE.add(nbInstrumentation);
        }
        clazz = Class.forName(string, true, classLoader);
        try {
            Method method = clazz.getMethod("agentmain", String.class, Instrumentation.class);
            method.invoke(null, "", nbInstrumentation.getInstrumentationProxy());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Method method = clazz.getMethod("agentmain", String.class);
            method.invoke(null, "");
        }
        return nbInstrumentation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] patchByteCode(ClassLoader classLoader, String string, ProtectionDomain protectionDomain, byte[] byArray) throws IllegalClassFormatException {
        if (ACTIVE == null) {
            return byArray;
        }
        if (Boolean.TRUE.equals(IN.get())) {
            return byArray;
        }
        try {
            IN.set(Boolean.TRUE);
            for (NbInstrumentation nbInstrumentation : ACTIVE) {
                for (ClassFileTransformer classFileTransformer : nbInstrumentation.transformers) {
                    byArray = classFileTransformer.transform(classLoader, string, null, protectionDomain, byArray);
                }
            }
        }
        finally {
            IN.set(null);
        }
        return byArray;
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        switch (method.getName()) {
            case "addTransformer": {
                return this.transformers.add((ClassFileTransformer)objectArray[0]);
            }
            case "removeTransformer": {
                return this.transformers.remove(objectArray[0]);
            }
            case "isRetransformClassesSupported": 
            case "isRedefineClassesSupported": 
            case "isModifiableClass": 
            case "isNativeMethodPrefixSupported": 
            case "isModifiableModule": {
                return false;
            }
            case "retransformClasses": 
            case "redefineClasses": {
                throw new UnmodifiableClassException();
            }
            case "getAllLoadedClasses": 
            case "getInitiatedClasses": {
                return new Class[0];
            }
            case "getObjectSize": {
                return 42;
            }
            case "appendToSystemClassLoaderSearch": 
            case "setNativeMethodPrefix": 
            case "redefineModule": {
                throw new UnsupportedOperationException();
            }
        }
        return null;
    }

    public Instrumentation getInstrumentationProxy() {
        return this.instrumentationProxy;
    }

    static {
        IN = new ThreadLocal();
    }
}

