/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.net.SocketAddress;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.traccar.BaseHttpProtocolDecoder;
import org.traccar.Protocol;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class OpenGtsProtocolDecoder
extends BaseHttpProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().text("$GPRMC,").number("(dd)(dd)(dd)(?:.d+)?,").expression("([AV]),").number("(d+)(dd.d+),").expression("([NS]),").number("(d+)(dd.d+),").expression("([EW]),").number("(d+.d+),").number("(d+.d+)?,").number("(dd)(dd)(dd),").any().compile();

    public OpenGtsProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        FullHttpRequest request = (FullHttpRequest)msg;
        QueryStringDecoder decoder = new QueryStringDecoder(request.uri());
        Map params = decoder.parameters();
        Position position = new Position(this.getProtocolName());
        for (Map.Entry entry : params.entrySet()) {
            String value = (String)((List)entry.getValue()).get(0);
            switch ((String)entry.getKey()) {
                case "id": {
                    DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, value);
                    if (deviceSession == null) {
                        this.sendResponse(channel, HttpResponseStatus.BAD_REQUEST);
                        return null;
                    }
                    position.setDeviceId(deviceSession.getDeviceId());
                    break;
                }
                case "gprmc": {
                    Parser parser = new Parser(PATTERN, value);
                    if (!parser.matches()) {
                        this.sendResponse(channel, HttpResponseStatus.BAD_REQUEST);
                        return null;
                    }
                    DateBuilder dateBuilder = new DateBuilder().setTime(parser.nextInt(), parser.nextInt(), parser.nextInt());
                    position.setValid(parser.next().equals("A"));
                    position.setLatitude(parser.nextCoordinate());
                    position.setLongitude(parser.nextCoordinate());
                    position.setSpeed(parser.nextDouble());
                    position.setCourse(parser.nextDouble(0.0));
                    dateBuilder.setDateReverse(parser.nextInt(), parser.nextInt(), parser.nextInt());
                    position.setTime(dateBuilder.getDate());
                    break;
                }
                case "alt": {
                    position.setAltitude(Double.parseDouble(value));
                    break;
                }
                case "batt": {
                    position.set("batteryLevel", Double.parseDouble(value));
                    break;
                }
            }
        }
        if (position.getDeviceId() != 0L) {
            this.sendResponse(channel, HttpResponseStatus.OK);
            return position;
        }
        this.sendResponse(channel, HttpResponseStatus.BAD_REQUEST);
        return null;
    }
}

