/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import java.io.Reader;
import java.io.StringReader;
import java.net.SocketAddress;
import java.util.Date;
import org.traccar.BaseProtocolDecoder;
import org.traccar.Protocol;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class FlexApiProtocolDecoder
extends BaseProtocolDecoder {
    public FlexApiProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        String message = (String)msg;
        JsonObject root = Json.createReader((Reader)new StringReader(message.substring(1, message.length() - 2))).readObject();
        String topic = root.getString("topic");
        String clientId = topic.substring(3, topic.indexOf(47, 3));
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, clientId);
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        JsonObject payload = root.getJsonObject("payload");
        if (topic.contains("/gnss/")) {
            position.setValid(true);
            if (payload.containsKey((Object)"time")) {
                position.setTime(new Date((long)payload.getInt("time") * 1000L));
                position.setLatitude(payload.getJsonNumber("lat").doubleValue());
                position.setLongitude(payload.getJsonNumber("log").doubleValue());
            } else {
                position.setTime(new Date((long)payload.getInt("gnss.ts") * 1000L));
                position.setLatitude(payload.getJsonNumber("gnss.latitude").doubleValue());
                position.setLongitude(payload.getJsonNumber("gnss.longitude").doubleValue());
            }
            position.setValid(payload.getInt("gnss.fix") > 0);
            position.setAltitude(payload.getJsonNumber("gnss.altitude").doubleValue());
            position.setSpeed(payload.getJsonNumber("gnss.speed").doubleValue());
            position.setCourse(payload.getJsonNumber("gnss.heading").doubleValue());
            position.set("sat", payload.getInt("gnss.num_sv"));
            position.set("hdop", payload.getJsonNumber("gnss.hdop").doubleValue());
        } else if (topic.contains("/cellular1/")) {
            this.getLastLocation(position, new Date((long)payload.getInt("modem1.ts") * 1000L));
            position.set("imei", payload.getString("modem1.imei"));
            position.set("imsi", payload.getString("modem1.imsi"));
            position.set("iccid", payload.getString("modem1.iccid"));
            String operator = payload.getString("modem1.operator");
            if (!operator.isEmpty()) {
                CellTower cellTower = CellTower.from(Integer.parseInt(operator.substring(0, 3)), Integer.parseInt(operator.substring(3)), Integer.parseInt(payload.getString("modem1.lac"), 16), Integer.parseInt(payload.getString("modem1.cell_id"), 16), payload.getInt("modem1.rssi"));
                switch (payload.getInt("modem1.network")) {
                    case 1: {
                        cellTower.setRadioType("gsm");
                        break;
                    }
                    case 2: {
                        cellTower.setRadioType("wcdma");
                        break;
                    }
                    case 3: {
                        cellTower.setRadioType("lte");
                    }
                }
                position.setNetwork(new Network(cellTower));
            }
        } else if (topic.contains("/obd/")) {
            this.getLastLocation(position, new Date((long)payload.getInt("obd.ts") * 1000L));
            if (payload.containsKey((Object)"obd.speed")) {
                position.set("obdSpeed", payload.getJsonNumber("obd.speed").doubleValue());
            }
            if (payload.containsKey((Object)"obd.odo")) {
                position.set("obdOdometer", payload.getInt("obd.odo"));
            }
            if (payload.containsKey((Object)"obd.rpm")) {
                position.set("rpm", payload.getInt("obd.rpm"));
            }
            if (payload.containsKey((Object)"obd.vin")) {
                position.set("vin", payload.getString("obd.vin"));
            }
        } else if (topic.contains("/motion/")) {
            this.getLastLocation(position, new Date((long)payload.getInt("motion.ts") * 1000L));
            position.set("ax", payload.getJsonNumber("motion.ax").doubleValue());
            position.set("ay", payload.getJsonNumber("motion.ay").doubleValue());
            position.set("az", payload.getJsonNumber("motion.az").doubleValue());
            position.set("gx", payload.getJsonNumber("motion.gx").doubleValue());
            position.set("gy", payload.getJsonNumber("motion.gy").doubleValue());
            position.set("gz", payload.getJsonNumber("motion.gz").doubleValue());
        } else if (topic.contains("/io/")) {
            this.getLastLocation(position, new Date((long)payload.getInt("io.ts") * 1000L));
            if (payload.containsKey((Object)"io.IGT")) {
                position.set("ignition", payload.getInt("io.IGT") > 0);
            }
            for (String key : payload.keySet()) {
                if (key.startsWith("io.AI")) {
                    position.set("adc" + key.substring(5), payload.getJsonNumber(key).doubleValue());
                    continue;
                }
                if (key.startsWith("io.DI") && !key.endsWith("_pullup")) {
                    position.set("in" + key.substring(5), payload.getInt(key) > 0);
                    continue;
                }
                if (!key.startsWith("io.DO")) continue;
                position.set("out" + key.substring(5), payload.getInt(key) > 0);
            }
        } else if (topic.contains("/sysinfo/")) {
            this.getLastLocation(position, new Date((long)payload.getInt("sysinfo.ts") * 1000L));
            position.set("serial", payload.getString("sysinfo.serial_number"));
            position.set("versionFw", payload.getString("sysinfo.firmware_version"));
        } else {
            return null;
        }
        return position;
    }
}

