/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.api.resource;

import jakarta.annotation.Nullable;
import jakarta.annotation.security.PermitAll;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.TimeZone;
import org.traccar.api.BaseResource;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.database.OpenIdProvider;
import org.traccar.geocoder.Geocoder;
import org.traccar.helper.Log;
import org.traccar.helper.LogAction;
import org.traccar.helper.model.UserUtil;
import org.traccar.mail.MailManager;
import org.traccar.model.ObjectOperation;
import org.traccar.model.Server;
import org.traccar.model.User;
import org.traccar.session.cache.CacheManager;
import org.traccar.sms.SmsManager;
import org.traccar.storage.StorageException;
import org.traccar.storage.query.Columns;
import org.traccar.storage.query.Condition;
import org.traccar.storage.query.Request;

@jakarta.ws.rs.Path(value="server")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class ServerResource
extends BaseResource {
    @Inject
    private Config config;
    @Inject
    private CacheManager cacheManager;
    @Inject
    private MailManager mailManager;
    @Inject
    @Nullable
    private SmsManager smsManager;
    @Inject
    @Nullable
    private OpenIdProvider openIdProvider;
    @Inject
    @Nullable
    private Geocoder geocoder;
    @Inject
    private LogAction actionLogger;
    @Context
    private HttpServletRequest request;

    @PermitAll
    @GET
    public Server get() throws StorageException {
        Server server = this.storage.getObject(Server.class, new Request(new Columns.All()));
        server.setEmailEnabled(this.mailManager.getEmailEnabled());
        server.setTextEnabled(this.smsManager != null);
        server.setGeocoderEnabled(this.geocoder != null);
        server.setOpenIdEnabled(this.openIdProvider != null);
        server.setOpenIdForce(this.openIdProvider != null && this.openIdProvider.getForce());
        User user = this.permissionsService.getUser(this.getUserId());
        if (user != null) {
            if (user.getAdministrator()) {
                server.setStorageSpace(Log.getStorageSpace());
            }
        } else {
            server.setNewServer(UserUtil.isEmpty(this.storage));
        }
        return server;
    }

    @PUT
    public Response update(Server server) throws Exception {
        this.permissionsService.checkAdmin(this.getUserId());
        this.storage.updateObject(server, new Request((Columns)new Columns.Exclude("id"), new Condition.Equals("id", server.getId())));
        this.cacheManager.invalidateObject(true, Server.class, server.getId(), ObjectOperation.UPDATE);
        this.actionLogger.edit(this.request, this.getUserId(), server);
        return Response.ok((Object)server).build();
    }

    @jakarta.ws.rs.Path(value="geocode")
    @GET
    public String geocode(@QueryParam(value="latitude") double latitude, @QueryParam(value="longitude") double longitude) {
        if (this.geocoder != null) {
            return this.geocoder.getAddress(latitude, longitude, null);
        }
        throw new RuntimeException("Reverse geocoding is not enabled");
    }

    @jakarta.ws.rs.Path(value="timezones")
    @GET
    public Collection<String> timezones() {
        return Arrays.asList(TimeZone.getAvailableIDs());
    }

    @jakarta.ws.rs.Path(value="file/{path}")
    @POST
    @Consumes(value={"*/*"})
    public Response uploadFile(@PathParam(value="path") String path, File inputFile) throws IOException, StorageException {
        this.permissionsService.checkAdmin(this.getUserId());
        String root = this.config.getString(Keys.WEB_OVERRIDE, this.config.getString(Keys.WEB_PATH));
        Path rootPath = Paths.get(root, new String[0]).normalize();
        Path outputPath = rootPath.resolve(path).normalize();
        if (!outputPath.startsWith(rootPath)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        Path directoryPath = outputPath.getParent();
        if (directoryPath != null) {
            Files.createDirectories(directoryPath, new FileAttribute[0]);
        }
        try (FileInputStream input = new FileInputStream(inputFile);
             FileOutputStream output = new FileOutputStream(outputPath.toFile());){
            input.transferTo(output);
        }
        return Response.ok().build();
    }

    @jakarta.ws.rs.Path(value="gc")
    @GET
    public Response gc() throws StorageException {
        this.permissionsService.checkAdmin(this.getUserId());
        System.gc();
        return Response.ok().build();
    }

    @jakarta.ws.rs.Path(value="cache")
    @GET
    public String cache() throws StorageException {
        this.permissionsService.checkAdmin(this.getUserId());
        return this.cacheManager.toString();
    }

    @jakarta.ws.rs.Path(value="reboot")
    @POST
    public void reboot() throws StorageException {
        this.permissionsService.checkAdmin(this.getUserId());
        System.exit(130);
    }
}

