/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.channels.ClosedChannelException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jetty.websocket.api.Callback;
import org.eclipse.jetty.websocket.api.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.helper.model.PositionUtil;
import org.traccar.model.Device;
import org.traccar.model.Event;
import org.traccar.model.LogRecord;
import org.traccar.model.Position;
import org.traccar.session.ConnectionManager;
import org.traccar.storage.Storage;
import org.traccar.storage.StorageException;

public class AsyncSocket
implements Session.Listener.AutoDemanding,
ConnectionManager.UpdateListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncSocket.class);
    private static final String KEY_DEVICES = "devices";
    private static final String KEY_POSITIONS = "positions";
    private static final String KEY_EVENTS = "events";
    private static final String KEY_LOGS = "logs";
    private final ObjectMapper objectMapper;
    private final ConnectionManager connectionManager;
    private final Storage storage;
    private final long userId;
    private boolean includeLogs;
    private Session session;

    public AsyncSocket(ObjectMapper objectMapper, ConnectionManager connectionManager, Storage storage, long userId) {
        this.objectMapper = objectMapper;
        this.connectionManager = connectionManager;
        this.storage = storage;
        this.userId = userId;
    }

    public void onWebSocketOpen(Session session) {
        this.session = session;
        try {
            HashMap data = new HashMap();
            data.put(KEY_POSITIONS, PositionUtil.getLatestPositions(this.storage, this.userId));
            this.sendData(data);
            this.connectionManager.addListener(this.userId, this);
        }
        catch (StorageException e) {
            throw new RuntimeException(e);
        }
    }

    public void onWebSocketClose(int statusCode, String reason, Callback callback) {
        this.connectionManager.removeListener(this.userId, this);
        this.session = null;
        callback.succeed();
    }

    public void onWebSocketText(String message) {
        try {
            JsonNode json = this.objectMapper.readTree(message);
            if (json.hasNonNull(KEY_LOGS)) {
                this.includeLogs = json.get(KEY_LOGS).asBoolean();
            }
        }
        catch (JsonProcessingException e) {
            LOGGER.warn("Socket JSON parsing error", (Throwable)e);
        }
    }

    public void onWebSocketError(Throwable cause) {
        if (!(cause instanceof ClosedChannelException)) {
            LOGGER.warn("WebSocket error", cause);
        }
    }

    @Override
    public void onKeepalive() {
        this.sendData(new HashMap());
    }

    @Override
    public void onUpdateDevice(Device device) {
        this.sendData(Map.of(KEY_DEVICES, List.of(device)));
    }

    @Override
    public void onUpdatePosition(Position position) {
        this.sendData(Map.of(KEY_POSITIONS, List.of(position)));
    }

    @Override
    public void onUpdateEvent(Event event) {
        this.sendData(Map.of(KEY_EVENTS, List.of(event)));
    }

    @Override
    public void onUpdateLog(LogRecord record) {
        if (this.includeLogs) {
            this.sendData(Map.of(KEY_LOGS, List.of(record)));
        }
    }

    private void sendData(Map<String, Collection<?>> data) {
        if (this.session != null && this.session.isOpen()) {
            try {
                this.session.sendText(this.objectMapper.writeValueAsString(data), Callback.NOOP);
            }
            catch (JsonProcessingException e) {
                LOGGER.warn("Socket JSON formatting error", (Throwable)e);
            }
        }
    }
}

