/*
 * Decompiled with CFR 0.152.
 */
package liquibase.analytics.configuration;

import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import liquibase.Scope;
import liquibase.analytics.configuration.AnalyticsArgs;
import liquibase.analytics.configuration.AnalyticsConfiguration;
import liquibase.analytics.configuration.RemoteAnalyticsConfiguration;
import liquibase.configuration.ConfiguredValue;
import liquibase.logging.Logger;
import liquibase.util.Cache;
import lombok.Generated;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class LiquibaseRemoteAnalyticsConfiguration
implements AnalyticsConfiguration {
    private static final Cache<RemoteAnalyticsConfiguration> remoteAnalyticsConfiguration = new Cache<RemoteAnalyticsConfiguration>(() -> {
        Logger log = Scope.getCurrentScope().getLog(AnalyticsConfiguration.class);
        Level logLevel = AnalyticsArgs.LOG_LEVEL.getCurrentValue();
        String url = AnalyticsArgs.CONFIG_ENDPOINT_URL.getCurrentValue();
        AtomicReference<RemoteAnalyticsConfiguration> remoteAnalyticsConfiguration = new AtomicReference<RemoteAnalyticsConfiguration>();
        try {
            URLConnection urlConnection = new URL(url).openConnection();
            urlConnection.setConnectTimeout(AnalyticsArgs.CONFIG_ENDPOINT_TIMEOUT_MILLIS.getCurrentValue());
            urlConnection.setReadTimeout(AnalyticsArgs.CONFIG_ENDPOINT_TIMEOUT_MILLIS.getCurrentValue());
            InputStream input = urlConnection.getInputStream();
            Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor(new LoaderOptions()));
            Map loaded = (Map)yaml.load(input);
            remoteAnalyticsConfiguration.set(RemoteAnalyticsConfiguration.fromYaml(loaded));
        }
        catch (SocketTimeoutException e) {
            log.log(logLevel, "Timed out while attempting to load analytics configuration from " + url, null);
        }
        catch (Exception e) {
            log.log(logLevel, "Failed to load analytics configuration from " + url, e);
        }
        return (RemoteAnalyticsConfiguration)remoteAnalyticsConfiguration.get();
    }, false, AnalyticsArgs.CONFIG_CACHE_TIMEOUT_MILLIS.getCurrentValue());

    @Override
    public int getPriority() {
        return 0;
    }

    public int getTimeoutMillis() throws Exception {
        ConfiguredValue<Integer> userTimeoutMillis = AnalyticsArgs.TIMEOUT_MILLIS.getCurrentConfiguredValue();
        if (userTimeoutMillis.found()) {
            return userTimeoutMillis.getValue();
        }
        return remoteAnalyticsConfiguration.get().getTimeoutMs();
    }

    public String getDestinationUrl() throws Exception {
        return remoteAnalyticsConfiguration.get().getEndpointData();
    }

    @Override
    public boolean isOssAnalyticsEnabled() throws Exception {
        return Optional.ofNullable(remoteAnalyticsConfiguration.get()).map(RemoteAnalyticsConfiguration::isSendOss).orElse(false);
    }

    @Override
    public boolean isProAnalyticsEnabled() throws Exception {
        return Optional.ofNullable(remoteAnalyticsConfiguration.get()).map(RemoteAnalyticsConfiguration::isSendPro).orElse(false);
    }

    public String getWriteKey() throws Exception {
        return remoteAnalyticsConfiguration.get().getWriteKey();
    }

    public List<RemoteAnalyticsConfiguration.ExtensionName> getExtensionNames() throws Exception {
        return remoteAnalyticsConfiguration.get().getExtensions();
    }

    @Generated
    public LiquibaseRemoteAnalyticsConfiguration() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LiquibaseRemoteAnalyticsConfiguration)) {
            return false;
        }
        LiquibaseRemoteAnalyticsConfiguration other = (LiquibaseRemoteAnalyticsConfiguration)o;
        return other.canEqual(this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LiquibaseRemoteAnalyticsConfiguration;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    public String toString() {
        return "LiquibaseRemoteAnalyticsConfiguration()";
    }
}

