/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth.hash;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.BaseEncoding;
import com.google.firebase.auth.hash.RepeatableHash;
import java.util.Map;

public final class Scrypt
extends RepeatableHash {
    private final String key;
    private final String saltSeparator;
    private final int memoryCost;

    private Scrypt(Builder builder) {
        super("SCRYPT", 0, 8, builder);
        Preconditions.checkArgument((builder.key != null && builder.key.length > 0 ? 1 : 0) != 0, (Object)"A non-empty key is required for Scrypt");
        Preconditions.checkArgument((builder.memoryCost > 0 && builder.memoryCost <= 14 ? 1 : 0) != 0, (Object)"memoryCost must be between 1 and 14");
        this.key = BaseEncoding.base64Url().encode(builder.key);
        this.saltSeparator = builder.saltSeparator != null ? BaseEncoding.base64Url().encode(builder.saltSeparator) : BaseEncoding.base64Url().encode(new byte[0]);
        this.memoryCost = builder.memoryCost;
    }

    @Override
    protected Map<String, Object> getOptions() {
        return ImmutableMap.builder().putAll(super.getOptions()).put((Object)"signerKey", (Object)this.key).put((Object)"memoryCost", (Object)this.memoryCost).put((Object)"saltSeparator", (Object)this.saltSeparator).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends RepeatableHash.Builder<Builder, Scrypt> {
        private byte[] key;
        private byte[] saltSeparator;
        private int memoryCost;

        private Builder() {
        }

        public Builder setKey(byte[] key) {
            this.key = key;
            return this;
        }

        public Builder setSaltSeparator(byte[] saltSeparator) {
            this.saltSeparator = saltSeparator;
            return this;
        }

        public Builder setMemoryCost(int memoryCost) {
            this.memoryCost = memoryCost;
            return this;
        }

        @Override
        protected Builder getInstance() {
            return this;
        }

        @Override
        public Scrypt build() {
            return new Scrypt(this);
        }
    }
}

