/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.ModuleBinding;

public class ImportBinding
extends Binding {
    public char[][] compoundName;
    public boolean onDemand;
    public ImportReference reference;
    private Binding resolvedImport;

    public ImportBinding(char[][] compoundName, boolean isOnDemand, Binding binding, ImportReference reference) {
        this.compoundName = compoundName;
        this.onDemand = isOnDemand;
        this.resolvedImport = binding;
        this.reference = reference;
    }

    @Override
    public final int kind() {
        return 32;
    }

    public boolean isStatic() {
        return this.reference != null && this.reference.isStatic();
    }

    public char[] getSimpleName() {
        if (this.reference != null) {
            return this.reference.getSimpleName();
        }
        return this.compoundName[this.compoundName.length - 1];
    }

    @Override
    public char[] readableName() {
        if (this.resolvedImport instanceof ModuleBinding) {
            return CharOperation.concat("module ".toCharArray(), CharOperation.concatWith(this.compoundName, '.'));
        }
        if (this.onDemand) {
            return CharOperation.concat(CharOperation.concatWith(this.compoundName, '.'), ".*".toCharArray());
        }
        return CharOperation.concatWith(this.compoundName, '.');
    }

    public int getResolvedBindingKind() {
        if (this.resolvedImport == null) {
            return 0;
        }
        return this.resolvedImport.kind() & 0xD;
    }

    public Binding getResolvedImport() {
        return this.resolvedImport;
    }

    public Binding setResolvedImport(Binding resolvedImport) {
        this.resolvedImport = resolvedImport;
        return resolvedImport;
    }

    public String toString() {
        return "import : " + new String(this.readableName());
    }
}

