/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.asn1.encoder;

import de.rub.nds.asn1.Asn1Encodable;
import de.rub.nds.asn1.encoder.Asn1TypeRegister;
import de.rub.nds.asn1.encoder.encodingoptions.Asn1EncodingOptions;
import de.rub.nds.asn1.encoder.encodingoptions.DefaultAsn1EncodingOptions;
import de.rub.nds.asn1.encoder.typeprocessors.Asn1TypeProcessor;
import de.rub.nds.asn1.model.Asn1Container;
import de.rub.nds.util.ByteArrayUtils;
import java.util.LinkedList;
import java.util.List;

public class Asn1Encoder {
    private final Asn1EncodingOptions asn1EncodingOptions;
    private final List<Asn1Encodable> encodables;

    public Asn1Encoder(List<Asn1Encodable> encodables) {
        this(new DefaultAsn1EncodingOptions(), encodables);
    }

    public Asn1Encoder(Asn1EncodingOptions asn1EncodingOptions, List<Asn1Encodable> encodables) {
        this.asn1EncodingOptions = asn1EncodingOptions;
        this.encodables = encodables;
    }

    public Asn1Encoder(Asn1Encodable firstAsn1Encodable, Asn1Encodable ... asn1Encodables) {
        this(new DefaultAsn1EncodingOptions(), firstAsn1Encodable, asn1Encodables);
    }

    public Asn1Encoder(Asn1EncodingOptions asn1EncodingOptions, Asn1Encodable firstAsn1Encodable, Asn1Encodable ... asn1Encodables) {
        this.asn1EncodingOptions = asn1EncodingOptions;
        this.encodables = new LinkedList<Asn1Encodable>();
        this.encodables.add(firstAsn1Encodable);
        for (Asn1Encodable asn1Encodable : asn1Encodables) {
            this.encodables.add(asn1Encodable);
        }
    }

    public byte[] encode() {
        byte[] encoded = new byte[]{};
        for (Asn1Encodable asn1Encodable : this.encodables) {
            encoded = ByteArrayUtils.merge(encoded, this.encodeSingleAsn1Encodable(asn1Encodable));
        }
        return encoded;
    }

    protected byte[] encodeSingleAsn1Encodable(Asn1Encodable asn1Encodable) {
        Asn1TypeRegister typeRegister = Asn1TypeRegister.getInstance();
        Asn1TypeProcessor asn1TypeProcessor = typeRegister.createTypeProcessor(this.asn1EncodingOptions, asn1Encodable);
        asn1TypeProcessor.onBeforeChildEncode();
        if (asn1Encodable instanceof Asn1Container) {
            this.encodeChildren((Asn1Container)asn1Encodable);
        }
        byte[] encoded = asn1TypeProcessor.encode();
        return encoded;
    }

    protected void encodeChildren(Asn1Container asn1Container) {
        Asn1Encoder childEncoder = this.invokeChildEncoder(asn1Container.getChildren());
        byte[] childEncoding = childEncoder.encode();
        asn1Container.setEncodedChildren(childEncoding);
    }

    protected Asn1Encoder invokeChildEncoder(List<Asn1Encodable> children) {
        return new Asn1Encoder(this.asn1EncodingOptions, children);
    }
}

