/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action.executor;

import de.rub.nds.tlsattacker.core.constants.ProtocolMessageType;
import de.rub.nds.tlsattacker.core.dtls.MessageFragmenter;
import de.rub.nds.tlsattacker.core.protocol.handler.ProtocolMessageHandler;
import de.rub.nds.tlsattacker.core.protocol.message.DtlsHandshakeMessageFragment;
import de.rub.nds.tlsattacker.core.protocol.message.HandshakeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ProtocolMessage;
import de.rub.nds.tlsattacker.core.record.AbstractRecord;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import de.rub.nds.tlsattacker.core.workflow.action.executor.MessageActionResult;
import de.rub.nds.tlsattacker.core.workflow.action.executor.MessageBytesCollector;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SendMessageHelper {
    private static final Logger LOGGER = LogManager.getLogger();

    public MessageActionResult sendMessages(List<ProtocolMessage> messages, List<AbstractRecord> records, TlsContext context) throws IOException {
        return this.sendMessages(messages, records, context, true);
    }

    public MessageActionResult sendMessages(List<ProtocolMessage> messages, List<AbstractRecord> records, TlsContext context, boolean prepareMessages) throws IOException {
        LinkedList<DtlsHandshakeMessageFragment> fragmentMessages = new LinkedList<DtlsHandshakeMessageFragment>();
        context.setTalkingConnectionEndType(context.getChooser().getConnectionEndType());
        if (records == null) {
            LOGGER.trace("No Records Specified, creating emtpy list");
            records = new LinkedList<AbstractRecord>();
        }
        int recordPosition = 0;
        ProtocolMessageType lastType = null;
        ProtocolMessage lastMessage = null;
        MessageBytesCollector messageBytesCollector = new MessageBytesCollector();
        MessageFragmenter fragmenter = new MessageFragmenter(context.getConfig().getDtlsMaximumFragmentLength());
        for (ProtocolMessage message : messages) {
            if (message.getProtocolMessageType() != lastType && lastMessage != null && context.getConfig().isFlushOnMessageTypeChange().booleanValue()) {
                recordPosition = this.flushBytesToRecords(messageBytesCollector, lastType, records, recordPosition, context);
                lastMessage.getHandler(context).adjustTlsContextAfterSerialize(lastMessage);
                lastMessage = null;
            }
            lastMessage = message;
            lastType = message.getProtocolMessageType();
            if (prepareMessages) {
                LOGGER.debug("Preparing " + message.toCompactString());
            }
            byte[] protocolMessageBytes = this.handleProtocolMessage(message, context, prepareMessages);
            if (message.isGoingToBeSent()) {
                if (context.getChooser().getSelectedProtocolVersion().isDTLS()) {
                    if (message.isHandshakeMessage()) {
                        List<DtlsHandshakeMessageFragment> messageFragments = message.isDtlsHandshakeMessageFragment() ? Collections.singletonList((DtlsHandshakeMessageFragment)message) : fragmenter.fragmentMessage((HandshakeMessage)message, context);
                        for (DtlsHandshakeMessageFragment fragment : messageFragments) {
                            messageBytesCollector.appendProtocolMessageBytes((byte[])fragment.getCompleteResultingMessage().getValue());
                            fragmentMessages.add(fragment);
                            recordPosition = this.flushBytesToRecords(messageBytesCollector, lastType, records, recordPosition, context);
                        }
                    } else {
                        messageBytesCollector.appendProtocolMessageBytes(protocolMessageBytes);
                    }
                } else {
                    messageBytesCollector.appendProtocolMessageBytes(protocolMessageBytes);
                }
            }
            if (!context.getConfig().isCreateIndividualRecords().booleanValue()) continue;
            recordPosition = this.flushBytesToRecords(messageBytesCollector, lastType, records, recordPosition, context);
            message.getHandler(context).adjustTlsContextAfterSerialize(message);
            lastMessage = null;
        }
        recordPosition = this.flushBytesToRecords(messageBytesCollector, lastType, records, recordPosition, context);
        if (lastMessage != null) {
            lastMessage.getHandler(context).adjustTlsContextAfterSerialize(lastMessage);
        }
        this.sendData(messageBytesCollector, context);
        if (context.getConfig().isUseAllProvidedRecords().booleanValue() && recordPosition < records.size()) {
            int current = 0;
            for (AbstractRecord record : records) {
                if (current >= recordPosition) {
                    if (record.getMaxRecordLengthConfig() == null) {
                        record.setMaxRecordLengthConfig(context.getConfig().getDefaultMaxRecordData());
                    }
                    LinkedList<AbstractRecord> emptyRecords = new LinkedList<AbstractRecord>();
                    emptyRecords.add(record);
                    messageBytesCollector.appendRecordBytes(context.getRecordLayer().prepareRecords(messageBytesCollector.getProtocolMessageBytesStream(), record.getContentMessageType(), emptyRecords));
                    this.sendData(messageBytesCollector, context);
                }
                ++current;
            }
        }
        if (fragmentMessages.isEmpty()) {
            fragmentMessages = null;
        }
        return new MessageActionResult(records, messages, fragmentMessages);
    }

    public void sendRecords(List<AbstractRecord> records, TlsContext context) throws IOException {
        context.setTalkingConnectionEndType(context.getChooser().getConnectionEndType());
        if (records == null) {
            LOGGER.debug("No records specified, nothing to send");
            return;
        }
        MessageBytesCollector messageBytesCollector = new MessageBytesCollector();
        for (AbstractRecord record : records) {
            messageBytesCollector.appendRecordBytes(record.getRecordSerializer().serialize());
        }
        LOGGER.debug("Sending " + records.size() + "records");
        this.sendData(messageBytesCollector, context);
    }

    private int flushBytesToRecords(MessageBytesCollector collector, ProtocolMessageType type, List<AbstractRecord> records, int recordPosition, TlsContext context) {
        int length = collector.getProtocolMessageBytesStream().length;
        List<AbstractRecord> toFillList = this.getEnoughRecords(length, recordPosition, records, context);
        collector.appendRecordBytes(context.getRecordLayer().prepareRecords(collector.getProtocolMessageBytesStream(), type, toFillList));
        collector.flushProtocolMessageBytes();
        return recordPosition + toFillList.size();
    }

    private List<AbstractRecord> getEnoughRecords(int length, int position, List<AbstractRecord> records, TlsContext context) {
        LinkedList<AbstractRecord> toFillList = new LinkedList<AbstractRecord>();
        int recordLength = 0;
        while (recordLength < length) {
            if (position >= records.size()) {
                if (context.getConfig().isCreateRecordsDynamically().booleanValue()) {
                    LOGGER.trace("Creating new Record");
                    records.add(context.getRecordLayer().getFreshRecord());
                } else {
                    return toFillList;
                }
            }
            AbstractRecord record = records.get(position);
            toFillList.add(record);
            if (record.getMaxRecordLengthConfig() == null) {
                record.setMaxRecordLengthConfig(context.getConfig().getDefaultMaxRecordData());
            }
            recordLength += record.getMaxRecordLengthConfig().intValue();
            ++position;
        }
        return toFillList;
    }

    private void sendData(MessageBytesCollector collector, TlsContext context) throws IOException {
        context.getTransportHandler().sendData(collector.getRecordBytes());
        collector.flushRecordBytes();
    }

    private byte[] handleProtocolMessage(ProtocolMessage message, TlsContext context, boolean withPrepare) {
        ProtocolMessageHandler handler = message.getHandler(context);
        byte[] protocolMessageBytes = handler.prepareMessage(message, withPrepare);
        return protocolMessageBytes;
    }
}

