/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler.extension;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.constants.SignatureAndHashAlgorithm;
import de.rub.nds.tlsattacker.core.exceptions.AdjustmentException;
import de.rub.nds.tlsattacker.core.protocol.handler.extension.ExtensionHandler;
import de.rub.nds.tlsattacker.core.protocol.message.extension.SignatureAndHashAlgorithmsExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.SignatureAndHashAlgorithmsExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.SignatureAndHashAlgorithmsExtensionPreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.SignatureAndHashAlgorithmsExtensionSerializer;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import java.util.Arrays;
import java.util.LinkedList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SignatureAndHashAlgorithmsExtensionHandler
extends ExtensionHandler<SignatureAndHashAlgorithmsExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public SignatureAndHashAlgorithmsExtensionHandler(TlsContext context) {
        super(context);
    }

    @Override
    public void adjustTLSExtensionContext(SignatureAndHashAlgorithmsExtensionMessage message) {
        LinkedList<SignatureAndHashAlgorithm> algoList = new LinkedList<SignatureAndHashAlgorithm>();
        byte[] signatureAndHashBytes = (byte[])message.getSignatureAndHashAlgorithms().getValue();
        if (signatureAndHashBytes.length % 2 != 0) {
            throw new AdjustmentException("Cannot adjust ClientSupportedSignature and Hash algorithms to a resonable Value");
        }
        for (int i = 0; i < signatureAndHashBytes.length; i += 2) {
            byte[] algoBytes = Arrays.copyOfRange(signatureAndHashBytes, i, i + 2);
            SignatureAndHashAlgorithm algo = SignatureAndHashAlgorithm.getSignatureAndHashAlgorithm(algoBytes);
            if (algo == null || algo.getSignatureAlgorithm() == null || algo.getHashAlgorithm() == null) {
                LOGGER.warn("Unknown SignatureAndHashAlgorithm:" + ArrayConverter.bytesToHexString((byte[])algoBytes));
                continue;
            }
            algoList.add(algo);
        }
        this.context.setClientSupportedSignatureAndHashAlgorithms(algoList);
    }

    @Override
    public SignatureAndHashAlgorithmsExtensionParser getParser(byte[] message, int pointer) {
        return new SignatureAndHashAlgorithmsExtensionParser(pointer, message);
    }

    public SignatureAndHashAlgorithmsExtensionPreparator getPreparator(SignatureAndHashAlgorithmsExtensionMessage message) {
        return new SignatureAndHashAlgorithmsExtensionPreparator(this.context.getChooser(), message, this.getSerializer(message));
    }

    public SignatureAndHashAlgorithmsExtensionSerializer getSerializer(SignatureAndHashAlgorithmsExtensionMessage message) {
        return new SignatureAndHashAlgorithmsExtensionSerializer(message);
    }
}

