/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.xmss;

import org.bouncycastle.pqc.crypto.xmss.HashTreeAddress;
import org.bouncycastle.pqc.crypto.xmss.LTreeAddress;
import org.bouncycastle.pqc.crypto.xmss.WOTSPlus;
import org.bouncycastle.pqc.crypto.xmss.WOTSPlusPublicKeyParameters;
import org.bouncycastle.pqc.crypto.xmss.XMSSAddress;
import org.bouncycastle.pqc.crypto.xmss.XMSSNode;

class XMSSNodeUtil {
    XMSSNodeUtil() {
    }

    static XMSSNode lTree(WOTSPlus wotsPlus, WOTSPlusPublicKeyParameters publicKey, LTreeAddress address) {
        int i;
        if (publicKey == null) {
            throw new NullPointerException("publicKey == null");
        }
        if (address == null) {
            throw new NullPointerException("address == null");
        }
        int len = wotsPlus.getParams().getLen();
        byte[][] publicKeyBytes = publicKey.toByteArray();
        XMSSNode[] publicKeyNodes = new XMSSNode[publicKeyBytes.length];
        for (i = 0; i < publicKeyBytes.length; ++i) {
            publicKeyNodes[i] = new XMSSNode(0, publicKeyBytes[i]);
        }
        address = (LTreeAddress)((LTreeAddress.Builder)((LTreeAddress.Builder)((LTreeAddress.Builder)new LTreeAddress.Builder().withLayerAddress(address.getLayerAddress())).withTreeAddress(address.getTreeAddress())).withLTreeAddress(address.getLTreeAddress()).withTreeHeight(0).withTreeIndex(address.getTreeIndex()).withKeyAndMask(address.getKeyAndMask())).build();
        while (len > 1) {
            for (i = 0; i < (int)Math.floor(len / 2); ++i) {
                address = (LTreeAddress)((LTreeAddress.Builder)((LTreeAddress.Builder)((LTreeAddress.Builder)new LTreeAddress.Builder().withLayerAddress(address.getLayerAddress())).withTreeAddress(address.getTreeAddress())).withLTreeAddress(address.getLTreeAddress()).withTreeHeight(address.getTreeHeight()).withTreeIndex(i).withKeyAndMask(address.getKeyAndMask())).build();
                publicKeyNodes[i] = XMSSNodeUtil.randomizeHash(wotsPlus, publicKeyNodes[2 * i], publicKeyNodes[2 * i + 1], address);
            }
            if (len % 2 == 1) {
                publicKeyNodes[(int)Math.floor((double)((double)(len / 2)))] = publicKeyNodes[len - 1];
            }
            len = (int)Math.ceil((double)len / 2.0);
            address = (LTreeAddress)((LTreeAddress.Builder)((LTreeAddress.Builder)((LTreeAddress.Builder)new LTreeAddress.Builder().withLayerAddress(address.getLayerAddress())).withTreeAddress(address.getTreeAddress())).withLTreeAddress(address.getLTreeAddress()).withTreeHeight(address.getTreeHeight() + 1).withTreeIndex(address.getTreeIndex()).withKeyAndMask(address.getKeyAndMask())).build();
        }
        return publicKeyNodes[0];
    }

    static XMSSNode randomizeHash(WOTSPlus wotsPlus, XMSSNode left, XMSSNode right, XMSSAddress address) {
        int i;
        XMSSAddress tmpAddress;
        XMSSAddress tmpAddress2;
        XMSSAddress tmpAddress3;
        if (left == null) {
            throw new NullPointerException("left == null");
        }
        if (right == null) {
            throw new NullPointerException("right == null");
        }
        if (left.getHeight() != right.getHeight()) {
            throw new IllegalStateException("height of both nodes must be equal");
        }
        if (address == null) {
            throw new NullPointerException("address == null");
        }
        byte[] publicSeed = wotsPlus.getPublicSeed();
        if (address instanceof LTreeAddress) {
            tmpAddress3 = (LTreeAddress)address;
            address = (LTreeAddress)((LTreeAddress.Builder)((LTreeAddress.Builder)((LTreeAddress.Builder)new LTreeAddress.Builder().withLayerAddress(tmpAddress3.getLayerAddress())).withTreeAddress(tmpAddress3.getTreeAddress())).withLTreeAddress(((LTreeAddress)tmpAddress3).getLTreeAddress()).withTreeHeight(((LTreeAddress)tmpAddress3).getTreeHeight()).withTreeIndex(((LTreeAddress)tmpAddress3).getTreeIndex()).withKeyAndMask(0)).build();
        } else if (address instanceof HashTreeAddress) {
            tmpAddress3 = (HashTreeAddress)address;
            address = (HashTreeAddress)((HashTreeAddress.Builder)((HashTreeAddress.Builder)((HashTreeAddress.Builder)new HashTreeAddress.Builder().withLayerAddress(tmpAddress3.getLayerAddress())).withTreeAddress(tmpAddress3.getTreeAddress())).withTreeHeight(((HashTreeAddress)tmpAddress3).getTreeHeight()).withTreeIndex(((HashTreeAddress)tmpAddress3).getTreeIndex()).withKeyAndMask(0)).build();
        }
        byte[] key = wotsPlus.getKhf().PRF(publicSeed, address.toByteArray());
        if (address instanceof LTreeAddress) {
            tmpAddress2 = (LTreeAddress)address;
            address = (LTreeAddress)((LTreeAddress.Builder)((LTreeAddress.Builder)((LTreeAddress.Builder)new LTreeAddress.Builder().withLayerAddress(tmpAddress2.getLayerAddress())).withTreeAddress(tmpAddress2.getTreeAddress())).withLTreeAddress(((LTreeAddress)tmpAddress2).getLTreeAddress()).withTreeHeight(((LTreeAddress)tmpAddress2).getTreeHeight()).withTreeIndex(((LTreeAddress)tmpAddress2).getTreeIndex()).withKeyAndMask(1)).build();
        } else if (address instanceof HashTreeAddress) {
            tmpAddress2 = (HashTreeAddress)address;
            address = (HashTreeAddress)((HashTreeAddress.Builder)((HashTreeAddress.Builder)((HashTreeAddress.Builder)new HashTreeAddress.Builder().withLayerAddress(tmpAddress2.getLayerAddress())).withTreeAddress(tmpAddress2.getTreeAddress())).withTreeHeight(((HashTreeAddress)tmpAddress2).getTreeHeight()).withTreeIndex(((HashTreeAddress)tmpAddress2).getTreeIndex()).withKeyAndMask(1)).build();
        }
        byte[] bitmask0 = wotsPlus.getKhf().PRF(publicSeed, address.toByteArray());
        if (address instanceof LTreeAddress) {
            tmpAddress = (LTreeAddress)address;
            address = (LTreeAddress)((LTreeAddress.Builder)((LTreeAddress.Builder)((LTreeAddress.Builder)new LTreeAddress.Builder().withLayerAddress(tmpAddress.getLayerAddress())).withTreeAddress(tmpAddress.getTreeAddress())).withLTreeAddress(((LTreeAddress)tmpAddress).getLTreeAddress()).withTreeHeight(((LTreeAddress)tmpAddress).getTreeHeight()).withTreeIndex(((LTreeAddress)tmpAddress).getTreeIndex()).withKeyAndMask(2)).build();
        } else if (address instanceof HashTreeAddress) {
            tmpAddress = (HashTreeAddress)address;
            address = (HashTreeAddress)((HashTreeAddress.Builder)((HashTreeAddress.Builder)((HashTreeAddress.Builder)new HashTreeAddress.Builder().withLayerAddress(tmpAddress.getLayerAddress())).withTreeAddress(tmpAddress.getTreeAddress())).withTreeHeight(((HashTreeAddress)tmpAddress).getTreeHeight()).withTreeIndex(((HashTreeAddress)tmpAddress).getTreeIndex()).withKeyAndMask(2)).build();
        }
        byte[] bitmask1 = wotsPlus.getKhf().PRF(publicSeed, address.toByteArray());
        int n = wotsPlus.getParams().getDigestSize();
        byte[] tmpMask = new byte[2 * n];
        for (i = 0; i < n; ++i) {
            tmpMask[i] = (byte)(left.getValue()[i] ^ bitmask0[i]);
        }
        for (i = 0; i < n; ++i) {
            tmpMask[i + n] = (byte)(right.getValue()[i] ^ bitmask1[i]);
        }
        byte[] out = wotsPlus.getKhf().H(key, tmpMask);
        return new XMSSNode(left.getHeight(), out);
    }
}

