/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.attacks.padding;

import de.rub.nds.modifiablevariable.VariableModification;
import de.rub.nds.modifiablevariable.bytearray.ByteArrayExplicitValueModification;
import de.rub.nds.modifiablevariable.bytearray.ByteArrayModificationFactory;
import de.rub.nds.modifiablevariable.bytearray.ByteArrayXorModification;
import de.rub.nds.tlsattacker.attacks.padding.PaddingVectorGenerator;
import de.rub.nds.tlsattacker.attacks.padding.vector.PaddingVector;
import de.rub.nds.tlsattacker.attacks.padding.vector.PlainPaddingVector;
import de.rub.nds.tlsattacker.attacks.padding.vector.TrippleVector;
import de.rub.nds.tlsattacker.core.constants.AlgorithmResolver;
import de.rub.nds.tlsattacker.core.constants.CipherSuite;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import java.util.LinkedList;
import java.util.List;

public class VeryShortPaddingGenerator
extends PaddingVectorGenerator {
    static final int DEFAULT_CIPHERTEXT_LENGTH = 80;
    static final int DEFAULT_PADDING_LENGTH = 4;

    @Override
    public List<PaddingVector> getVectors(CipherSuite suite, ProtocolVersion version) {
        LinkedList<PaddingVector> vectorList = new LinkedList<PaddingVector>();
        vectorList.addAll(this.createOnlyPaddingVectors(suite, version));
        vectorList.addAll(this.createClassicModifiedPadding(suite, version));
        return vectorList;
    }

    List<PaddingVector> createOnlyPaddingVectors(CipherSuite suite, ProtocolVersion version) {
        LinkedList<PaddingVector> vectorList = new LinkedList<PaddingVector>();
        byte[] plain = this.createPaddingBytes(79);
        vectorList.add(this.createVectorWithPlainData("Plain XF (0xXF=#padding bytes)", "PlainOnlyPadding", plain));
        plain = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        vectorList.add(this.createVectorWithPlainData("Plain FF", "PlainTooMuchPadding", plain));
        return vectorList;
    }

    List<PaddingVector> createClassicModifiedPadding(CipherSuite suite, ProtocolVersion version) {
        int macSize = AlgorithmResolver.getMacAlgorithm(version, suite).getSize();
        int paddingValue = 80 - macSize - 1;
        int applicationLength = 0;
        List<PaddingVector> vectorList = this.createClassicModifiedPaddingWithValidMAC(applicationLength, paddingValue);
        vectorList.addAll(this.createClassicModifiedPaddingWithInvalidMAC(applicationLength, paddingValue));
        return vectorList;
    }

    private List<PaddingVector> createClassicModifiedPaddingWithValidMAC(int applicationLength, int paddingValue) {
        LinkedList<PaddingVector> vectorList = new LinkedList<PaddingVector>();
        byte[] padding = this.createPaddingBytes(paddingValue);
        padding[0] = (byte)(padding[0] ^ 0x80);
        vectorList.add(new TrippleVector("InvPadValMac-[0]-" + applicationLength + "-" + paddingValue, "InvPadValMac", (VariableModification)new ByteArrayExplicitValueModification(new byte[applicationLength]), null, (VariableModification)new ByteArrayExplicitValueModification(padding)));
        return vectorList;
    }

    private List<PaddingVector> createClassicModifiedPaddingWithInvalidMAC(int applicationLength, int paddingValue) {
        LinkedList<PaddingVector> vectorList = new LinkedList<PaddingVector>();
        byte[] padding = this.createPaddingBytes(paddingValue);
        vectorList.add(new TrippleVector("ValPadInvMac-[0]-" + applicationLength + "-" + paddingValue, "valPadInvMac", (VariableModification)new ByteArrayExplicitValueModification(new byte[applicationLength]), (VariableModification)new ByteArrayXorModification(new byte[]{1}, 0), (VariableModification)new ByteArrayExplicitValueModification(padding)));
        return vectorList;
    }

    List<ByteArrayXorModification> createFlippedModifications(int byteLength) {
        LinkedList<ByteArrayXorModification> modificationList = new LinkedList<ByteArrayXorModification>();
        modificationList.add(new ByteArrayXorModification(new byte[]{1}, byteLength - 1));
        modificationList.add(new ByteArrayXorModification(new byte[]{8}, byteLength / 2));
        modificationList.add(new ByteArrayXorModification(new byte[]{-128}, 0));
        return modificationList;
    }

    private PaddingVector createVectorWithPlainData(String name, String identifier, byte[] plain) {
        return new PlainPaddingVector(name, identifier, (ByteArrayExplicitValueModification)ByteArrayModificationFactory.explicitValue((byte[])plain));
    }
}

