/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.attacks.config;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParametersDelegate;
import de.rub.nds.tlsattacker.attacks.bruteforce.GuessProviderType;
import de.rub.nds.tlsattacker.attacks.config.AttackConfig;
import de.rub.nds.tlsattacker.attacks.config.delegate.AttackDelegate;
import de.rub.nds.tlsattacker.attacks.exception.WordlistNotFoundException;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.config.delegate.CiphersuiteDelegate;
import de.rub.nds.tlsattacker.core.config.delegate.GeneralDelegate;
import de.rub.nds.tlsattacker.core.config.delegate.ServerDelegate;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class PskBruteForcerAttackClientCommandConfig
extends AttackConfig {
    public static final String ATTACK_COMMAND = "pskbruteforcerclient";
    @ParametersDelegate
    private ServerDelegate serverDelegate;
    @ParametersDelegate
    private AttackDelegate attackDelegate;
    @ParametersDelegate
    private CiphersuiteDelegate ciphersuiteDelegate;
    @Parameter(names={"-guessProviderType"}, description="Chooses how the BruteForcer will choose the keys to guess")
    private GuessProviderType guessProviderType = GuessProviderType.INCREMENTING;
    @Parameter(names={"-guessProviderInputFile"}, description="Set the path to an input file which can be used in the guess provider eg. a path to a wordlist")
    private String guessProviderInputFile = null;

    public PskBruteForcerAttackClientCommandConfig(GeneralDelegate delegate) {
        super(delegate);
        this.serverDelegate = new ServerDelegate();
        this.attackDelegate = new AttackDelegate();
        this.ciphersuiteDelegate = new CiphersuiteDelegate();
        this.addDelegate(this.serverDelegate);
        this.addDelegate(this.attackDelegate);
        this.addDelegate(this.ciphersuiteDelegate);
    }

    @Override
    public Config createConfig() {
        Config config = super.createConfig();
        config.setQuickReceive(true);
        config.setEarlyStop(true);
        return config;
    }

    @Override
    public boolean isExecuteAttack() {
        return this.attackDelegate.isExecuteAttack();
    }

    public String getGuessProviderInputFile() {
        return this.guessProviderInputFile;
    }

    public InputStream getGuessProviderInputStream() {
        if (this.guessProviderInputFile == null) {
            if (this.guessProviderType == GuessProviderType.WORDLIST) {
                return PskBruteForcerAttackClientCommandConfig.class.getClassLoader().getResourceAsStream("psk_common_passwords.txt");
            }
            return System.in;
        }
        File file = new File(this.getGuessProviderInputFile());
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException ex) {
            throw new WordlistNotFoundException("Wordlist not found: " + file.getAbsolutePath(), ex);
        }
    }

    public GuessProviderType getGuessProviderType() {
        return this.guessProviderType;
    }

    public void setGuessProviderType(GuessProviderType guessProviderType) {
        this.guessProviderType = guessProviderType;
    }
}

