/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.attacks.config;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParametersDelegate;
import de.rub.nds.tlsattacker.attacks.config.AttackConfig;
import de.rub.nds.tlsattacker.attacks.config.delegate.ProxyDelegate;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.config.delegate.CiphersuiteDelegate;
import de.rub.nds.tlsattacker.core.config.delegate.ClientDelegate;
import de.rub.nds.tlsattacker.core.config.delegate.GeneralDelegate;
import de.rub.nds.tlsattacker.core.config.delegate.ProtocolVersionDelegate;
import de.rub.nds.tlsattacker.core.config.delegate.StarttlsDelegate;
import de.rub.nds.tlsattacker.core.constants.CipherSuite;
import java.util.LinkedList;

public class Lucky13CommandConfig
extends AttackConfig {
    public static final String ATTACK_COMMAND = "lucky13";
    @Parameter(names={"-measurements"}, description="Number of timing measurement iterations")
    private Integer measurements = 100;
    @Parameter(names={"-mona_file"}, description="File output for Mona timing lib. If set, the output is generated and written.")
    private String monaFile;
    @Parameter(names={"-mona_jar"}, description="Location of the ReportingTool.jar file.")
    private String monaJar = "ReportingTool.jar";
    @Parameter(names={"-paddings"}, description="Paddings to check for differences, column separated.")
    private String paddings = "0,255";
    @Parameter(names={"-blocks"}, description="Number of blocks to encrypt (default is set to the value from the Lucky 13 paper, Section 3)")
    private Integer blocks = 18;
    @ParametersDelegate
    private ClientDelegate clientDelegate = new ClientDelegate();
    @ParametersDelegate
    private CiphersuiteDelegate ciphersuiteDelegate = new CiphersuiteDelegate();
    @ParametersDelegate
    private ProtocolVersionDelegate protocolVersionDelegate = new ProtocolVersionDelegate();
    @ParametersDelegate
    private StarttlsDelegate starttlsDelegate = new StarttlsDelegate();
    @ParametersDelegate
    private ProxyDelegate proxyDelegate = new ProxyDelegate();

    public Lucky13CommandConfig(GeneralDelegate delegate) {
        super(delegate);
        this.addDelegate(this.clientDelegate);
        this.addDelegate(this.ciphersuiteDelegate);
        this.addDelegate(this.protocolVersionDelegate);
        this.addDelegate(this.starttlsDelegate);
        this.addDelegate(this.proxyDelegate);
    }

    public Integer getMeasurements() {
        return this.measurements;
    }

    public void setMeasurements(Integer measurements) {
        this.measurements = measurements;
    }

    public String getMonaFile() {
        return this.monaFile;
    }

    public void setMonaFile(String monaFile) {
        this.monaFile = monaFile;
    }

    public String getMonaJar() {
        return this.monaJar;
    }

    public void setMonaJar(String monaJar) {
        this.monaJar = monaJar;
    }

    public String getPaddings() {
        return this.paddings;
    }

    public void setPaddings(String paddings) {
        this.paddings = paddings;
    }

    public Integer getBlocks() {
        return this.blocks;
    }

    public void setBlocks(Integer blocks) {
        this.blocks = blocks;
    }

    @Override
    public boolean isExecuteAttack() {
        return false;
    }

    @Override
    public Config createConfig() {
        Config config = super.createConfig();
        if (this.ciphersuiteDelegate.getCipherSuites() == null) {
            LinkedList<CipherSuite> suiteList = new LinkedList<CipherSuite>();
            suiteList.add(CipherSuite.TLS_RSA_WITH_AES_128_CBC_SHA);
            config.setDefaultServerSupportedCiphersuites(suiteList);
            config.setDefaultClientSupportedCiphersuites(suiteList);
            config.setDefaultSelectedCipherSuite((CipherSuite)((Object)suiteList.get(0)));
        }
        return config;
    }
}

