/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.beaninfo.editors;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.beaninfo.editors.ExtensionListEditor;
import org.openide.awt.Mnemonics;
import org.openide.loaders.ExtensionList;
import org.openide.util.NbBundle;

public class ExtensionListCustomEditor
extends JPanel {
    private ExtensionList value;
    private ExtensionListEditor editor;
    static final long serialVersionUID = -4347656479280614636L;
    private JButton addButton;
    private JButton changeButton;
    private JTextField itemField;
    private JLabel itemLabel;
    private JList itemList;
    private JLabel itemListLabel;
    private JScrollPane itemListScroll;
    private JButton removeButton;

    private String[] getStrings() {
        ArrayList arrayList = new ArrayList();
        if (this.value == null) {
            return new String[0];
        }
        Enumeration enumeration = this.value.extensions();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        enumeration = this.value.mimeTypes();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public ExtensionListCustomEditor(ExtensionListEditor extensionListEditor) {
        this.editor = extensionListEditor;
        this.value = (ExtensionList)((ExtensionList)this.editor.getValue()).clone();
        this.initComponents();
        this.itemList.setCellRenderer(new EmptyStringListCellRenderer());
        this.itemList.setSelectionMode(0);
        this.itemList.setListData(this.getStrings());
        ResourceBundle resourceBundle = NbBundle.getBundle(ExtensionListCustomEditor.class);
        this.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_ELCE"));
        this.itemField.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_ELCE_Item"));
        this.itemList.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_ELCE_ItemList"));
        this.addButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_ELCE_Add"));
        this.changeButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_ELCE_Change"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_ELCE_Remove"));
        if (!this.editor.isEditable()) {
            this.itemField.setEnabled(false);
            this.addButton.setEnabled(false);
            this.changeButton.setEnabled(false);
            this.removeButton.setEnabled(false);
        }
        this.updateButtons();
        this.itemField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                boolean bl = ExtensionListCustomEditor.this.containsCurrent();
                String string = ExtensionListCustomEditor.this.itemField.getText().trim();
                boolean bl2 = ExtensionListCustomEditor.this.itemField.isEnabled() && string.length() > 0 && !bl;
                ExtensionListCustomEditor.this.addButton.setEnabled(bl2);
                ExtensionListCustomEditor.this.changeButton.setEnabled(bl2 && ExtensionListCustomEditor.this.itemList.getSelectedIndex() != -1);
                if (bl) {
                    ExtensionListCustomEditor.this.itemList.setSelectedIndex(ExtensionListCustomEditor.this.idxOfCurrent());
                }
            }
        });
        this.itemField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ExtensionListCustomEditor.this.addButton.isEnabled()) {
                    ExtensionListCustomEditor.this.doAdd();
                }
            }
        });
        this.addButton.setEnabled(false);
        this.changeButton.setEnabled(false);
    }

    private boolean containsCurrent() {
        return this.idxOfCurrent() != -1;
    }

    private int idxOfCurrent() {
        String string = this.itemField.getText().trim();
        if (string.length() > 0) {
            int n = this.itemList.getModel().getSize();
            for (int i = 0; i < n; ++i) {
                if (!string.equals(this.itemList.getModel().getElementAt(i))) continue;
                return i;
            }
        }
        return -1;
    }

    private void initComponents() {
        this.addButton = new JButton();
        this.changeButton = new JButton();
        this.removeButton = new JButton();
        this.itemListScroll = new JScrollPane();
        this.itemList = new JList();
        this.itemLabel = new JLabel();
        this.itemField = new JTextField();
        this.itemListLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage(ExtensionListCustomEditor.class, (String)"CTL_ELCE_Add", (Object[])new Object[0]));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExtensionListCustomEditor.this.addButtonActionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 8, 0, 8);
        this.add((Component)this.addButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.changeButton, (String)NbBundle.getMessage(ExtensionListCustomEditor.class, (String)"CTL_ELCE_Change", (Object[])new Object[0]));
        this.changeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExtensionListCustomEditor.this.changeButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(8, 8, 0, 8);
        this.add((Component)this.changeButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(ExtensionListCustomEditor.class, (String)"CTL_ELCE_Remove", (Object[])new Object[0]));
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExtensionListCustomEditor.this.removeButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        this.add((Component)this.removeButton, gridBagConstraints);
        this.itemList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ExtensionListCustomEditor.this.itemListValueChanged(listSelectionEvent);
            }
        });
        this.itemListScroll.setViewportView(this.itemList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.add((Component)this.itemListScroll, gridBagConstraints);
        this.itemLabel.setLabelFor(this.itemField);
        Mnemonics.setLocalizedText((JLabel)this.itemLabel, (String)NbBundle.getMessage(ExtensionListCustomEditor.class, (String)"CTL_ELCE_Item", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 8, 0, 8);
        this.add((Component)this.itemLabel, gridBagConstraints);
        this.itemField.setColumns(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.add((Component)this.itemField, gridBagConstraints);
        this.itemListLabel.setLabelFor(this.itemList);
        Mnemonics.setLocalizedText((JLabel)this.itemListLabel, (String)NbBundle.getMessage(ExtensionListCustomEditor.class, (String)"CTL_ItemList", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.add((Component)this.itemListLabel, gridBagConstraints);
    }

    private String addTexts() {
        StringTokenizer stringTokenizer = new StringTokenizer(this.itemField.getText(), ",. \n\t");
        String string = null;
        while (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
            if (string.indexOf(47) >= 0) {
                this.value.addMimeType(string);
                continue;
            }
            this.value.addExtension(string);
        }
        return string;
    }

    private void changeButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.itemList.getSelectedIndex();
        String string = (String)this.itemList.getModel().getElementAt(n);
        if (string.indexOf(47) >= 0) {
            this.value.removeMimeType(string);
        } else {
            this.value.removeExtension(string);
        }
        this.doAdd();
    }

    private int indexOf(String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return i;
        }
        return -1;
    }

    private void removeButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.itemList.getSelectedIndex();
        String string = (String)this.itemList.getModel().getElementAt(n);
        if (string.indexOf(47) >= 0) {
            this.value.removeMimeType(string);
        } else {
            this.value.removeExtension(string);
        }
        this.itemList.setListData(this.getStrings());
        int n2 = this.itemList.getModel().getSize();
        if (n2 != 0) {
            if (n >= n2) {
                n = n2 - 1;
            }
            this.itemList.setSelectedIndex(n);
        }
        this.itemList.repaint();
        this.updateValue();
    }

    private void itemListValueChanged(ListSelectionEvent listSelectionEvent) {
        this.updateButtons();
        int n = this.itemList.getSelectedIndex();
        if (n != -1) {
            this.itemField.setText((String)this.itemList.getModel().getElementAt(n));
            this.changeButton.setEnabled(false);
            this.addButton.setEnabled(false);
        }
    }

    private void doAdd() {
        String string = this.addTexts();
        String[] stringArray = this.getStrings();
        int n = this.indexOf(stringArray, string);
        this.itemList.setListData(stringArray);
        if (n >= 0) {
            this.itemList.setSelectedIndex(n);
        }
        this.itemList.repaint();
        this.updateValue();
    }

    private void addButtonActionPerformed(ActionEvent actionEvent) {
        this.doAdd();
    }

    private void updateButtons() {
        int n = this.itemList.getSelectedIndex();
        if (n == -1 || !this.editor.isEditable()) {
            this.removeButton.setEnabled(false);
            this.changeButton.setEnabled(false);
        } else {
            this.removeButton.setEnabled(true);
            this.changeButton.setEnabled(true);
        }
        boolean bl = this.containsCurrent();
        String string = this.itemField.getText().trim();
        boolean bl2 = this.itemField.isEnabled() && string.length() > 0 && !bl;
        this.addButton.setEnabled(bl2);
    }

    private void updateValue() {
        this.editor.setValue(this.value);
    }

    static class EmptyStringListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        protected static Border hasFocusBorder = new LineBorder(UIManager.getColor("List.focusCellHighlight"));
        protected static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
        static final long serialVersionUID = 487512296465844339L;

        public EmptyStringListCellRenderer() {
            this.setOpaque(true);
            this.setBorder(noFocusBorder);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (!(object instanceof String)) {
                return this;
            }
            String string = (String)object;
            if ("".equals(string)) {
                string = NbBundle.getMessage(ExtensionListCustomEditor.class, (String)"CTL_ELCE_Empty");
            }
            this.setText(string);
            if (bl) {
                this.setBackground(UIManager.getColor("List.selectionBackground"));
                this.setForeground(UIManager.getColor("List.selectionForeground"));
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setBorder(bl2 ? hasFocusBorder : noFocusBorder);
            return this;
        }
    }
}

