/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.svg;

import java.awt.geom.AffineTransform;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.UserAgent;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.svg.PDFAElementBridge;
import org.apache.fop.svg.PDFImageElementBridge;
import org.apache.fop.svg.PDFTextElementBridge;

public class PDFBridgeContext
extends BridgeContext {
    private final FontInfo fontInfo;
    private AffineTransform linkTransform;

    public PDFBridgeContext(UserAgent userAgent, DocumentLoader loader, FontInfo fontInfo, AffineTransform linkTransform) {
        super(userAgent, loader);
        this.fontInfo = fontInfo;
        this.linkTransform = linkTransform;
    }

    public PDFBridgeContext(UserAgent userAgent, FontInfo fontInfo, AffineTransform linkTransform) {
        super(userAgent);
        this.fontInfo = fontInfo;
        this.linkTransform = linkTransform;
    }

    public PDFBridgeContext(UserAgent userAgent, FontInfo fontInfo) {
        this(userAgent, fontInfo, null);
    }

    public void registerSVGBridges() {
        super.registerSVGBridges();
        if (this.fontInfo != null) {
            this.putBridge(new PDFTextElementBridge(this.fontInfo));
        }
        PDFAElementBridge pdfAElementBridge = new PDFAElementBridge();
        if (this.linkTransform != null) {
            pdfAElementBridge.setCurrentTransform(this.linkTransform);
        } else {
            pdfAElementBridge.setCurrentTransform(new AffineTransform());
        }
        this.putBridge(pdfAElementBridge);
        this.putBridge(new PDFImageElementBridge());
    }

    public BridgeContext createBridgeContext() {
        return new PDFBridgeContext(this.getUserAgent(), this.getDocumentLoader(), this.fontInfo, this.linkTransform);
    }
}

