/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.updateprovider;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.openide.util.Cancellable;
import org.openide.util.RequestProcessor;

public class NetworkAccess {
    private NetworkAccess() {
    }

    public static Task createNetworkAcessTask(URL uRL, int n, NetworkListener networkListener) {
        return new Task(uRL, n, networkListener);
    }

    public static interface NetworkListener {
        public void streamOpened(InputStream var1);

        public void accessCanceled();

        public void accessTimeOut();

        public void notifyException(Exception var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Task
    implements Cancellable {
        private URL url;
        private int timeout;
        private NetworkListener listener;
        private ExecutorService es = Executors.newSingleThreadExecutor();
        private Future<InputStream> connect = null;
        private RequestProcessor.Task rpTask = null;

        private Task(URL uRL, int n, NetworkListener networkListener) {
            if (uRL == null) {
                throw new IllegalArgumentException("URL cannot be null.");
            }
            if (networkListener == null) {
                throw new IllegalArgumentException("NetworkListener cannot be null.");
            }
            this.url = uRL;
            this.timeout = n;
            this.listener = networkListener;
            this.postTask();
        }

        private void postTask() {
            final Callable<InputStream> callable = this.createCallableNetwork(this.url, this.timeout);
            this.rpTask = RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    Task.this.connect = Task.this.es.submit(callable);
                    InputStream inputStream = null;
                    try {
                        inputStream = (InputStream)Task.this.connect.get();
                        if (Task.this.connect.isDone()) {
                            Task.this.listener.streamOpened(inputStream);
                        } else if (Task.this.connect.isCancelled()) {
                            Task.this.listener.accessCanceled();
                        } else {
                            Task.this.listener.accessTimeOut();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        Task.this.listener.notifyException(interruptedException);
                    }
                    catch (ExecutionException executionException) {
                        Task.this.listener.notifyException(executionException);
                    }
                }
            });
        }

        public void waitFinished() {
            assert (this.rpTask != null) : "RequestProcessor.Task must be initialized.";
            this.rpTask.waitFinished();
        }

        private Callable<InputStream> createCallableNetwork(final URL uRL, final int n) {
            return new Callable<InputStream>(){

                @Override
                public InputStream call() throws Exception {
                    URLConnection uRLConnection = uRL.openConnection();
                    uRLConnection.setConnectTimeout(n);
                    return new BufferedInputStream(uRLConnection.getInputStream());
                }
            };
        }

        public boolean cancel() {
            return this.connect.cancel(true);
        }
    }
}

