/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.util.Collections;
import java.util.EventObject;
import java.util.Set;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileStatusEvent
extends EventObject {
    static final long serialVersionUID = -6428208118782405291L;
    private Set<? extends FileObject> files;
    private boolean icon;
    private boolean name;

    public FileStatusEvent(FileSystem fileSystem, Set<? extends FileObject> set, boolean bl, boolean bl2) {
        super(fileSystem);
        this.files = set;
        this.icon = bl;
        this.name = bl2;
    }

    public FileStatusEvent(FileSystem fileSystem, FileObject fileObject, boolean bl, boolean bl2) {
        this(fileSystem, Collections.singleton(fileObject), bl, bl2);
    }

    public FileStatusEvent(FileSystem fileSystem, boolean bl, boolean bl2) {
        this(fileSystem, (Set<? extends FileObject>)null, bl, bl2);
    }

    public FileSystem getFileSystem() {
        return (FileSystem)this.getSource();
    }

    public boolean isNameChange() {
        return this.name;
    }

    public boolean isIconChange() {
        return this.icon;
    }

    public boolean hasChanged(FileObject fileObject) {
        if (this.files == null) {
            try {
                return fileObject.getFileSystem() == this.getSource();
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                return false;
            }
        }
        return this.files.contains(fileObject);
    }
}

