/*
 * Decompiled with CFR 0.152.
 */
package tr.extract;

import au.com.trgtd.tr.appl.Constants;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import org.openide.util.NbBundle;
import tr.extract.Extract;
import tr.extract.ExtractUtils;
import tr.model.Data;
import tr.model.action.Action;
import tr.model.action.ActionStateDelegated;
import tr.model.action.ActionStateScheduled;
import tr.model.context.Context;
import tr.model.project.Project;
import tr.model.thought.Thought;
import tr.model.topic.Topic;
import tr.util.DateUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtractPocketMod {
    private static final Logger LOG = Logger.getLogger("tr.extract");
    private static final DateFormat DFN = Constants.DATE_FORMAT_FIXED;
    private static final DateFormat DFT = Constants.DATE_TIME_FORMAT_FIXED;
    private static final DateFormat DFTime = new SimpleDateFormat("HH:mm");
    private static final DateFormat DFDay = new SimpleDateFormat("EEE");
    private static final DateFormat DFDayTime = new SimpleDateFormat("EEE HH:mm");
    private static final int PAGES = 8;
    private static final int LINES_PER_PAGE = 32;
    private static final String PAGE_ID_DoASAPDue = "doasap-due";
    private static final String PAGE_ID_DoASAPNoDue = "doasap-no-due";
    private static final String PAGE_ID_DoASAPAll = "doasap-all";
    private static final String PAGE_ID_Today = "today";
    private static final String PAGE_ID_Scheduled = "scheduled";
    private static final String PAGE_ID_Delegated = "delegated";
    private static final String PAGE_ID_ThisWeek = "this-week";
    private static final String PAGE_ID_Overdue = "overdue";
    private static final String PAGE_ID_NewThoughts = "new-thoughts";
    private static final String PAGE_ID_NewThoughtsSpaced = "new-thoughts-spaced";
    private static final String PAGE_ID_Blank = "blank";
    private static final String PAGE_ID_Thoughts = "thoughts";
    private static final String CHECKBOX = "\u2610";
    private static Data data;
    private static Date todayStart;
    private static Date todayEnd;
    private static Date weekEnd;
    private static boolean inclCriteria;
    private static boolean inclProject;

    public static void process(Data data, File xmlfile, String[] pageIDs, Date today, boolean includeCriteria, boolean includeProject) {
        inclCriteria = includeCriteria;
        inclProject = includeProject;
        try {
            Writer out = ExtractPocketMod.initialise(xmlfile);
            ExtractPocketMod.process(data, out, pageIDs, today);
            ExtractPocketMod.finalise(out);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            LOG.severe("Extracting data failed: " + ex.getMessage());
        }
    }

    private static Writer initialise(File xmlfile) throws Exception {
        if (xmlfile.exists()) {
            xmlfile.delete();
        }
        FileOutputStream fout = new FileOutputStream(xmlfile);
        BufferedOutputStream bout = new BufferedOutputStream(fout);
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)bout, "UTF-8");
        out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n");
        out.write("<pages>\r\n");
        return out;
    }

    private static void finalise(Writer out) throws Exception {
        out.write("</pages>\r\n");
        out.flush();
        out.close();
    }

    public static void process(Data pData, Writer out, String[] pageIDs, Date today) {
        if (pData == null) {
            return;
        }
        data = pData;
        todayStart = DateUtils.getStart((Date)(today == null ? new Date() : today));
        todayEnd = DateUtils.getEnd((Date)todayStart);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(todayEnd);
        calendar.add(6, 6);
        weekEnd = calendar.getTime();
        try {
            LOG.info("Extracting data for PocketMod report ... ");
            ExtractPocketMod.processData(out, pageIDs, today);
            LOG.info("Extracting completed");
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            LOG.severe("Extracting failed: " + ex.getMessage());
        }
    }

    private static void processData(Writer out, String[] pageIDs, Date today) throws Exception {
        Page[] pages = new Page[8];
        Vector<String> linesDoASAPDue = null;
        Vector<String> linesDoASAPNoDue = null;
        Vector<String> linesDoASAPAll = null;
        Vector<String> linesToday = null;
        Vector<String> linesScheduled = null;
        Vector<String> linesDelegated = null;
        Vector<String> linesThisWeek = null;
        Vector<String> linesOverdue = null;
        Vector<String> linesNewThoughts = null;
        Vector<String> linesNewThoughtsSpaced = null;
        Vector<String> linesBlank = null;
        Vector<String> linesThoughts = null;
        for (int i = 0; i < 8; ++i) {
            String title;
            pages[i] = new Page();
            if (pageIDs[i].startsWith(PAGE_ID_DoASAPDue)) {
                if (linesDoASAPDue == null) {
                    linesDoASAPDue = new Vector<String>();
                    ExtractPocketMod.populateLinesDoASAPDue(linesDoASAPDue);
                }
                title = NbBundle.getMessage(ExtractPocketMod.class, (String)"Do_ASAP_Due") + " " + ExtractPocketMod.getWeekText(true);
                ExtractPocketMod.populatePage(linesDoASAPDue, pages[i], ExtractPocketMod.getPageNumber(pageIDs[i]), title, true);
                continue;
            }
            if (pageIDs[i].startsWith(PAGE_ID_DoASAPNoDue)) {
                if (linesDoASAPNoDue == null) {
                    linesDoASAPNoDue = new Vector<String>();
                    ExtractPocketMod.populateLinesDoASAPNoDue(linesDoASAPNoDue);
                }
                title = NbBundle.getMessage(ExtractPocketMod.class, (String)"Do_ASAP_No_Due_Date");
                ExtractPocketMod.populatePage(linesDoASAPNoDue, pages[i], ExtractPocketMod.getPageNumber(pageIDs[i]), title, true);
                continue;
            }
            if (pageIDs[i].startsWith(PAGE_ID_DoASAPAll)) {
                if (linesDoASAPAll == null) {
                    linesDoASAPAll = new Vector<String>();
                    ExtractPocketMod.populateLinesDoASAPAll(linesDoASAPAll);
                }
                title = NbBundle.getMessage(ExtractPocketMod.class, (String)"Do_ASAP_ALL");
                ExtractPocketMod.populatePage(linesDoASAPAll, pages[i], ExtractPocketMod.getPageNumber(pageIDs[i]), title, true);
                continue;
            }
            if (pageIDs[i].startsWith(PAGE_ID_Today)) {
                if (linesToday == null) {
                    linesToday = new Vector<String>();
                    ExtractPocketMod.populateLinesToday(linesToday);
                }
                title = NbBundle.getMessage(ExtractPocketMod.class, (String)"Today") + " " + DFN.format(todayStart);
                ExtractPocketMod.populatePage(linesToday, pages[i], ExtractPocketMod.getPageNumber(pageIDs[i]), title, true);
                continue;
            }
            if (pageIDs[i].startsWith(PAGE_ID_Scheduled)) {
                if (linesScheduled == null) {
                    linesScheduled = new Vector<String>();
                    ExtractPocketMod.populateLinesScheduled(linesScheduled);
                }
                title = NbBundle.getMessage(ExtractPocketMod.class, (String)"Scheduled") + " " + ExtractPocketMod.getWeekText(true);
                ExtractPocketMod.populatePage(linesScheduled, pages[i], ExtractPocketMod.getPageNumber(pageIDs[i]), title, true);
                continue;
            }
            if (pageIDs[i].startsWith(PAGE_ID_Delegated)) {
                if (linesDelegated == null) {
                    linesDelegated = new Vector<String>();
                    ExtractPocketMod.populateLinesDelegated(linesDelegated);
                }
                title = NbBundle.getMessage(ExtractPocketMod.class, (String)"Delegated") + " " + ExtractPocketMod.getWeekText(true);
                ExtractPocketMod.populatePage(linesDelegated, pages[i], ExtractPocketMod.getPageNumber(pageIDs[i]), title, true);
                continue;
            }
            if (pageIDs[i].startsWith(PAGE_ID_ThisWeek)) {
                if (linesThisWeek == null) {
                    linesThisWeek = new Vector<String>();
                    ExtractPocketMod.populateLinesThisWeek(linesThisWeek);
                }
                title = NbBundle.getMessage(ExtractPocketMod.class, (String)"This_Week") + " " + ExtractPocketMod.getWeekText(false);
                ExtractPocketMod.populatePage(linesThisWeek, pages[i], ExtractPocketMod.getPageNumber(pageIDs[i]), title, true);
                continue;
            }
            if (pageIDs[i].startsWith(PAGE_ID_Overdue)) {
                if (linesOverdue == null) {
                    linesOverdue = new Vector<String>();
                    ExtractPocketMod.populateLinesOverdue(linesOverdue);
                }
                title = NbBundle.getMessage(ExtractPocketMod.class, (String)"Overdue");
                ExtractPocketMod.populatePage(linesOverdue, pages[i], ExtractPocketMod.getPageNumber(pageIDs[i]), title, true);
                continue;
            }
            if (pageIDs[i].equals(PAGE_ID_NewThoughts)) {
                if (linesNewThoughts == null) {
                    linesNewThoughts = new Vector<String>();
                    ExtractPocketMod.populateLinesNewThoughts(linesNewThoughts);
                }
                title = NbBundle.getMessage(ExtractPocketMod.class, (String)"New_Thoughts");
                ExtractPocketMod.populatePage(linesNewThoughts, pages[i], 1, title, false);
                continue;
            }
            if (pageIDs[i].equals(PAGE_ID_NewThoughtsSpaced)) {
                if (linesNewThoughtsSpaced == null) {
                    linesNewThoughtsSpaced = new Vector<String>();
                    ExtractPocketMod.populateLinesNewThoughtsSpaced(linesNewThoughtsSpaced);
                }
                title = NbBundle.getMessage(ExtractPocketMod.class, (String)"New_Thoughts_(spaced)");
                ExtractPocketMod.populatePage(linesNewThoughtsSpaced, pages[i], 1, title, false);
                continue;
            }
            if (pageIDs[i].equals(PAGE_ID_Blank)) {
                if (linesBlank == null) {
                    linesBlank = new Vector<String>();
                    ExtractPocketMod.populateLinesBlank(linesBlank);
                }
                ExtractPocketMod.populatePage(linesBlank, pages[i], 1, null, false);
                continue;
            }
            if (!pageIDs[i].startsWith(PAGE_ID_Thoughts)) continue;
            if (linesThoughts == null) {
                linesThoughts = new Vector<String>();
                ExtractPocketMod.populateLinesThoughts(linesThoughts);
            }
            title = NbBundle.getMessage(ExtractPocketMod.class, (String)"Thoughts");
            ExtractPocketMod.populatePage(linesThoughts, pages[i], ExtractPocketMod.getPageNumber(pageIDs[i]), title, true);
        }
        for (int pageIndex = 0; pageIndex < 8; ++pageIndex) {
            Page page = pages[pageIndex];
            for (int lineIndex = 0; lineIndex < 32; ++lineIndex) {
                String tag = "p" + (pageIndex + 1) + "l" + (lineIndex + 1);
                out.write("<" + tag + ">" + page.lines[lineIndex] + "</" + tag + ">\r\n");
            }
        }
    }

    private static String getWeekText(boolean includeToday) {
        if (includeToday) {
            return DFN.format(todayStart) + " - " + DFN.format(weekEnd);
        }
        Calendar cal = Calendar.getInstance();
        cal.add(6, 1);
        return DFN.format(cal.getTime()) + " - " + DFN.format(weekEnd);
    }

    private static int getPageNumber(String pageID) {
        if (pageID == null) {
            return 1;
        }
        int lastDashIndex = pageID.lastIndexOf("-");
        if (lastDashIndex == -1) {
            return 1;
        }
        try {
            return Integer.parseInt(pageID.substring(lastDashIndex + 1));
        }
        catch (Exception ex) {
            return 1;
        }
    }

    private static void populateLinesDoASAPDue(Vector<String> lines) {
        Vector<Action> actions = new Vector<Action>();
        ExtractPocketMod.processProjects(actions, ActionFilterDoASAPDue.instance);
        ExtractPocketMod.processSingleActions(actions, ActionFilterDoASAPDue.instance);
        Collections.sort(actions, DueDateComparator.instance);
        for (Action a : actions) {
            lines.add(ExtractPocketMod.checkbox() + ExtractUtils.getState(a, DFDay, DFDayTime) + " " + ExtractPocketMod.descr(a) + ExtractPocketMod.context(a) + ExtractPocketMod.topic(a));
            ExtractPocketMod.addOptionalLines(lines, a);
        }
    }

    private static void populateLinesDoASAPNoDue(Vector<String> lines) {
        Vector<Action> actions = new Vector<Action>();
        ExtractPocketMod.processProjects(actions, ActionFilterDoASAPNoDue.instance);
        ExtractPocketMod.processSingleActions(actions, ActionFilterDoASAPNoDue.instance);
        Collections.sort(actions, ContextComparator.instance);
        Context contextGroup = null;
        for (Action a : actions) {
            if (contextGroup != a.getContext()) {
                contextGroup = a.getContext();
                lines.add(ExtractPocketMod.i(contextGroup.getName()));
            }
            lines.add(ExtractPocketMod.checkbox() + ExtractPocketMod.descr(a) + ExtractPocketMod.topic(a));
            ExtractPocketMod.addOptionalLines(lines, a);
        }
    }

    private static void populateLinesDoASAPAll(Vector<String> lines) {
        Vector<Action> actions = new Vector<Action>();
        ExtractPocketMod.processProjects(actions, ActionFilterDoASAP.instance);
        ExtractPocketMod.processSingleActions(actions, ActionFilterDoASAP.instance);
        Collections.sort(actions, ContextComparator.instance);
        Context contextGroup = null;
        for (Action a : actions) {
            if (contextGroup != a.getContext()) {
                contextGroup = a.getContext();
                lines.add(ExtractPocketMod.i(contextGroup.getName()));
            }
            lines.add(ExtractPocketMod.checkbox() + ExtractPocketMod.dueDate(a) + ExtractPocketMod.descr(a) + ExtractPocketMod.topic(a));
            ExtractPocketMod.addOptionalLines(lines, a);
        }
    }

    private static void populateLinesScheduled(Vector<String> lines) {
        Vector<Action> actions = new Vector<Action>();
        ExtractPocketMod.processProjects(actions, ActionFilterScheduled.instance);
        ExtractPocketMod.processSingleActions(actions, ActionFilterScheduled.instance);
        Collections.sort(actions, ScheduledComparator.instance);
        for (Action action : actions) {
            lines.add(ExtractPocketMod.checkbox() + ExtractUtils.getState(action, DFDay, DFDayTime) + " " + ExtractPocketMod.descr(action) + ExtractPocketMod.context(action) + ExtractPocketMod.topic(action));
            ExtractPocketMod.addOptionalLines(lines, action);
        }
    }

    private static void populateLinesDelegated(Vector<String> lines) {
        Vector<Action> actions = new Vector<Action>();
        ExtractPocketMod.processProjects(actions, ActionFilterDelegated.instance);
        ExtractPocketMod.processSingleActions(actions, ActionFilterDelegated.instance);
        Collections.sort(actions, DelegatedComparator.instance);
        for (Action action : actions) {
            lines.add(ExtractPocketMod.checkbox() + ExtractUtils.getState(action, DFDay, DFDayTime) + " " + ExtractPocketMod.descr(action) + ExtractPocketMod.context(action) + ExtractPocketMod.topic(action));
            ExtractPocketMod.addOptionalLines(lines, action);
        }
    }

    private static void addOptionalLines(Vector<String> lines, Action action) {
        String criteria;
        if (inclProject) {
            Project parent = (Project)action.getParent();
            if (parent == null || parent.isRoot()) {
                String thought;
                String string = thought = action.getThought() == null ? "" : action.getThought().getDescription().trim();
                if (thought.length() > 0) {
                    lines.add("   {" + thought + "}");
                }
            } else {
                lines.add("   [" + ExtractUtils.getProjectPath(parent, "") + "]");
            }
        }
        if (inclCriteria && (criteria = ExtractUtils.getCriteria(action).trim()).length() > 0) {
            lines.add("    " + criteria);
        }
    }

    private static void populateLinesToday(Vector<String> lines) {
        Vector<Action> actions = new Vector<Action>();
        ExtractPocketMod.processProjects(actions, ActionFilterToday.instance);
        ExtractPocketMod.processSingleActions(actions, ActionFilterToday.instance);
        Collections.sort(actions, TodayComparator.instance);
        for (Action a : actions) {
            ActionStateScheduled s;
            if (a.isStateScheduled()) {
                s = (ActionStateScheduled)a.getState();
                String duration = ExtractUtils.getDuration(s);
                if (!duration.equals("")) {
                    duration = " " + duration;
                }
                String time = s.getDate() == null ? "" : " " + DFTime.format(s.getDate());
                lines.add(ExtractPocketMod.checkbox() + ExtractUtils.getSymbol(a) + " " + time + duration + " " + ExtractPocketMod.descr(a) + ExtractPocketMod.context(a) + ExtractPocketMod.topic(a));
            } else if (a.isStateDelegated()) {
                s = (ActionStateDelegated)a.getState();
                String to = s.getTo() == null || s.getTo().trim().length() == 0 ? "" : " " + s.getTo().trim();
                lines.add(ExtractPocketMod.checkbox() + ExtractUtils.getSymbol(a) + ExtractPocketMod.escape(to) + " " + ExtractPocketMod.descr(a) + ExtractPocketMod.context(a) + ExtractPocketMod.topic(a));
            } else {
                lines.add(ExtractPocketMod.checkbox() + ExtractUtils.getSymbol(a) + " " + ExtractPocketMod.descr(a) + ExtractPocketMod.context(a) + ExtractPocketMod.topic(a));
            }
            ExtractPocketMod.addOptionalLines(lines, a);
        }
    }

    private static void populateLinesThisWeek(Vector<String> lines) {
        Vector<Action> actions = new Vector<Action>();
        ExtractPocketMod.processProjects(actions, ActionFilterThisWeek.instance);
        ExtractPocketMod.processSingleActions(actions, ActionFilterThisWeek.instance);
        Collections.sort(actions, ActionDateComparator.instance);
        for (Action a : actions) {
            lines.add(ExtractPocketMod.checkbox() + ExtractUtils.getState(a, DFDay, DFDayTime) + " " + ExtractPocketMod.descr(a) + ExtractPocketMod.context(a) + ExtractPocketMod.topic(a));
            ExtractPocketMod.addOptionalLines(lines, a);
        }
    }

    private static void populateLinesOverdue(Vector<String> lines) {
        Vector<Action> actions = new Vector<Action>();
        ExtractPocketMod.processProjects(actions, ActionFilterOverdue.instance);
        ExtractPocketMod.processSingleActions(actions, ActionFilterOverdue.instance);
        Collections.sort(actions, ActionDateComparator.instance);
        for (Action a : actions) {
            lines.add(ExtractPocketMod.checkbox() + ExtractUtils.getState(a) + " " + ExtractPocketMod.descr(a) + ExtractPocketMod.context(a) + ExtractPocketMod.topic(a));
            ExtractPocketMod.addOptionalLines(lines, a);
        }
    }

    private static void populateLinesNewThoughts(Vector<String> lines) {
        for (int i = 0; i < 32; ++i) {
            lines.add(ExtractPocketMod.checkbox() + "_ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _");
        }
    }

    private static void populateLinesNewThoughtsSpaced(Vector<String> lines) {
        for (int i = 0; i < 32; ++i) {
            if (i % 2 == 0) {
                lines.add(" ");
                continue;
            }
            lines.add(ExtractPocketMod.checkbox() + "_ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _");
        }
    }

    private static void populateLinesBlank(Vector<String> lines) {
        for (int i = 0; i < 32; ++i) {
            lines.add("");
        }
    }

    private static void populateLinesThoughts(Vector<String> lines) {
        Vector<Thought> thoughts = new Vector<Thought>();
        ExtractPocketMod.processThoughts(thoughts);
        for (Thought thought : thoughts) {
            lines.add(ExtractPocketMod.checkbox() + " " + ExtractPocketMod.escape(thought.getDescription()) + " " + ExtractPocketMod.topic(thought.getTopic()));
        }
    }

    private static int compareWithNulls(Date date1, Date date2) {
        if (date1 == date2) {
            return 0;
        }
        if (date1 == null) {
            return -1;
        }
        if (date2 == null) {
            return 1;
        }
        return date1.compareTo(date2);
    }

    private static void populatePage(Vector<String> lines, Page page, int pageNo, String title, boolean showPageNo) {
        assert (lines != null);
        assert (page != null);
        assert (pageNo > 0);
        page.lines[0] = showPageNo ? (title == null ? "" : ExtractPocketMod.escape(ExtractPocketMod.b(title + " (" + pageNo + ")"))) : (title == null ? "" : ExtractPocketMod.escape(ExtractPocketMod.b(title)));
        int lineIndex = (pageNo - 1) * 31;
        for (int i = 1; i < 32; ++i) {
            page.lines[i] = lineIndex < lines.size() ? ExtractPocketMod.escape(lines.get(lineIndex)) : "";
            ++lineIndex;
        }
    }

    private static void processProjects(List<Action> actions, ActionFilter filter) {
        for (Project project : data.getRootProjects().getChildren(Project.class)) {
            ExtractPocketMod.processProject(project, actions, filter);
        }
    }

    private static void processSingleActions(List<Action> actions, ActionFilter filter) {
        ExtractPocketMod.processProject((Project)data.getRootActions(), actions, filter);
    }

    private static void processProject(Project project, List<Action> actions, ActionFilter filter) {
        for (Project subproject : project.getChildren(Project.class)) {
            ExtractPocketMod.processProject(subproject, actions, filter);
        }
        for (Action action : project.getChildren(Action.class)) {
            if (!filter.accept(action)) continue;
            actions.add(action);
        }
    }

    private static void processThoughts(List<Thought> thoughts) {
        for (Thought thought : data.getThoughtManager().list()) {
            if (thought.isProcessed()) continue;
            thoughts.add(thought);
        }
    }

    private static String checkbox() {
        return "\u2610 ";
    }

    private static String actionDate(Action action) {
        return ExtractPocketMod.actionDate(action, false);
    }

    private static String actionDate(Action action, boolean includeTime) {
        Date date = action.getActionDate();
        if (includeTime) {
            return date == null ? "" : DFT.format(date) + " ";
        }
        return date == null ? "" : DFN.format(date) + " ";
    }

    private static String followUpDate(Action action) {
        if (!action.isStateDelegated()) {
            return "";
        }
        Date date = ((ActionStateDelegated)action.getState()).getDate();
        return date == null ? "" : DFN.format(date) + " ";
    }

    private static String dueDate(Action action) {
        if (action.isStateScheduled()) {
            return "";
        }
        Date date = action.getDueDate();
        return date == null ? "" : DFN.format(date) + " ";
    }

    private static String dueDateWithLabel(Action action) {
        if (action.isStateScheduled()) {
            return "";
        }
        Date date = action.getDueDate();
        return date == null ? "" : NbBundle.getMessage(ExtractPocketMod.class, (String)"Due") + DFN.format(date) + " ";
    }

    private static String scheduledDate(Action action) {
        if (!action.isStateScheduled()) {
            return "";
        }
        Date date = ((ActionStateScheduled)action.getState()).getDate();
        return date == null ? "" : DFN.format(date) + " ";
    }

    private static String duration(Action action) {
        if (!action.isStateScheduled()) {
            return "";
        }
        ActionStateScheduled s = (ActionStateScheduled)action.getState();
        int h = s.getDurationHours();
        int m = s.getDurationMinutes();
        if (h < 1 && m < 1) {
            return "";
        }
        return (h > 0 ? h + "h" : "") + (m > 0 ? m + "m" : "") + " ";
    }

    private static String context(Action action) {
        return action == null ? "" : ExtractPocketMod.i(action.getContext().getName()) + " ";
    }

    private static String topic(Action action) {
        return action == null ? "" : ExtractPocketMod.topic(action.getTopic());
    }

    private static String topic(Topic topic) {
        return topic == null ? "" : ExtractPocketMod.i(ExtractPocketMod.u(topic.getName())) + " ";
    }

    private static String descr(Action action) {
        return action == null ? "" : action.getDescription() + " ";
    }

    private static String escape(String string) {
        return Extract.FormatType.XML.escape(string);
    }

    private static String i(String string) {
        return "<I>" + string + "</I>";
    }

    private static String b(String string) {
        return "<B>" + string + "</B>";
    }

    private static String u(String string) {
        return "<U>" + string + "</U>";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TodayComparator
    implements Comparator<Action> {
        public static final Comparator<Action> instance = new ActionDateComparator();

        private TodayComparator() {
        }

        @Override
        public int compare(Action a1, Action a2) {
            if (a1.isStateScheduled() && a2.isStateScheduled()) {
                Date d1 = ((ActionStateScheduled)a1.getState()).getDate();
                Date d2 = ((ActionStateScheduled)a2.getState()).getDate();
                return ExtractPocketMod.compareWithNulls(d1, d2);
            }
            if (a1.isStateScheduled()) {
                return -1;
            }
            if (a2.isStateScheduled()) {
                return 1;
            }
            return a1.getDescription().compareToIgnoreCase(a2.getDescription());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ActionDateComparator
    implements Comparator<Action> {
        public static final Comparator<Action> instance = new ActionDateComparator();

        private ActionDateComparator() {
        }

        @Override
        public int compare(Action a1, Action a2) {
            return ExtractPocketMod.compareWithNulls(a1.getActionDate(), a2.getActionDate());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DelegatedComparator
    implements Comparator<Action> {
        public static final Comparator<Action> instance = new DelegatedComparator();

        private DelegatedComparator() {
        }

        @Override
        public int compare(Action a1, Action a2) {
            Date d1 = ((ActionStateDelegated)a1.getState()).getDate();
            Date d2 = ((ActionStateDelegated)a2.getState()).getDate();
            return ExtractPocketMod.compareWithNulls(d1, d2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ScheduledComparator
    implements Comparator<Action> {
        public static final Comparator<Action> instance = new ScheduledComparator();

        private ScheduledComparator() {
        }

        @Override
        public int compare(Action a1, Action a2) {
            Date d1 = ((ActionStateScheduled)a1.getState()).getDate();
            Date d2 = ((ActionStateScheduled)a2.getState()).getDate();
            return ExtractPocketMod.compareWithNulls(d1, d2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DueDateComparator
    implements Comparator<Action> {
        public static final Comparator<Action> instance = new DueDateComparator();

        private DueDateComparator() {
        }

        @Override
        public int compare(Action a1, Action a2) {
            return ExtractPocketMod.compareWithNulls(a1.getDueDate(), a2.getDueDate());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ContextComparator
    implements Comparator<Action> {
        public static final Comparator<Action> instance = new ContextComparator();

        private ContextComparator() {
        }

        @Override
        public int compare(Action a1, Action a2) {
            int r = a1.getContext().compareTo(a2.getContext());
            if (r != 0) {
                return r;
            }
            r = ExtractPocketMod.compareWithNulls(DateUtils.clearTime((Date)a1.getActionDate()), DateUtils.clearTime((Date)a2.getActionDate()));
            if (r != 0) {
                return r;
            }
            return a1.getDescription().compareToIgnoreCase(a2.getDescription());
        }
    }

    private static class ActionFilterToday
    implements ActionFilter {
        public static final ActionFilter instance = new ActionFilterToday();

        private ActionFilterToday() {
        }

        public boolean accept(Action a) {
            if (a == null || a.isDone()) {
                return false;
            }
            return a.getActionDate() != null && !a.getActionDate().before(todayStart) && !a.getActionDate().after(todayEnd);
        }
    }

    private static class ActionFilterThisWeek
    implements ActionFilter {
        public static final ActionFilter instance = new ActionFilterThisWeek();

        private ActionFilterThisWeek() {
        }

        public boolean accept(Action a) {
            if (a == null || a.isDone()) {
                return false;
            }
            return a.getActionDate() != null && !a.getActionDate().before(todayEnd) && !a.getActionDate().after(weekEnd);
        }
    }

    private static class ActionFilterOverdue
    implements ActionFilter {
        public static final ActionFilter instance = new ActionFilterOverdue();

        private ActionFilterOverdue() {
        }

        public boolean accept(Action a) {
            if (a == null || a.isDone()) {
                return false;
            }
            return a.getActionDate() != null && a.getActionDate().before(todayStart);
        }
    }

    private static class ActionFilterDelegated
    implements ActionFilter {
        public static final ActionFilter instance = new ActionFilterDelegated();

        private ActionFilterDelegated() {
        }

        public boolean accept(Action a) {
            if (a == null || a.isDone() || !a.isStateDelegated()) {
                return false;
            }
            Date date = ((ActionStateDelegated)a.getState()).getDate();
            return date != null && !date.before(todayStart) && !date.after(weekEnd);
        }
    }

    private static class ActionFilterScheduled
    implements ActionFilter {
        public static final ActionFilter instance = new ActionFilterScheduled();

        private ActionFilterScheduled() {
        }

        public boolean accept(Action a) {
            if (a == null || a.isDone() || !a.isStateScheduled()) {
                return false;
            }
            Date date = ((ActionStateScheduled)a.getState()).getDate();
            return date != null && !date.before(todayStart) && !date.after(weekEnd);
        }
    }

    private static class ActionFilterDoASAPDue
    implements ActionFilter {
        public static final ActionFilter instance = new ActionFilterDoASAPDue();

        private ActionFilterDoASAPDue() {
        }

        public boolean accept(Action a) {
            if (a == null || a.isDone() || !a.isStateASAP()) {
                return false;
            }
            Date due = a.getDueDate();
            return due != null && !due.before(todayStart) && !due.after(weekEnd);
        }
    }

    private static class ActionFilterDoASAPNoDue
    implements ActionFilter {
        public static final ActionFilter instance = new ActionFilterDoASAPNoDue();

        private ActionFilterDoASAPNoDue() {
        }

        public boolean accept(Action a) {
            if (a == null || a.isDone() || !a.isStateASAP()) {
                return false;
            }
            return a.getDueDate() == null;
        }
    }

    private static class ActionFilterDoASAP
    implements ActionFilter {
        public static final ActionFilter instance = new ActionFilterDoASAP();

        private ActionFilterDoASAP() {
        }

        public boolean accept(Action a) {
            return a != null && !a.isDone() && a.isStateASAP();
        }
    }

    private static interface ActionFilter {
        public boolean accept(Action var1);
    }

    private static class Page {
        public final String[] lines = new String[32];

        private Page() {
        }
    }
}

