/*
 * Decompiled with CFR 0.152.
 */
package au.com.trgtd.tr.calendar.prefs;

import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class CalendarPrefs {
    private static final Logger LOG = Logger.getLogger("tr.prefs.calendar");
    private static final Preferences prefs = Preferences.userRoot().node("ThinkingRock/2.2.1/calendar");
    private static final String KEY_REQUIRED = "icalendar.required";
    private static final boolean DEF_REQUIRED = false;
    private static final String KEY_ID_SYNCHRONIZER = "id.synchronizer";
    private static final String KEY_SYNC_INACTIVE = "sync.inactive";
    private static final boolean DEF_SYNC_INACTIVE = false;
    private static final String KEY_TODO_INACTIVE = "todo.inactive";
    private static final boolean DEF_TODO_INACTIVE = true;
    private static final String KEY_SYNC_DOASAP_DUE_DATE = "sync.doasap.due.date";
    private static final boolean DEF_SYNC_DOASAP_DUE_DATE = false;
    private static final String KEY_TODO_DOASAP_DUE_DATE = "todo.doasap.due.date";
    private static final boolean DEF_TODO_DOASAP_DUE_DATE = true;
    private static final String KEY_SYNC_DOASAP_NO_DUE_DATE = "sync.doasap.no.due.date";
    private static final boolean DEF_SYNC_DOASAP_NO_DUE_DATE = false;
    private static final String KEY_SYNC_DELEGATED = "sync.delegated";
    private static final boolean DEF_SYNC_DELEGATED = false;
    private static final String KEY_TODO_DELEGATED = "todo.delegated";
    private static final boolean DEF_TODO_DELEGATED = true;
    private static final String KEY_SYNC_DELEGATED_NO_DATE = "sync.delegated.no.due.date";
    private static final boolean DEF_SYNC_DELEGATED_NO_DATE = false;
    private static final String KEY_SYNC_SCHEDULED = "sync.scheduled";
    private static final boolean DEF_SYNC_SCHEDULED = false;

    public static final boolean isICalendarRequired() {
        return prefs.getBoolean(KEY_REQUIRED, false);
    }

    public static final void setICalendarRequired(boolean value) {
        prefs.putBoolean(KEY_REQUIRED, value);
        CalendarPrefs.flush();
    }

    public static final String getSynchronizerID() {
        return prefs.get(KEY_ID_SYNCHRONIZER, "");
    }

    public static final void setSynchronizerID(String value) {
        prefs.put(KEY_ID_SYNCHRONIZER, value);
        CalendarPrefs.flush();
    }

    public static final boolean isSyncDoasapDueDate() {
        return prefs.getBoolean(KEY_SYNC_DOASAP_DUE_DATE, false);
    }

    public static final void setSyncDoASAPWithDueDate(boolean value) {
        prefs.putBoolean(KEY_SYNC_DOASAP_DUE_DATE, value);
        CalendarPrefs.flush();
    }

    public static final boolean isSyncDoasapNoDueDate() {
        return prefs.getBoolean(KEY_SYNC_DOASAP_NO_DUE_DATE, false);
    }

    public static final void setSyncDoASAPWithNoDueDate(boolean value) {
        prefs.putBoolean(KEY_SYNC_DOASAP_NO_DUE_DATE, value);
        CalendarPrefs.flush();
    }

    public static final boolean isSyncDelegated() {
        return prefs.getBoolean(KEY_SYNC_DELEGATED, false);
    }

    public static final void setSyncDelegated(boolean value) {
        prefs.putBoolean(KEY_SYNC_DELEGATED, value);
        CalendarPrefs.flush();
    }

    public static final boolean isSyncDelegatedNoDate() {
        return prefs.getBoolean(KEY_SYNC_DELEGATED_NO_DATE, false);
    }

    public static final void setSyncDelegatedNoDate(boolean value) {
        prefs.putBoolean(KEY_SYNC_DELEGATED_NO_DATE, value);
        CalendarPrefs.flush();
    }

    public static final boolean isSyncScheduled() {
        return prefs.getBoolean(KEY_SYNC_SCHEDULED, false);
    }

    public static final void setSyncScheduled(boolean value) {
        prefs.putBoolean(KEY_SYNC_SCHEDULED, value);
        CalendarPrefs.flush();
    }

    public static final boolean isDoasapDueAsTodo() {
        return prefs.getBoolean(KEY_TODO_DOASAP_DUE_DATE, true);
    }

    public static final void setDoasapDueAsTodo(boolean value) {
        prefs.putBoolean(KEY_TODO_DOASAP_DUE_DATE, value);
        CalendarPrefs.flush();
    }

    public static final boolean isDelegatedAsTodo() {
        return prefs.getBoolean(KEY_TODO_DELEGATED, true);
    }

    public static final void setDelegatedAsTodo(boolean value) {
        prefs.putBoolean(KEY_TODO_DELEGATED, value);
        CalendarPrefs.flush();
    }

    public static final boolean isSyncInactive() {
        return prefs.getBoolean(KEY_SYNC_INACTIVE, false);
    }

    public static final void setSyncInactive(boolean value) {
        prefs.putBoolean(KEY_SYNC_INACTIVE, value);
        CalendarPrefs.flush();
    }

    public static final boolean isInactiveAsTodo() {
        return prefs.getBoolean(KEY_TODO_INACTIVE, true);
    }

    public static final void setInactiveAsTodo(boolean value) {
        prefs.putBoolean(KEY_TODO_INACTIVE, value);
        CalendarPrefs.flush();
    }

    private static void flush() {
        try {
            prefs.flush();
        }
        catch (BackingStoreException ex) {
            LOG.severe("Calendar preferences error. " + ex.getMessage());
        }
    }
}

