/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.smtp;

import com.sun.mail.util.ASCIIUtility;
import com.sun.mail.util.BASE64DecoderStream;
import com.sun.mail.util.BASE64EncoderStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StreamTokenizer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class DigestMD5 {
    private PrintStream debugout;
    private MessageDigest md5;
    private String uri;
    private String clientResponse;
    private static char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public DigestMD5(PrintStream printStream) {
        this.debugout = printStream;
        if (printStream != null) {
            printStream.println("DEBUG DIGEST-MD5: Loaded");
        }
    }

    public byte[] authClient(String string, String string2, String string3, String string4, String string5) throws IOException {
        String string6;
        SecureRandom secureRandom;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BASE64EncoderStream bASE64EncoderStream = new BASE64EncoderStream(byteArrayOutputStream, Integer.MAX_VALUE);
        try {
            secureRandom = new SecureRandom();
            this.md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if (this.debugout != null) {
                this.debugout.println("DEBUG DIGEST-MD5: " + noSuchAlgorithmException);
            }
            throw new IOException(noSuchAlgorithmException.toString());
        }
        StringBuffer stringBuffer = new StringBuffer();
        this.uri = "smtp/" + string;
        String string7 = "00000001";
        String string8 = "auth";
        byte[] byArray = new byte[32];
        if (this.debugout != null) {
            this.debugout.println("DEBUG DIGEST-MD5: Begin authentication ...");
        }
        Hashtable hashtable = this.tokenize(string5);
        if (string4 == null) {
            string6 = (String)hashtable.get("realm");
            string4 = string6 != null ? new StringTokenizer(string6, ",").nextToken() : string;
        }
        string6 = (String)hashtable.get("nonce");
        secureRandom.nextBytes(byArray);
        ((OutputStream)bASE64EncoderStream).write(byArray);
        ((OutputStream)bASE64EncoderStream).flush();
        String string9 = byteArrayOutputStream.toString();
        byteArrayOutputStream.reset();
        this.md5.update(this.md5.digest(ASCIIUtility.getBytes(string2 + ":" + string4 + ":" + string3)));
        this.md5.update(ASCIIUtility.getBytes(":" + string6 + ":" + string9));
        this.clientResponse = DigestMD5.toHex(this.md5.digest()) + ":" + string6 + ":" + string7 + ":" + string9 + ":" + string8 + ":";
        this.md5.update(ASCIIUtility.getBytes("AUTHENTICATE:" + this.uri));
        this.md5.update(ASCIIUtility.getBytes(this.clientResponse + DigestMD5.toHex(this.md5.digest())));
        stringBuffer.append("username=\"" + string2 + "\"");
        stringBuffer.append(",realm=\"" + string4 + "\"");
        stringBuffer.append(",qop=" + string8);
        stringBuffer.append(",nc=" + string7);
        stringBuffer.append(",nonce=\"" + string6 + "\"");
        stringBuffer.append(",cnonce=\"" + string9 + "\"");
        stringBuffer.append(",digest-uri=\"" + this.uri + "\"");
        stringBuffer.append(",response=" + DigestMD5.toHex(this.md5.digest()));
        if (this.debugout != null) {
            this.debugout.println("DEBUG DIGEST-MD5: Response => " + stringBuffer.toString());
        }
        ((OutputStream)bASE64EncoderStream).write(ASCIIUtility.getBytes(stringBuffer.toString()));
        ((OutputStream)bASE64EncoderStream).flush();
        return byteArrayOutputStream.toByteArray();
    }

    public boolean authServer(String string) throws IOException {
        Hashtable hashtable = this.tokenize(string);
        this.md5.update(ASCIIUtility.getBytes(":" + this.uri));
        this.md5.update(ASCIIUtility.getBytes(this.clientResponse + DigestMD5.toHex(this.md5.digest())));
        String string2 = DigestMD5.toHex(this.md5.digest());
        if (!string2.equals((String)hashtable.get("rspauth"))) {
            if (this.debugout != null) {
                this.debugout.println("DEBUG DIGEST-MD5: Expected => rspauth=" + string2);
            }
            return false;
        }
        return true;
    }

    private Hashtable tokenize(String string) throws IOException {
        int n;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        byte[] byArray = string.getBytes();
        String string2 = null;
        StreamTokenizer streamTokenizer = new StreamTokenizer(new InputStreamReader(new BASE64DecoderStream(new ByteArrayInputStream(byArray, 4, byArray.length - 4))));
        streamTokenizer.ordinaryChars(48, 57);
        streamTokenizer.wordChars(48, 57);
        while ((n = streamTokenizer.nextToken()) != -1) {
            switch (n) {
                case -3: {
                    if (string2 == null) {
                        string2 = streamTokenizer.sval;
                        break;
                    }
                }
                case 34: {
                    if (this.debugout != null) {
                        this.debugout.println("DEBUG DIGEST-MD5: Received => " + string2 + "='" + streamTokenizer.sval + "'");
                    }
                    if (hashtable.containsKey(string2)) {
                        hashtable.put(string2, hashtable.get(string2) + "," + streamTokenizer.sval);
                    } else {
                        hashtable.put(string2, streamTokenizer.sval);
                    }
                    string2 = null;
                }
            }
        }
        return hashtable;
    }

    private static String toHex(byte[] byArray) {
        char[] cArray = new char[byArray.length * 2];
        int n = 0;
        int n2 = 0;
        while (n < byArray.length) {
            int n3 = byArray[n] & 0xFF;
            cArray[n2++] = digits[n3 >> 4];
            cArray[n2++] = digits[n3 & 0xF];
            ++n;
        }
        return new String(cArray);
    }
}

