/*
 * Decompiled with CFR 0.152.
 */
package tr.view.action.recurrence.modify;

import au.com.trgtd.tr.appl.Constants;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jdesktop.layout.GroupLayout;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import tr.model.action.Action;
import tr.model.action.ActionStateScheduled;
import tr.model.action.Recurrence;
import tr.model.project.Project;
import tr.util.Utils;
import tr.view.project.combo.ProjectsComboBox;

public final class ModifyRecurrenceVisualPanelModProject1
extends JPanel {
    private static long counter;
    private final Project currentProject;
    private final Date currentStartDate;
    private final Date currentActionDate;
    private JLabel fillerLabel;
    private JRadioButton moveActionDateRadioButton;
    private JRadioButton moveAllRadioButton;
    private JLabel moveLabel;
    private JRadioButton moveStartDateRadioButton;
    private ButtonGroup movebuttonGroup;
    private ProjectsComboBox projectCurrentComboBox;
    private JLabel projectCurrentLabel;
    private ProjectsComboBox projectNewComboBox;
    private JLabel projectNewLabel;

    public ModifyRecurrenceVisualPanelModProject1(Recurrence recurrence, Action action) {
        this.currentProject = recurrence.getProject();
        this.currentStartDate = recurrence.getStartDate();
        this.currentActionDate = ((ActionStateScheduled)action.getState()).getDate();
        this.initComponents();
        this.initPanel();
    }

    public String getName() {
        return NbBundle.getMessage(ModifyRecurrenceVisualPanelModProject1.class, (String)"change.project.details");
    }

    public Boolean isMoveAll() {
        return this.moveAllRadioButton.isSelected();
    }

    public Date getMoveDate() {
        if (this.isMoveAll().booleanValue()) {
            return null;
        }
        if (this.moveStartDateRadioButton.isSelected()) {
            return this.currentStartDate;
        }
        if (this.moveActionDateRadioButton.isSelected()) {
            return this.currentActionDate;
        }
        return null;
    }

    public Project getNewProject() {
        return (Project)this.projectNewComboBox.getSelectedItem();
    }

    private void moveChanged() {
        this.stateChange();
        this.enableDisableFields();
    }

    private void projectChanged() {
        this.stateChange();
    }

    private void stateChange() {
        this.putClientProperty("state.change", ++counter);
    }

    private void enableDisableFields() {
        this.projectCurrentComboBox.setEnabled(false);
        this.moveAllRadioButton.setEnabled(true);
        this.moveActionDateRadioButton.setEnabled(true);
        this.moveStartDateRadioButton.setEnabled(true);
    }

    private void initPanel() {
        this.projectCurrentComboBox.setSelectedItem((Object)this.currentProject);
        this.projectNewComboBox.setSelectedItem(null);
        this.moveActionDateRadioButton.setSelected(true);
        String strActionDate = Constants.DATE_FORMAT_FIXED.format(this.currentActionDate);
        this.moveActionDateRadioButton.setText(this.moveActionDateRadioButton.getText() + " (" + strActionDate + ")");
        String strStartDate = Constants.DATE_FORMAT_FIXED.format(this.currentStartDate);
        this.moveStartDateRadioButton.setText(this.moveStartDateRadioButton.getText() + " (" + strStartDate + ")");
        this.moveChanged();
    }

    public boolean isFormValid() {
        if (Utils.equal((Object)this.currentProject, (Object)this.getNewProject())) {
            return false;
        }
        return this.isMoveAll() != false || this.getMoveDate() != null;
    }

    private void initComponents() {
        this.movebuttonGroup = new ButtonGroup();
        this.moveStartDateRadioButton = new JRadioButton();
        this.moveActionDateRadioButton = new JRadioButton();
        this.projectCurrentLabel = new JLabel();
        this.projectCurrentComboBox = new ProjectsComboBox();
        this.projectNewLabel = new JLabel();
        this.projectNewComboBox = new ProjectsComboBox();
        this.fillerLabel = new JLabel();
        this.moveAllRadioButton = new JRadioButton();
        this.moveLabel = new JLabel();
        this.setMaximumSize(new Dimension(1024, 768));
        this.setMinimumSize(new Dimension(480, 360));
        this.setPreferredSize(new Dimension(640, 480));
        this.movebuttonGroup.add(this.moveStartDateRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.moveStartDateRadioButton, (String)NbBundle.getMessage(ModifyRecurrenceVisualPanelModProject1.class, (String)"dated.from.recurrence.start.date"));
        this.moveStartDateRadioButton.setMaximumSize(new Dimension(178, 23));
        this.moveStartDateRadioButton.setMinimumSize(new Dimension(178, 23));
        this.moveStartDateRadioButton.setPreferredSize(new Dimension(178, 23));
        this.moveStartDateRadioButton.setVerticalTextPosition(1);
        this.moveStartDateRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ModifyRecurrenceVisualPanelModProject1.this.moveStartDateRadioButtonActionPerformed(evt);
            }
        });
        this.movebuttonGroup.add(this.moveActionDateRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.moveActionDateRadioButton, (String)NbBundle.getMessage(ModifyRecurrenceVisualPanelModProject1.class, (String)"dated.from.selected.action.date"));
        this.moveActionDateRadioButton.setMaximumSize(new Dimension(178, 23));
        this.moveActionDateRadioButton.setMinimumSize(new Dimension(178, 23));
        this.moveActionDateRadioButton.setPreferredSize(new Dimension(178, 23));
        this.moveActionDateRadioButton.setVerticalTextPosition(1);
        this.moveActionDateRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ModifyRecurrenceVisualPanelModProject1.this.moveActionDateRadioButtonActionPerformed(evt);
            }
        });
        this.projectCurrentLabel.setHorizontalAlignment(11);
        Mnemonics.setLocalizedText((JLabel)this.projectCurrentLabel, (String)NbBundle.getMessage(ModifyRecurrenceVisualPanelModProject1.class, (String)"current.project"));
        this.projectCurrentLabel.setMaximumSize(new Dimension(100, 23));
        this.projectCurrentLabel.setMinimumSize(new Dimension(100, 23));
        this.projectCurrentLabel.setPreferredSize(new Dimension(100, 23));
        this.projectCurrentComboBox.setEnabled(false);
        this.projectCurrentComboBox.setMaximumSize(new Dimension(Short.MAX_VALUE, 23));
        this.projectCurrentComboBox.setMinimumSize(new Dimension(41, 23));
        this.projectCurrentComboBox.setPreferredSize(new Dimension(41, 23));
        this.projectNewLabel.setHorizontalAlignment(11);
        Mnemonics.setLocalizedText((JLabel)this.projectNewLabel, (String)NbBundle.getMessage(ModifyRecurrenceVisualPanelModProject1.class, (String)"new.project"));
        this.projectNewLabel.setMaximumSize(new Dimension(100, 23));
        this.projectNewLabel.setMinimumSize(new Dimension(100, 23));
        this.projectNewLabel.setPreferredSize(new Dimension(100, 23));
        this.projectNewComboBox.setMaximumSize(new Dimension(Short.MAX_VALUE, 23));
        this.projectNewComboBox.setMinimumSize(new Dimension(41, 23));
        this.projectNewComboBox.setPreferredSize(new Dimension(41, 23));
        this.projectNewComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ModifyRecurrenceVisualPanelModProject1.this.projectNewComboBoxActionPerformed(evt);
            }
        });
        this.fillerLabel.setHorizontalAlignment(11);
        this.fillerLabel.setMaximumSize(new Dimension(100, 23));
        this.fillerLabel.setMinimumSize(new Dimension(100, 23));
        this.fillerLabel.setPreferredSize(new Dimension(100, 23));
        this.movebuttonGroup.add(this.moveAllRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.moveAllRadioButton, (String)NbBundle.getMessage(ModifyRecurrenceVisualPanelModProject1.class, (String)"all"));
        this.moveAllRadioButton.setVerticalTextPosition(1);
        this.moveAllRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ModifyRecurrenceVisualPanelModProject1.this.moveAllRadioButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.moveLabel, (String)NbBundle.getMessage(ModifyRecurrenceVisualPanelModProject1.class, (String)"modify.project.move"));
        this.moveLabel.setMaximumSize(new Dimension(150, 23));
        this.moveLabel.setMinimumSize(new Dimension(150, 23));
        this.moveLabel.setPreferredSize(new Dimension(150, 23));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.moveLabel, -1, 600, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.projectCurrentLabel, -2, 101, -2).add((Component)this.projectNewLabel, -2, 101, -2)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.projectNewComboBox, -1, 488, Short.MAX_VALUE).add((Component)this.projectCurrentComboBox, -1, 488, Short.MAX_VALUE))).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.fillerLabel, -2, 101, -2).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.moveAllRadioButton, -1, 489, Short.MAX_VALUE).add((Component)this.moveStartDateRadioButton, -1, 489, Short.MAX_VALUE).add(2, (Component)this.moveActionDateRadioButton, -1, 489, Short.MAX_VALUE)))).addContainerGap()));
        layout.linkSize(new Component[]{this.projectCurrentLabel, this.projectNewLabel}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.projectCurrentLabel, -2, -1, -2).add((Component)this.projectCurrentComboBox, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.projectNewLabel, -2, -1, -2).add((Component)this.projectNewComboBox, -2, -1, -2)).add(18, 18, 18).add((Component)this.moveLabel, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.fillerLabel, -2, -1, -2).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.moveAllRadioButton).addPreferredGap(1).add((Component)this.moveStartDateRadioButton, -2, -1, -2))).addPreferredGap(1).add((Component)this.moveActionDateRadioButton, -2, -1, -2).addContainerGap(273, Short.MAX_VALUE)));
    }

    private void moveActionDateRadioButtonActionPerformed(ActionEvent evt) {
        this.moveChanged();
    }

    private void projectNewComboBoxActionPerformed(ActionEvent evt) {
        this.projectChanged();
    }

    private void moveStartDateRadioButtonActionPerformed(ActionEvent evt) {
        this.moveChanged();
    }

    private void moveAllRadioButtonActionPerformed(ActionEvent evt) {
        this.moveChanged();
    }
}

