/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.parser.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HtmlDeepParser {
    public static final Set<String> BLOCK_TAGS = new HashSet<String>();
    public static final Set<String> VOID_TAGS = new HashSet<String>();
    public static final Map<String, Set<String>> OPTIONAL_TAGS;
    public static final Pattern START_PATTERN;
    private static final HtmlMatch[] PATTERN_MAP;
    private final ArrayList<String> myOpenTags = new ArrayList();
    private Pattern myClosingPattern = null;
    private HtmlMatch myHtmlMatch = null;
    private int myHtmlCount = 0;
    private final HashSet<String> myBlockTags = new HashSet<String>(BLOCK_TAGS);
    private boolean myFirstBlockTag = false;

    public HtmlDeepParser() {
        this(Collections.emptyList());
    }

    public HtmlDeepParser(List<String> customTags) {
        this.myBlockTags.addAll(customTags);
    }

    public ArrayList<String> getOpenTags() {
        return this.myOpenTags;
    }

    public Pattern getClosingPattern() {
        return this.myClosingPattern;
    }

    public HtmlMatch getHtmlMatch() {
        return this.myHtmlMatch;
    }

    public int getHtmlCount() {
        return this.myHtmlCount;
    }

    public boolean isFirstBlockTag() {
        return this.myFirstBlockTag;
    }

    public boolean isHtmlClosed() {
        return this.myClosingPattern == null && this.myOpenTags.isEmpty();
    }

    public boolean isBlankLineInterruptible() {
        return this.myOpenTags.isEmpty() && this.myClosingPattern == null || this.myHtmlMatch == HtmlMatch.OPEN_TAG && this.myClosingPattern != null && this.myOpenTags.size() == 1;
    }

    public boolean haveOpenRawTag() {
        return this.myClosingPattern != null && this.myHtmlMatch != HtmlMatch.OPEN_TAG;
    }

    public boolean haveOpenBlockTag() {
        if (!this.myOpenTags.isEmpty()) {
            for (String openTag : this.myOpenTags) {
                if (!this.myBlockTags.contains(openTag)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hadHtml() {
        return this.myHtmlCount > 0 || !this.isHtmlClosed();
    }

    private void openTag(String tagName) {
        String lastTag;
        if (!this.myOpenTags.isEmpty() && OPTIONAL_TAGS.containsKey(lastTag = this.myOpenTags.get(this.myOpenTags.size() - 1)) && OPTIONAL_TAGS.get(lastTag).contains(tagName)) {
            this.myOpenTags.set(this.myOpenTags.size() - 1, tagName);
            return;
        }
        this.myOpenTags.add(tagName);
        this.myFirstBlockTag = this.myBlockTags.contains(tagName);
    }

    public void parseHtmlChunk(CharSequence html, boolean blockTagsOnly, boolean parseNonBlock, boolean firstOpenTagOnOneLine) {
        if (this.myHtmlCount == 0 && this.myHtmlMatch != null) {
            ++this.myHtmlCount;
        }
        String pendingOpen = null;
        boolean useFirstOpenTagOnOneLine = firstOpenTagOnOneLine;
        while (html.length() != 0) {
            Matcher matcher;
            if (this.myClosingPattern != null) {
                matcher = this.myClosingPattern.matcher(html);
                if (!matcher.find()) break;
                if (this.myHtmlMatch == HtmlMatch.OPEN_TAG) {
                    if (matcher.group().equals("<")) {
                        if (pendingOpen == null) {
                            this.myOpenTags.remove(this.myOpenTags.size() - 1);
                        } else if (useFirstOpenTagOnOneLine) {
                            pendingOpen = null;
                            this.myClosingPattern = null;
                            break;
                        }
                    } else {
                        useFirstOpenTagOnOneLine = false;
                        if (matcher.group().endsWith("/>")) {
                            if (pendingOpen == null) {
                                this.myOpenTags.remove(this.myOpenTags.size() - 1);
                            }
                            if (this.myHtmlCount == 0) {
                                ++this.myHtmlCount;
                            }
                        } else if (pendingOpen != null) {
                            if (!VOID_TAGS.contains(pendingOpen)) {
                                this.openTag(pendingOpen);
                            }
                            ++this.myHtmlCount;
                        }
                        html = html.subSequence(matcher.end(), html.length());
                    }
                } else {
                    html = html.subSequence(matcher.end(), html.length());
                }
                pendingOpen = null;
                this.myClosingPattern = null;
                continue;
            }
            matcher = START_PATTERN.matcher(html);
            if (!matcher.find()) break;
            CharSequence nextHtml = html.subSequence(matcher.end(), html.length());
            int iMax = PATTERN_MAP.length;
            this.myClosingPattern = null;
            block1: for (int i = 1; i < iMax; ++i) {
                String leading;
                if (matcher.group(i) == null) continue;
                String group = matcher.group(i).toLowerCase();
                HtmlMatch htmlMatch = PATTERN_MAP[i];
                boolean isBlockTag = this.myBlockTags.contains(group);
                if ((blockTagsOnly || !parseNonBlock) && matcher.start() > 0 && !(leading = html.subSequence(0, matcher.start()).toString()).trim().isEmpty()) break;
                if (htmlMatch != HtmlMatch.OPEN_TAG && htmlMatch != HtmlMatch.CLOSE_TAG) {
                    this.myClosingPattern = htmlMatch.close;
                    this.myHtmlMatch = htmlMatch;
                    ++this.myHtmlCount;
                    useFirstOpenTagOnOneLine = false;
                    break;
                }
                if ((blockTagsOnly || !parseNonBlock) && !isBlockTag) break;
                blockTagsOnly = false;
                if (htmlMatch == HtmlMatch.OPEN_TAG && VOID_TAGS.contains(group)) {
                    if (useFirstOpenTagOnOneLine) {
                        pendingOpen = group;
                        break;
                    }
                    this.myHtmlMatch = htmlMatch;
                    ++this.myHtmlCount;
                    break;
                }
                if (htmlMatch == HtmlMatch.OPEN_TAG) {
                    this.myHtmlMatch = htmlMatch;
                    this.myClosingPattern = htmlMatch.close;
                    if (useFirstOpenTagOnOneLine) {
                        pendingOpen = group;
                        break;
                    }
                    this.openTag(group);
                    if (this.myHtmlCount == 0) break;
                    ++this.myHtmlCount;
                    break;
                }
                int jMax = this.myOpenTags.size();
                this.myHtmlMatch = htmlMatch;
                ++this.myHtmlCount;
                int j = jMax;
                while (j-- > 0) {
                    String openTag = this.myOpenTags.get(j);
                    if (openTag.equals(group)) {
                        int k = jMax;
                        while (k-- > j) {
                            this.myOpenTags.remove(j);
                        }
                        break block1;
                    }
                    if (isBlockTag || !this.myBlockTags.contains(openTag)) continue;
                    break block1;
                }
                break;
            }
            html = nextHtml;
        }
        if (pendingOpen != null && this.myHtmlMatch == HtmlMatch.OPEN_TAG) {
            this.myClosingPattern = null;
        }
    }

    static {
        String[] blockTags = "address|article|aside|base|basefont|blockquote|body|caption|center|col|colgroup|dd|details|dialog|dir|div|dl|dt|fieldset|figcaption|figure|footer|form|frame|frameset|h1|h2|h3|h4|h5|h6|head|header|hr|html|iframe|legend|li|link|main|menu|menuitem|meta|nav|noframes|ol|optgroup|option|p|param|pre|section|source|summary|table|tbody|td|tfoot|th|thead|title|tr|track|ul".split("\\|");
        BLOCK_TAGS.addAll(Arrays.asList(blockTags));
        String[] voidTags = "area|base|br|col|embed|hr|img|input|keygen|link|menuitem|meta|param|source|track|wbr".split("\\|");
        VOID_TAGS.addAll(Arrays.asList(voidTags));
        OPTIONAL_TAGS = new HashMap<String, Set<String>>();
        OPTIONAL_TAGS.put("li", new HashSet<String>(Arrays.asList("li")));
        OPTIONAL_TAGS.put("dt", new HashSet<String>(Arrays.asList("dt", "dd")));
        OPTIONAL_TAGS.put("dd", new HashSet<String>(Arrays.asList("dd", "dt")));
        OPTIONAL_TAGS.put("p", new HashSet<String>(Arrays.asList("address", "article", "aside", "blockquote", "details", "div", "dl", "fieldset", "figcaption", "figure", "footer", "form", "h1", "h2", "h3", "h4", "h5", "h6", "header", "hr", "main", "menu", "nav", "ol", "p", "pre", "section", "table", "ul")));
        OPTIONAL_TAGS.put("rt", new HashSet<String>(Arrays.asList("rt", "rp")));
        OPTIONAL_TAGS.put("rp", new HashSet<String>(Arrays.asList("rt", "rp")));
        OPTIONAL_TAGS.put("optgroup", new HashSet<String>(Arrays.asList("optgroup")));
        OPTIONAL_TAGS.put("option", new HashSet<String>(Arrays.asList("option", "optgroup")));
        OPTIONAL_TAGS.put("colgroup", new HashSet<String>(Arrays.asList("colgroup")));
        OPTIONAL_TAGS.put("thead", new HashSet<String>(Arrays.asList("tbody", "tfoot")));
        OPTIONAL_TAGS.put("tbody", new HashSet<String>(Arrays.asList("tbody", "tfoot")));
        OPTIONAL_TAGS.put("tfoot", new HashSet<String>(Arrays.asList("tbody")));
        OPTIONAL_TAGS.put("tr", new HashSet<String>(Arrays.asList("tr")));
        OPTIONAL_TAGS.put("td", new HashSet<String>(Arrays.asList("td", "th")));
        OPTIONAL_TAGS.put("th", new HashSet<String>(Arrays.asList("td", "th")));
        PATTERN_MAP = new HtmlMatch[HtmlMatch.values().length];
        StringBuilder startPattern = new StringBuilder();
        int index = 0;
        for (HtmlMatch state : HtmlMatch.values()) {
            if (state != HtmlMatch.NONE) {
                if (startPattern.length() != 0) {
                    startPattern.append("|");
                }
                if (state.caseInsentive) {
                    startPattern.append("(?i:");
                    startPattern.append(state.open.pattern());
                    startPattern.append(")");
                } else {
                    startPattern.append(state.open.pattern());
                }
                HtmlDeepParser.PATTERN_MAP[index] = state;
            }
            ++index;
        }
        START_PATTERN = Pattern.compile(startPattern.toString());
    }

    public static enum HtmlMatch {
        NONE(null, null, false),
        SCRIPT("<(script)(?:\\s|>|$)", "</script>", true),
        STYLE("<(style)(?:\\s|>|$)", "</style>", true),
        OPEN_TAG("<([A-Za-z][A-Za-z0-9-]*)", "<|/>|\\s/>|>", true),
        CLOSE_TAG("</([A-Za-z][A-Za-z0-9-]*)>", null, true),
        NON_TAG("<(![A-Z])", ">", false),
        TEMPLATE("<([?])", "\\?>", false),
        COMMENT("<(!--)", "-->", false),
        CDATA("<!\\[(CDATA)\\[", "\\]\\]>", false);

        public final Pattern open;
        public final Pattern close;
        public final boolean caseInsentive;

        private HtmlMatch(String open, String close, boolean caseInsentive) {
            Pattern pattern = open == null ? null : (this.open = Pattern.compile(open, caseInsentive ? 2 : 0));
            this.close = close == null ? null : Pattern.compile(close, caseInsentive ? 2 : 0);
            this.caseInsentive = caseInsentive;
        }
    }
}

