/*
 * Decompiled with CFR 0.152.
 */
package liqp.filters.where;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import liqp.TemplateContext;
import liqp.filters.where.PropertyResolverAdapter;
import liqp.filters.where.PropertyResolverHelper;
import liqp.filters.where.WhereImpl;
import liqp.nodes.AtomNode;

public class JekyllWhereImpl
extends WhereImpl {
    public JekyllWhereImpl(TemplateContext templateContext, PropertyResolverHelper helper) {
        super(templateContext, helper);
    }

    @Override
    public Object apply(Object input, Object ... params) {
        if (params.length < 1) {
            return input;
        }
        Object property = params[0];
        if (this.isFalsy(property, this.context)) {
            return input;
        }
        Object value = null;
        if (params.length > 1) {
            value = params[1];
        }
        if (value != null) {
            if (value.getClass().isArray()) {
                return input;
            }
            if (value instanceof Map) {
                return input;
            }
        }
        if (input == null) {
            return "";
        }
        if (!(input instanceof Collection || input instanceof Map || this.isArray(input))) {
            return input;
        }
        if (input instanceof Map) {
            input = ((Map)((Object)input)).values();
        }
        if (input.getClass().isArray()) {
            input = JekyllWhereImpl.arrayToArrayList((Object[])input);
        }
        Collection inputColl = input;
        ArrayList res = new ArrayList();
        for (Object item : inputColl) {
            Object itemProperty = this.itemProperty(item, property);
            if (!this.comparePropertyVsTarget(itemProperty, value, this.context)) continue;
            res.add(item);
        }
        return res.toArray(new Object[res.size()]);
    }

    private boolean comparePropertyVsTarget(Object itemProperty, Object target, TemplateContext context) {
        Object[] objects;
        if (target == null) {
            return itemProperty == null;
        }
        if (AtomNode.isEmpty(target) || AtomNode.isBlank(target)) {
            return "".equals(itemProperty) || "".equals(this.joinedArray(itemProperty));
        }
        String strTarget = this.asString(target, context);
        if (this.isString(itemProperty)) {
            return strTarget.equals(itemProperty);
        }
        for (Object prop : objects = this.asArray(itemProperty, context)) {
            if (!this.asString(prop, context).equals(strTarget)) continue;
            return true;
        }
        return false;
    }

    private String joinedArray(Object itemProperty) {
        Object[] objects = itemProperty instanceof Map ? this.mapAsArray((Map)itemProperty) : this.asArray(itemProperty, this.context);
        return this.asString(objects, this.context);
    }

    private Object itemProperty(Object e, Object property) {
        PropertyResolverAdapter adapter = this.resolverHelper.findFor(e);
        if (adapter != null) {
            return this.parseSortInput(adapter.getItemProperty(this.context, e, property));
        }
        return this.parseSortInput(((Map)e).get(property));
    }

    private Object parseSortInput(Object property) {
        if (property instanceof String) {
            try {
                return Double.parseDouble((String)property);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return property;
    }

    private static <T> ArrayList<T> arrayToArrayList(T[] array) {
        ArrayList<T> list = new ArrayList<T>();
        for (T elmt : array) {
            list.add(elmt);
        }
        return list;
    }
}

